/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.queue.service.rev131107;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.CommonQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueuePacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.service.rev131107.QueueGetConfigReply;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueueGetConfigReplyBuilder {
    private Long _port;
    private QueueId _queueId;
    private Integer _property;
    private NodeRef _node;
    private Map<Class<? extends Augmentation<QueueGetConfigReply>>, Augmentation<QueueGetConfigReply>> augmentation = new HashMap<Class<? extends Augmentation<QueueGetConfigReply>>, Augmentation<QueueGetConfigReply>>();

    public QueueGetConfigReplyBuilder() {
    }

    public QueueGetConfigReplyBuilder(QueuePacket arg) {
        this._port = arg.getPort();
        this._queueId = arg.getQueueId();
        this._property = arg.getProperty();
    }

    public QueueGetConfigReplyBuilder(CommonQueue arg) {
        this._property = arg.getProperty();
    }

    public QueueGetConfigReplyBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof QueuePacket) {
            this._port = ((QueuePacket)arg).getPort();
            this._queueId = ((QueuePacket)arg).getQueueId();
            isValidArg = true;
        }
        if (arg instanceof CommonQueue) {
            this._property = ((CommonQueue)arg).getProperty();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueuePacket, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.CommonQueue, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef] \nbut was: " + arg);
        }
    }

    public Long getPort() {
        return this._port;
    }

    public QueueId getQueueId() {
        return this._queueId;
    }

    public Integer getProperty() {
        return this._property;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public <E extends Augmentation<QueueGetConfigReply>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueueGetConfigReplyBuilder setPort(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._port = value;
        return this;
    }

    public QueueGetConfigReplyBuilder setQueueId(QueueId value) {
        this._queueId = value;
        return this;
    }

    public QueueGetConfigReplyBuilder setProperty(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._property = value;
        return this;
    }

    public QueueGetConfigReplyBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public QueueGetConfigReplyBuilder addAugmentation(Class<? extends Augmentation<QueueGetConfigReply>> augmentationType, Augmentation<QueueGetConfigReply> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public QueueGetConfigReply build() {
        return new QueueGetConfigReplyImpl(this);
    }

    private static final class QueueGetConfigReplyImpl
    implements QueueGetConfigReply {
        private final Long _port;
        private final QueueId _queueId;
        private final Integer _property;
        private final NodeRef _node;
        private Map<Class<? extends Augmentation<QueueGetConfigReply>>, Augmentation<QueueGetConfigReply>> augmentation = new HashMap<Class<? extends Augmentation<QueueGetConfigReply>>, Augmentation<QueueGetConfigReply>>();

        public Class<QueueGetConfigReply> getImplementedInterface() {
            return QueueGetConfigReply.class;
        }

        private QueueGetConfigReplyImpl(QueueGetConfigReplyBuilder builder) {
            this._port = builder.getPort();
            this._queueId = builder.getQueueId();
            this._property = builder.getProperty();
            this._node = builder.getNode();
            this.augmentation.putAll(builder.augmentation);
        }

        public Long getPort() {
            return this._port;
        }

        public QueueId getQueueId() {
            return this._queueId;
        }

        public Integer getProperty() {
            return this._property;
        }

        public NodeRef getNode() {
            return this._node;
        }

        public <E extends Augmentation<QueueGetConfigReply>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            result = 31 * result + (this._queueId == null ? 0 : this._queueId.hashCode());
            result = 31 * result + (this._property == null ? 0 : this._property.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueGetConfigReplyImpl other = (QueueGetConfigReplyImpl)obj;
            if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
                return false;
            }
            if (this._queueId == null ? other._queueId != null : !this._queueId.equals((Object)other._queueId)) {
                return false;
            }
            if (this._property == null ? other._property != null : !this._property.equals(other._property)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("QueueGetConfigReply [_port=");
            builder.append(this._port);
            builder.append(", _queueId=");
            builder.append(this._queueId);
            builder.append(", _property=");
            builder.append(this._property);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

