/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowPortStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.PortRemoved;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortRemovedBuilder {
    private PortReason _reason;
    private PortFeatures _currentFeature;
    private Long _currentSpeed;
    private Long _maximumSpeed;
    private String _name;
    private PortFeatures _peerFeatures;
    private State _state;
    private PortFeatures _supported;
    private PortFeatures _advertisedFeatures;
    private PortConfig _configuration;
    private MacAddress _hardwareAddress;
    private Long _portNumber;
    private List<Queue> _queue;
    private NodeRef _node;
    private Map<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>();

    public PortRemovedBuilder() {
    }

    public PortRemovedBuilder(FlowPortStatus arg) {
        this._reason = arg.getReason();
        this._currentFeature = arg.getCurrentFeature();
        this._currentSpeed = arg.getCurrentSpeed();
        this._maximumSpeed = arg.getMaximumSpeed();
        this._name = arg.getName();
        this._peerFeatures = arg.getPeerFeatures();
        this._state = arg.getState();
        this._supported = arg.getSupported();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._configuration = arg.getConfiguration();
        this._hardwareAddress = arg.getHardwareAddress();
        this._portNumber = arg.getPortNumber();
        this._queue = arg.getQueue();
    }

    public PortRemovedBuilder(FlowCapablePort arg) {
        this._currentFeature = arg.getCurrentFeature();
        this._currentSpeed = arg.getCurrentSpeed();
        this._maximumSpeed = arg.getMaximumSpeed();
        this._name = arg.getName();
        this._peerFeatures = arg.getPeerFeatures();
        this._state = arg.getState();
        this._supported = arg.getSupported();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._configuration = arg.getConfiguration();
        this._hardwareAddress = arg.getHardwareAddress();
        this._portNumber = arg.getPortNumber();
        this._queue = arg.getQueue();
    }

    public PortRemovedBuilder(CommonPort arg) {
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._configuration = arg.getConfiguration();
        this._hardwareAddress = arg.getHardwareAddress();
        this._portNumber = arg.getPortNumber();
    }

    public PortRemovedBuilder(Queues arg) {
        this._queue = arg.getQueue();
    }

    public PortRemovedBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonPort) {
            this._advertisedFeatures = ((CommonPort)arg).getAdvertisedFeatures();
            this._configuration = ((CommonPort)arg).getConfiguration();
            this._hardwareAddress = ((CommonPort)arg).getHardwareAddress();
            this._portNumber = ((CommonPort)arg).getPortNumber();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof FlowCapablePort) {
            this._currentFeature = ((FlowCapablePort)arg).getCurrentFeature();
            this._currentSpeed = ((FlowCapablePort)arg).getCurrentSpeed();
            this._maximumSpeed = ((FlowCapablePort)arg).getMaximumSpeed();
            this._name = ((FlowCapablePort)arg).getName();
            this._peerFeatures = ((FlowCapablePort)arg).getPeerFeatures();
            this._state = ((FlowCapablePort)arg).getState();
            this._supported = ((FlowCapablePort)arg).getSupported();
            isValidArg = true;
        }
        if (arg instanceof FlowPortStatus) {
            this._reason = ((FlowPortStatus)arg).getReason();
            isValidArg = true;
        }
        if (arg instanceof Queues) {
            this._queue = ((Queues)arg).getQueue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowPortStatus, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.Queues] \nbut was: " + arg);
        }
    }

    public PortReason getReason() {
        return this._reason;
    }

    public PortFeatures getCurrentFeature() {
        return this._currentFeature;
    }

    public Long getCurrentSpeed() {
        return this._currentSpeed;
    }

    public Long getMaximumSpeed() {
        return this._maximumSpeed;
    }

    public String getName() {
        return this._name;
    }

    public PortFeatures getPeerFeatures() {
        return this._peerFeatures;
    }

    public State getState() {
        return this._state;
    }

    public PortFeatures getSupported() {
        return this._supported;
    }

    public PortFeatures getAdvertisedFeatures() {
        return this._advertisedFeatures;
    }

    public PortConfig getConfiguration() {
        return this._configuration;
    }

    public MacAddress getHardwareAddress() {
        return this._hardwareAddress;
    }

    public Long getPortNumber() {
        return this._portNumber;
    }

    public List<Queue> getQueue() {
        return this._queue;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public <E extends Augmentation<PortRemoved>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortRemovedBuilder setReason(PortReason value) {
        this._reason = value;
        return this;
    }

    public PortRemovedBuilder setCurrentFeature(PortFeatures value) {
        this._currentFeature = value;
        return this;
    }

    public PortRemovedBuilder setCurrentSpeed(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._currentSpeed = value;
        return this;
    }

    public PortRemovedBuilder setMaximumSpeed(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maximumSpeed = value;
        return this;
    }

    public PortRemovedBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PortRemovedBuilder setPeerFeatures(PortFeatures value) {
        this._peerFeatures = value;
        return this;
    }

    public PortRemovedBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public PortRemovedBuilder setSupported(PortFeatures value) {
        this._supported = value;
        return this;
    }

    public PortRemovedBuilder setAdvertisedFeatures(PortFeatures value) {
        this._advertisedFeatures = value;
        return this;
    }

    public PortRemovedBuilder setConfiguration(PortConfig value) {
        this._configuration = value;
        return this;
    }

    public PortRemovedBuilder setHardwareAddress(MacAddress value) {
        this._hardwareAddress = value;
        return this;
    }

    public PortRemovedBuilder setPortNumber(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._portNumber = value;
        return this;
    }

    public PortRemovedBuilder setQueue(List<Queue> value) {
        this._queue = value;
        return this;
    }

    public PortRemovedBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public PortRemovedBuilder addAugmentation(Class<? extends Augmentation<PortRemoved>> augmentationType, Augmentation<PortRemoved> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortRemoved build() {
        return new PortRemovedImpl(this);
    }

    private static final class PortRemovedImpl
    implements PortRemoved {
        private final PortReason _reason;
        private final PortFeatures _currentFeature;
        private final Long _currentSpeed;
        private final Long _maximumSpeed;
        private final String _name;
        private final PortFeatures _peerFeatures;
        private final State _state;
        private final PortFeatures _supported;
        private final PortFeatures _advertisedFeatures;
        private final PortConfig _configuration;
        private final MacAddress _hardwareAddress;
        private final Long _portNumber;
        private final List<Queue> _queue;
        private final NodeRef _node;
        private Map<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>();

        public Class<PortRemoved> getImplementedInterface() {
            return PortRemoved.class;
        }

        private PortRemovedImpl(PortRemovedBuilder builder) {
            this._reason = builder.getReason();
            this._currentFeature = builder.getCurrentFeature();
            this._currentSpeed = builder.getCurrentSpeed();
            this._maximumSpeed = builder.getMaximumSpeed();
            this._name = builder.getName();
            this._peerFeatures = builder.getPeerFeatures();
            this._state = builder.getState();
            this._supported = builder.getSupported();
            this._advertisedFeatures = builder.getAdvertisedFeatures();
            this._configuration = builder.getConfiguration();
            this._hardwareAddress = builder.getHardwareAddress();
            this._portNumber = builder.getPortNumber();
            this._queue = builder.getQueue();
            this._node = builder.getNode();
            this.augmentation.putAll(builder.augmentation);
        }

        public PortReason getReason() {
            return this._reason;
        }

        public PortFeatures getCurrentFeature() {
            return this._currentFeature;
        }

        public Long getCurrentSpeed() {
            return this._currentSpeed;
        }

        public Long getMaximumSpeed() {
            return this._maximumSpeed;
        }

        public String getName() {
            return this._name;
        }

        public PortFeatures getPeerFeatures() {
            return this._peerFeatures;
        }

        public State getState() {
            return this._state;
        }

        public PortFeatures getSupported() {
            return this._supported;
        }

        public PortFeatures getAdvertisedFeatures() {
            return this._advertisedFeatures;
        }

        public PortConfig getConfiguration() {
            return this._configuration;
        }

        public MacAddress getHardwareAddress() {
            return this._hardwareAddress;
        }

        public Long getPortNumber() {
            return this._portNumber;
        }

        public List<Queue> getQueue() {
            return this._queue;
        }

        public NodeRef getNode() {
            return this._node;
        }

        public <E extends Augmentation<PortRemoved>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._reason == null ? 0 : this._reason.hashCode());
            result = 31 * result + (this._currentFeature == null ? 0 : this._currentFeature.hashCode());
            result = 31 * result + (this._currentSpeed == null ? 0 : this._currentSpeed.hashCode());
            result = 31 * result + (this._maximumSpeed == null ? 0 : this._maximumSpeed.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._peerFeatures == null ? 0 : this._peerFeatures.hashCode());
            result = 31 * result + (this._state == null ? 0 : this._state.hashCode());
            result = 31 * result + (this._supported == null ? 0 : this._supported.hashCode());
            result = 31 * result + (this._advertisedFeatures == null ? 0 : this._advertisedFeatures.hashCode());
            result = 31 * result + (this._configuration == null ? 0 : this._configuration.hashCode());
            result = 31 * result + (this._hardwareAddress == null ? 0 : this._hardwareAddress.hashCode());
            result = 31 * result + (this._portNumber == null ? 0 : this._portNumber.hashCode());
            result = 31 * result + (this._queue == null ? 0 : this._queue.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortRemovedImpl other = (PortRemovedImpl)obj;
            if (this._reason == null ? other._reason != null : !this._reason.equals((Object)other._reason)) {
                return false;
            }
            if (this._currentFeature == null ? other._currentFeature != null : !this._currentFeature.equals((Object)other._currentFeature)) {
                return false;
            }
            if (this._currentSpeed == null ? other._currentSpeed != null : !this._currentSpeed.equals(other._currentSpeed)) {
                return false;
            }
            if (this._maximumSpeed == null ? other._maximumSpeed != null : !this._maximumSpeed.equals(other._maximumSpeed)) {
                return false;
            }
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            if (this._peerFeatures == null ? other._peerFeatures != null : !this._peerFeatures.equals((Object)other._peerFeatures)) {
                return false;
            }
            if (this._state == null ? other._state != null : !this._state.equals(other._state)) {
                return false;
            }
            if (this._supported == null ? other._supported != null : !this._supported.equals((Object)other._supported)) {
                return false;
            }
            if (this._advertisedFeatures == null ? other._advertisedFeatures != null : !this._advertisedFeatures.equals((Object)other._advertisedFeatures)) {
                return false;
            }
            if (this._configuration == null ? other._configuration != null : !this._configuration.equals((Object)other._configuration)) {
                return false;
            }
            if (this._hardwareAddress == null ? other._hardwareAddress != null : !this._hardwareAddress.equals((Object)other._hardwareAddress)) {
                return false;
            }
            if (this._portNumber == null ? other._portNumber != null : !this._portNumber.equals(other._portNumber)) {
                return false;
            }
            if (this._queue == null ? other._queue != null : !this._queue.equals(other._queue)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PortRemoved [_reason=");
            builder.append(this._reason);
            builder.append(", _currentFeature=");
            builder.append(this._currentFeature);
            builder.append(", _currentSpeed=");
            builder.append(this._currentSpeed);
            builder.append(", _maximumSpeed=");
            builder.append(this._maximumSpeed);
            builder.append(", _name=");
            builder.append(this._name);
            builder.append(", _peerFeatures=");
            builder.append(this._peerFeatures);
            builder.append(", _state=");
            builder.append(this._state);
            builder.append(", _supported=");
            builder.append(this._supported);
            builder.append(", _advertisedFeatures=");
            builder.append(this._advertisedFeatures);
            builder.append(", _configuration=");
            builder.append(this._configuration);
            builder.append(", _hardwareAddress=");
            builder.append(this._hardwareAddress);
            builder.append(", _portNumber=");
            builder.append(this._portNumber);
            builder.append(", _queue=");
            builder.append(this._queue);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

