/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.Cookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInput;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TransmitPacketInputBuilder {
    private Cookie _cookie;
    private NodeConnectorRef _egress;
    private NodeConnectorRef _ingress;
    private byte[] _payload;
    private NodeRef _node;
    private Map<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>();

    public TransmitPacketInputBuilder() {
    }

    public TransmitPacketInputBuilder(RawPacket arg) {
        this._ingress = arg.getIngress();
        this._payload = arg.getPayload();
    }

    public TransmitPacketInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RawPacket) {
            this._ingress = ((RawPacket)arg).getIngress();
            this._payload = ((RawPacket)arg).getPayload();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef] \nbut was: " + arg);
        }
    }

    public Cookie getCookie() {
        return this._cookie;
    }

    public NodeConnectorRef getEgress() {
        return this._egress;
    }

    public NodeConnectorRef getIngress() {
        return this._ingress;
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public <E extends Augmentation<TransmitPacketInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TransmitPacketInputBuilder setCookie(Cookie value) {
        this._cookie = value;
        return this;
    }

    public TransmitPacketInputBuilder setEgress(NodeConnectorRef value) {
        this._egress = value;
        return this;
    }

    public TransmitPacketInputBuilder setIngress(NodeConnectorRef value) {
        this._ingress = value;
        return this;
    }

    public TransmitPacketInputBuilder setPayload(byte[] value) {
        this._payload = value;
        return this;
    }

    public TransmitPacketInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public TransmitPacketInputBuilder addAugmentation(Class<? extends Augmentation<TransmitPacketInput>> augmentationType, Augmentation<TransmitPacketInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TransmitPacketInput build() {
        return new TransmitPacketInputImpl(this);
    }

    private static final class TransmitPacketInputImpl
    implements TransmitPacketInput {
        private final Cookie _cookie;
        private final NodeConnectorRef _egress;
        private final NodeConnectorRef _ingress;
        private final byte[] _payload;
        private final NodeRef _node;
        private Map<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>();

        public Class<TransmitPacketInput> getImplementedInterface() {
            return TransmitPacketInput.class;
        }

        private TransmitPacketInputImpl(TransmitPacketInputBuilder builder) {
            this._cookie = builder.getCookie();
            this._egress = builder.getEgress();
            this._ingress = builder.getIngress();
            this._payload = builder.getPayload();
            this._node = builder.getNode();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Cookie getCookie() {
            return this._cookie;
        }

        @Override
        public NodeConnectorRef getEgress() {
            return this._egress;
        }

        @Override
        public NodeConnectorRef getIngress() {
            return this._ingress;
        }

        @Override
        public byte[] getPayload() {
            return this._payload;
        }

        public NodeRef getNode() {
            return this._node;
        }

        public <E extends Augmentation<TransmitPacketInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._cookie == null ? 0 : this._cookie.hashCode());
            result = 31 * result + (this._egress == null ? 0 : this._egress.hashCode());
            result = 31 * result + (this._ingress == null ? 0 : this._ingress.hashCode());
            result = 31 * result + (this._payload == null ? 0 : Arrays.hashCode(this._payload));
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransmitPacketInputImpl other = (TransmitPacketInputImpl)obj;
            if (this._cookie == null ? other._cookie != null : !this._cookie.equals(other._cookie)) {
                return false;
            }
            if (this._egress == null ? other._egress != null : !this._egress.equals((Object)other._egress)) {
                return false;
            }
            if (this._ingress == null ? other._ingress != null : !this._ingress.equals((Object)other._ingress)) {
                return false;
            }
            if (this._payload == null ? other._payload != null : !Arrays.equals(this._payload, other._payload)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TransmitPacketInput [_cookie=");
            builder.append(this._cookie);
            builder.append(", _egress=");
            builder.append(this._egress);
            builder.append(", _ingress=");
            builder.append(this._ingress);
            builder.append(", _payload=");
            builder.append(Arrays.toString(this._payload));
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

