/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.Cookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.packet.received.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketReceivedBuilder {
    private Cookie _cookie;
    private Match _match;
    private Class<? extends PacketInReason> _packetInReason;
    private TableId _tableId;
    private NodeConnectorRef _ingress;
    private byte[] _payload;
    private Map<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>();

    public PacketReceivedBuilder() {
    }

    public PacketReceivedBuilder(RawPacket arg) {
        this._ingress = arg.getIngress();
        this._payload = arg.getPayload();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RawPacket) {
            this._ingress = ((RawPacket)arg).getIngress();
            this._payload = ((RawPacket)arg).getPayload();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket] \nbut was: " + arg);
        }
    }

    public Cookie getCookie() {
        return this._cookie;
    }

    public Match getMatch() {
        return this._match;
    }

    public Class<? extends PacketInReason> getPacketInReason() {
        return this._packetInReason;
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public NodeConnectorRef getIngress() {
        return this._ingress;
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public <E extends Augmentation<PacketReceived>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PacketReceivedBuilder setCookie(Cookie value) {
        this._cookie = value;
        return this;
    }

    public PacketReceivedBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public PacketReceivedBuilder setPacketInReason(Class<? extends PacketInReason> value) {
        this._packetInReason = value;
        return this;
    }

    public PacketReceivedBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    public PacketReceivedBuilder setIngress(NodeConnectorRef value) {
        this._ingress = value;
        return this;
    }

    public PacketReceivedBuilder setPayload(byte[] value) {
        this._payload = value;
        return this;
    }

    public PacketReceivedBuilder addAugmentation(Class<? extends Augmentation<PacketReceived>> augmentationType, Augmentation<PacketReceived> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketReceived build() {
        return new PacketReceivedImpl(this);
    }

    private static final class PacketReceivedImpl
    implements PacketReceived {
        private final Cookie _cookie;
        private final Match _match;
        private final Class<? extends PacketInReason> _packetInReason;
        private final TableId _tableId;
        private final NodeConnectorRef _ingress;
        private final byte[] _payload;
        private Map<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>();

        public Class<PacketReceived> getImplementedInterface() {
            return PacketReceived.class;
        }

        private PacketReceivedImpl(PacketReceivedBuilder builder) {
            this._cookie = builder.getCookie();
            this._match = builder.getMatch();
            this._packetInReason = builder.getPacketInReason();
            this._tableId = builder.getTableId();
            this._ingress = builder.getIngress();
            this._payload = builder.getPayload();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Cookie getCookie() {
            return this._cookie;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public Class<? extends PacketInReason> getPacketInReason() {
            return this._packetInReason;
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        @Override
        public NodeConnectorRef getIngress() {
            return this._ingress;
        }

        @Override
        public byte[] getPayload() {
            return this._payload;
        }

        public <E extends Augmentation<PacketReceived>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._cookie == null ? 0 : this._cookie.hashCode());
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this._packetInReason == null ? 0 : this._packetInReason.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._ingress == null ? 0 : this._ingress.hashCode());
            result = 31 * result + (this._payload == null ? 0 : Arrays.hashCode(this._payload));
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PacketReceivedImpl other = (PacketReceivedImpl)obj;
            if (this._cookie == null ? other._cookie != null : !this._cookie.equals(other._cookie)) {
                return false;
            }
            if (this._match == null ? other._match != null : !this._match.equals(other._match)) {
                return false;
            }
            if (this._packetInReason == null ? other._packetInReason != null : !this._packetInReason.equals(other._packetInReason)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals((Object)other._tableId)) {
                return false;
            }
            if (this._ingress == null ? other._ingress != null : !this._ingress.equals((Object)other._ingress)) {
                return false;
            }
            if (this._payload == null ? other._payload != null : !Arrays.equals(this._payload, other._payload)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PacketReceived [_cookie=");
            builder.append(this._cookie);
            builder.append(", _match=");
            builder.append(this._match);
            builder.append(", _packetInReason=");
            builder.append(this._packetInReason);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", _ingress=");
            builder.append(this._ingress);
            builder.append(", _payload=");
            builder.append(Arrays.toString(this._payload));
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

