/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.MeterUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.OriginalMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.UpdatedMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterRef;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateMeterInputBuilder {
    private MeterRef _meterRef;
    private OriginalMeter _originalMeter;
    private UpdatedMeter _updatedMeter;
    private NodeRef _node;
    private Uri _transactionUri;
    private Map<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>> augmentation = new HashMap<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>>();

    public UpdateMeterInputBuilder() {
    }

    public UpdateMeterInputBuilder(MeterUpdate arg) {
        this._originalMeter = arg.getOriginalMeter();
        this._updatedMeter = arg.getUpdatedMeter();
        this._node = arg.getNode();
    }

    public UpdateMeterInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateMeterInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MeterUpdate) {
            this._originalMeter = ((MeterUpdate)arg).getOriginalMeter();
            this._updatedMeter = ((MeterUpdate)arg).getUpdatedMeter();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.MeterUpdate, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata] \nbut was: " + arg);
        }
    }

    public MeterRef getMeterRef() {
        return this._meterRef;
    }

    public OriginalMeter getOriginalMeter() {
        return this._originalMeter;
    }

    public UpdatedMeter getUpdatedMeter() {
        return this._updatedMeter;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public <E extends Augmentation<UpdateMeterInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateMeterInputBuilder setMeterRef(MeterRef value) {
        this._meterRef = value;
        return this;
    }

    public UpdateMeterInputBuilder setOriginalMeter(OriginalMeter value) {
        this._originalMeter = value;
        return this;
    }

    public UpdateMeterInputBuilder setUpdatedMeter(UpdatedMeter value) {
        this._updatedMeter = value;
        return this;
    }

    public UpdateMeterInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public UpdateMeterInputBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public UpdateMeterInputBuilder addAugmentation(Class<? extends Augmentation<UpdateMeterInput>> augmentationType, Augmentation<UpdateMeterInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateMeterInput build() {
        return new UpdateMeterInputImpl(this);
    }

    private static final class UpdateMeterInputImpl
    implements UpdateMeterInput {
        private final MeterRef _meterRef;
        private final OriginalMeter _originalMeter;
        private final UpdatedMeter _updatedMeter;
        private final NodeRef _node;
        private final Uri _transactionUri;
        private Map<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>> augmentation = new HashMap<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>>();

        public Class<UpdateMeterInput> getImplementedInterface() {
            return UpdateMeterInput.class;
        }

        private UpdateMeterInputImpl(UpdateMeterInputBuilder builder) {
            this._meterRef = builder.getMeterRef();
            this._originalMeter = builder.getOriginalMeter();
            this._updatedMeter = builder.getUpdatedMeter();
            this._node = builder.getNode();
            this._transactionUri = builder.getTransactionUri();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MeterRef getMeterRef() {
            return this._meterRef;
        }

        @Override
        public OriginalMeter getOriginalMeter() {
            return this._originalMeter;
        }

        @Override
        public UpdatedMeter getUpdatedMeter() {
            return this._updatedMeter;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        public <E extends Augmentation<UpdateMeterInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._meterRef == null ? 0 : this._meterRef.hashCode());
            result = 31 * result + (this._originalMeter == null ? 0 : this._originalMeter.hashCode());
            result = 31 * result + (this._updatedMeter == null ? 0 : this._updatedMeter.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateMeterInputImpl other = (UpdateMeterInputImpl)obj;
            if (this._meterRef == null ? other._meterRef != null : !this._meterRef.equals((Object)other._meterRef)) {
                return false;
            }
            if (this._originalMeter == null ? other._originalMeter != null : !this._originalMeter.equals(other._originalMeter)) {
                return false;
            }
            if (this._updatedMeter == null ? other._updatedMeter != null : !this._updatedMeter.equals(other._updatedMeter)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            if (this._transactionUri == null ? other._transactionUri != null : !this._transactionUri.equals((Object)other._transactionUri)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UpdateMeterInput [_meterRef=");
            builder.append(this._meterRef);
            builder.append(", _originalMeter=");
            builder.append(this._originalMeter);
            builder.append(", _updatedMeter=");
            builder.append(this._updatedMeter);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", _transactionUri=");
            builder.append(this._transactionUri);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

