/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.MeterAdded;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.MeterBandHeaders;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterAddedBuilder {
    private MeterRef _meterRef;
    private Boolean _barrier;
    private String _containerName;
    private MeterFlags _flags;
    private MeterBandHeaders _meterBandHeaders;
    private MeterId _meterId;
    private String _meterName;
    private NodeRef _node;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private Map<Class<? extends Augmentation<MeterAdded>>, Augmentation<MeterAdded>> augmentation = new HashMap<Class<? extends Augmentation<MeterAdded>>, Augmentation<MeterAdded>>();

    public MeterAddedBuilder() {
    }

    public MeterAddedBuilder(Meter arg) {
        this._barrier = arg.isBarrier();
        this._containerName = arg.getContainerName();
        this._flags = arg.getFlags();
        this._meterBandHeaders = arg.getMeterBandHeaders();
        this._meterId = arg.getMeterId();
        this._meterName = arg.getMeterName();
    }

    public MeterAddedBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public MeterAddedBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public MeterAddedBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Meter) {
            this._barrier = ((Meter)arg).isBarrier();
            this._containerName = ((Meter)arg).getContainerName();
            this._flags = ((Meter)arg).getFlags();
            this._meterBandHeaders = ((Meter)arg).getMeterBandHeaders();
            this._meterId = ((Meter)arg).getMeterId();
            this._meterName = ((Meter)arg).getMeterName();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionAware] \nbut was: " + arg);
        }
    }

    public MeterRef getMeterRef() {
        return this._meterRef;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterBandHeaders getMeterBandHeaders() {
        return this._meterBandHeaders;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public String getMeterName() {
        return this._meterName;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public <E extends Augmentation<MeterAdded>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterAddedBuilder setMeterRef(MeterRef value) {
        this._meterRef = value;
        return this;
    }

    public MeterAddedBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public MeterAddedBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public MeterAddedBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public MeterAddedBuilder setMeterBandHeaders(MeterBandHeaders value) {
        this._meterBandHeaders = value;
        return this;
    }

    public MeterAddedBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterAddedBuilder setMeterName(String value) {
        this._meterName = value;
        return this;
    }

    public MeterAddedBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public MeterAddedBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public MeterAddedBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public MeterAddedBuilder addAugmentation(Class<? extends Augmentation<MeterAdded>> augmentationType, Augmentation<MeterAdded> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterAdded build() {
        return new MeterAddedImpl(this);
    }

    private static final class MeterAddedImpl
    implements MeterAdded {
        private final MeterRef _meterRef;
        private final Boolean _barrier;
        private final String _containerName;
        private final MeterFlags _flags;
        private final MeterBandHeaders _meterBandHeaders;
        private final MeterId _meterId;
        private final String _meterName;
        private final NodeRef _node;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private Map<Class<? extends Augmentation<MeterAdded>>, Augmentation<MeterAdded>> augmentation = new HashMap<Class<? extends Augmentation<MeterAdded>>, Augmentation<MeterAdded>>();

        public Class<MeterAdded> getImplementedInterface() {
            return MeterAdded.class;
        }

        private MeterAddedImpl(MeterAddedBuilder builder) {
            this._meterRef = builder.getMeterRef();
            this._barrier = builder.isBarrier();
            this._containerName = builder.getContainerName();
            this._flags = builder.getFlags();
            this._meterBandHeaders = builder.getMeterBandHeaders();
            this._meterId = builder.getMeterId();
            this._meterName = builder.getMeterName();
            this._node = builder.getNode();
            this._transactionId = builder.getTransactionId();
            this._transactionUri = builder.getTransactionUri();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MeterRef getMeterRef() {
            return this._meterRef;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public MeterFlags getFlags() {
            return this._flags;
        }

        public MeterBandHeaders getMeterBandHeaders() {
            return this._meterBandHeaders;
        }

        public MeterId getMeterId() {
            return this._meterId;
        }

        public String getMeterName() {
            return this._meterName;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        public <E extends Augmentation<MeterAdded>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._meterRef == null ? 0 : this._meterRef.hashCode());
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._meterBandHeaders == null ? 0 : this._meterBandHeaders.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._meterName == null ? 0 : this._meterName.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterAddedImpl other = (MeterAddedImpl)obj;
            if (this._meterRef == null ? other._meterRef != null : !this._meterRef.equals((Object)other._meterRef)) {
                return false;
            }
            if (this._barrier == null ? other._barrier != null : !this._barrier.equals(other._barrier)) {
                return false;
            }
            if (this._containerName == null ? other._containerName != null : !this._containerName.equals(other._containerName)) {
                return false;
            }
            if (this._flags == null ? other._flags != null : !this._flags.equals((Object)other._flags)) {
                return false;
            }
            if (this._meterBandHeaders == null ? other._meterBandHeaders != null : !this._meterBandHeaders.equals(other._meterBandHeaders)) {
                return false;
            }
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals((Object)other._meterId)) {
                return false;
            }
            if (this._meterName == null ? other._meterName != null : !this._meterName.equals(other._meterName)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            if (this._transactionId == null ? other._transactionId != null : !this._transactionId.equals(other._transactionId)) {
                return false;
            }
            if (this._transactionUri == null ? other._transactionUri != null : !this._transactionUri.equals((Object)other._transactionUri)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterAdded [_meterRef=");
            builder.append(this._meterRef);
            builder.append(", _barrier=");
            builder.append(this._barrier);
            builder.append(", _containerName=");
            builder.append(this._containerName);
            builder.append(", _flags=");
            builder.append(this._flags);
            builder.append(", _meterBandHeaders=");
            builder.append(this._meterBandHeaders);
            builder.append(", _meterId=");
            builder.append(this._meterId);
            builder.append(", _meterName=");
            builder.append(this._meterName);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", _transactionId=");
            builder.append(this._transactionId);
            builder.append(", _transactionUri=");
            builder.append(this._transactionUri);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

