/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.OriginalGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OriginalGroupBuilder {
    private Boolean _barrier;
    private Buckets _buckets;
    private String _containerName;
    private GroupId _groupId;
    private String _groupName;
    private GroupTypes _groupType;
    private Map<Class<? extends Augmentation<OriginalGroup>>, Augmentation<OriginalGroup>> augmentation = new HashMap<Class<? extends Augmentation<OriginalGroup>>, Augmentation<OriginalGroup>>();

    public OriginalGroupBuilder() {
    }

    public OriginalGroupBuilder(Group arg) {
        this._barrier = arg.isBarrier();
        this._buckets = arg.getBuckets();
        this._containerName = arg.getContainerName();
        this._groupId = arg.getGroupId();
        this._groupName = arg.getGroupName();
        this._groupType = arg.getGroupType();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Group) {
            this._barrier = ((Group)arg).isBarrier();
            this._buckets = ((Group)arg).getBuckets();
            this._containerName = ((Group)arg).getContainerName();
            this._groupId = ((Group)arg).getGroupId();
            this._groupName = ((Group)arg).getGroupName();
            this._groupType = ((Group)arg).getGroupType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group] \nbut was: " + arg);
        }
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public Buckets getBuckets() {
        return this._buckets;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public GroupTypes getGroupType() {
        return this._groupType;
    }

    public <E extends Augmentation<OriginalGroup>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OriginalGroupBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public OriginalGroupBuilder setBuckets(Buckets value) {
        this._buckets = value;
        return this;
    }

    public OriginalGroupBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public OriginalGroupBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public OriginalGroupBuilder setGroupName(String value) {
        this._groupName = value;
        return this;
    }

    public OriginalGroupBuilder setGroupType(GroupTypes value) {
        this._groupType = value;
        return this;
    }

    public OriginalGroupBuilder addAugmentation(Class<? extends Augmentation<OriginalGroup>> augmentationType, Augmentation<OriginalGroup> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OriginalGroup build() {
        return new OriginalGroupImpl(this);
    }

    private static final class OriginalGroupImpl
    implements OriginalGroup {
        private final Boolean _barrier;
        private final Buckets _buckets;
        private final String _containerName;
        private final GroupId _groupId;
        private final String _groupName;
        private final GroupTypes _groupType;
        private Map<Class<? extends Augmentation<OriginalGroup>>, Augmentation<OriginalGroup>> augmentation = new HashMap<Class<? extends Augmentation<OriginalGroup>>, Augmentation<OriginalGroup>>();

        public Class<OriginalGroup> getImplementedInterface() {
            return OriginalGroup.class;
        }

        private OriginalGroupImpl(OriginalGroupBuilder builder) {
            this._barrier = builder.isBarrier();
            this._buckets = builder.getBuckets();
            this._containerName = builder.getContainerName();
            this._groupId = builder.getGroupId();
            this._groupName = builder.getGroupName();
            this._groupType = builder.getGroupType();
            this.augmentation.putAll(builder.augmentation);
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public Buckets getBuckets() {
            return this._buckets;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public GroupId getGroupId() {
            return this._groupId;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public GroupTypes getGroupType() {
            return this._groupType;
        }

        public <E extends Augmentation<OriginalGroup>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            result = 31 * result + (this._buckets == null ? 0 : this._buckets.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this._groupName == null ? 0 : this._groupName.hashCode());
            result = 31 * result + (this._groupType == null ? 0 : this._groupType.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OriginalGroupImpl other = (OriginalGroupImpl)obj;
            if (this._barrier == null ? other._barrier != null : !this._barrier.equals(other._barrier)) {
                return false;
            }
            if (this._buckets == null ? other._buckets != null : !this._buckets.equals(other._buckets)) {
                return false;
            }
            if (this._containerName == null ? other._containerName != null : !this._containerName.equals(other._containerName)) {
                return false;
            }
            if (this._groupId == null ? other._groupId != null : !this._groupId.equals((Object)other._groupId)) {
                return false;
            }
            if (this._groupName == null ? other._groupName != null : !this._groupName.equals(other._groupName)) {
                return false;
            }
            if (this._groupType == null ? other._groupType != null : !this._groupType.equals((Object)other._groupType)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("OriginalGroup [_barrier=");
            builder.append(this._barrier);
            builder.append(", _buckets=");
            builder.append(this._buckets);
            builder.append(", _containerName=");
            builder.append(this._containerName);
            builder.append(", _groupId=");
            builder.append(this._groupId);
            builder.append(", _groupName=");
            builder.append(this._groupName);
            builder.append(", _groupType=");
            builder.append(this._groupType);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

