/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.OriginalGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.UpdatedGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateGroupInputBuilder {
    private GroupRef _groupRef;
    private Uri _transactionUri;
    private OriginalGroup _originalGroup;
    private UpdatedGroup _updatedGroup;
    private NodeRef _node;
    private Map<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>();

    public UpdateGroupInputBuilder() {
    }

    public UpdateGroupInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public UpdateGroupInputBuilder(GroupUpdate arg) {
        this._originalGroup = arg.getOriginalGroup();
        this._updatedGroup = arg.getUpdatedGroup();
        this._node = arg.getNode();
    }

    public UpdateGroupInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GroupUpdate) {
            this._originalGroup = ((GroupUpdate)arg).getOriginalGroup();
            this._updatedGroup = ((GroupUpdate)arg).getUpdatedGroup();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupUpdate, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata] \nbut was: " + arg);
        }
    }

    public GroupRef getGroupRef() {
        return this._groupRef;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public OriginalGroup getOriginalGroup() {
        return this._originalGroup;
    }

    public UpdatedGroup getUpdatedGroup() {
        return this._updatedGroup;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public <E extends Augmentation<UpdateGroupInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateGroupInputBuilder setGroupRef(GroupRef value) {
        this._groupRef = value;
        return this;
    }

    public UpdateGroupInputBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public UpdateGroupInputBuilder setOriginalGroup(OriginalGroup value) {
        this._originalGroup = value;
        return this;
    }

    public UpdateGroupInputBuilder setUpdatedGroup(UpdatedGroup value) {
        this._updatedGroup = value;
        return this;
    }

    public UpdateGroupInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public UpdateGroupInputBuilder addAugmentation(Class<? extends Augmentation<UpdateGroupInput>> augmentationType, Augmentation<UpdateGroupInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateGroupInput build() {
        return new UpdateGroupInputImpl(this);
    }

    private static final class UpdateGroupInputImpl
    implements UpdateGroupInput {
        private final GroupRef _groupRef;
        private final Uri _transactionUri;
        private final OriginalGroup _originalGroup;
        private final UpdatedGroup _updatedGroup;
        private final NodeRef _node;
        private Map<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>();

        public Class<UpdateGroupInput> getImplementedInterface() {
            return UpdateGroupInput.class;
        }

        private UpdateGroupInputImpl(UpdateGroupInputBuilder builder) {
            this._groupRef = builder.getGroupRef();
            this._transactionUri = builder.getTransactionUri();
            this._originalGroup = builder.getOriginalGroup();
            this._updatedGroup = builder.getUpdatedGroup();
            this._node = builder.getNode();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public GroupRef getGroupRef() {
            return this._groupRef;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public OriginalGroup getOriginalGroup() {
            return this._originalGroup;
        }

        @Override
        public UpdatedGroup getUpdatedGroup() {
            return this._updatedGroup;
        }

        public NodeRef getNode() {
            return this._node;
        }

        public <E extends Augmentation<UpdateGroupInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._groupRef == null ? 0 : this._groupRef.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this._originalGroup == null ? 0 : this._originalGroup.hashCode());
            result = 31 * result + (this._updatedGroup == null ? 0 : this._updatedGroup.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateGroupInputImpl other = (UpdateGroupInputImpl)obj;
            if (this._groupRef == null ? other._groupRef != null : !this._groupRef.equals((Object)other._groupRef)) {
                return false;
            }
            if (this._transactionUri == null ? other._transactionUri != null : !this._transactionUri.equals((Object)other._transactionUri)) {
                return false;
            }
            if (this._originalGroup == null ? other._originalGroup != null : !this._originalGroup.equals(other._originalGroup)) {
                return false;
            }
            if (this._updatedGroup == null ? other._updatedGroup != null : !this._updatedGroup.equals(other._updatedGroup)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UpdateGroupInput [_groupRef=");
            builder.append(this._groupRef);
            builder.append(", _transactionUri=");
            builder.append(this._transactionUri);
            builder.append(", _originalGroup=");
            builder.append(this._originalGroup);
            builder.append(", _updatedGroup=");
            builder.append(this._updatedGroup);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

