/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupRemovedBuilder {
    private GroupRef _groupRef;
    private Boolean _barrier;
    private Buckets _buckets;
    private String _containerName;
    private GroupId _groupId;
    private String _groupName;
    private GroupTypes _groupType;
    private NodeRef _node;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private Map<Class<? extends Augmentation<GroupRemoved>>, Augmentation<GroupRemoved>> augmentation = new HashMap<Class<? extends Augmentation<GroupRemoved>>, Augmentation<GroupRemoved>>();

    public GroupRemovedBuilder() {
    }

    public GroupRemovedBuilder(Group arg) {
        this._barrier = arg.isBarrier();
        this._buckets = arg.getBuckets();
        this._containerName = arg.getContainerName();
        this._groupId = arg.getGroupId();
        this._groupName = arg.getGroupName();
        this._groupType = arg.getGroupType();
    }

    public GroupRemovedBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public GroupRemovedBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public GroupRemovedBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Group) {
            this._barrier = ((Group)arg).isBarrier();
            this._buckets = ((Group)arg).getBuckets();
            this._containerName = ((Group)arg).getContainerName();
            this._groupId = ((Group)arg).getGroupId();
            this._groupName = ((Group)arg).getGroupName();
            this._groupType = ((Group)arg).getGroupType();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionAware] \nbut was: " + arg);
        }
    }

    public GroupRef getGroupRef() {
        return this._groupRef;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public Buckets getBuckets() {
        return this._buckets;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public GroupTypes getGroupType() {
        return this._groupType;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public <E extends Augmentation<GroupRemoved>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupRemovedBuilder setGroupRef(GroupRef value) {
        this._groupRef = value;
        return this;
    }

    public GroupRemovedBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public GroupRemovedBuilder setBuckets(Buckets value) {
        this._buckets = value;
        return this;
    }

    public GroupRemovedBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public GroupRemovedBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupRemovedBuilder setGroupName(String value) {
        this._groupName = value;
        return this;
    }

    public GroupRemovedBuilder setGroupType(GroupTypes value) {
        this._groupType = value;
        return this;
    }

    public GroupRemovedBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public GroupRemovedBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public GroupRemovedBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public GroupRemovedBuilder addAugmentation(Class<? extends Augmentation<GroupRemoved>> augmentationType, Augmentation<GroupRemoved> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupRemoved build() {
        return new GroupRemovedImpl(this);
    }

    private static final class GroupRemovedImpl
    implements GroupRemoved {
        private final GroupRef _groupRef;
        private final Boolean _barrier;
        private final Buckets _buckets;
        private final String _containerName;
        private final GroupId _groupId;
        private final String _groupName;
        private final GroupTypes _groupType;
        private final NodeRef _node;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private Map<Class<? extends Augmentation<GroupRemoved>>, Augmentation<GroupRemoved>> augmentation = new HashMap<Class<? extends Augmentation<GroupRemoved>>, Augmentation<GroupRemoved>>();

        public Class<GroupRemoved> getImplementedInterface() {
            return GroupRemoved.class;
        }

        private GroupRemovedImpl(GroupRemovedBuilder builder) {
            this._groupRef = builder.getGroupRef();
            this._barrier = builder.isBarrier();
            this._buckets = builder.getBuckets();
            this._containerName = builder.getContainerName();
            this._groupId = builder.getGroupId();
            this._groupName = builder.getGroupName();
            this._groupType = builder.getGroupType();
            this._node = builder.getNode();
            this._transactionId = builder.getTransactionId();
            this._transactionUri = builder.getTransactionUri();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public GroupRef getGroupRef() {
            return this._groupRef;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public Buckets getBuckets() {
            return this._buckets;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public GroupId getGroupId() {
            return this._groupId;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public GroupTypes getGroupType() {
            return this._groupType;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        public <E extends Augmentation<GroupRemoved>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._groupRef == null ? 0 : this._groupRef.hashCode());
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            result = 31 * result + (this._buckets == null ? 0 : this._buckets.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this._groupName == null ? 0 : this._groupName.hashCode());
            result = 31 * result + (this._groupType == null ? 0 : this._groupType.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupRemovedImpl other = (GroupRemovedImpl)obj;
            if (this._groupRef == null ? other._groupRef != null : !this._groupRef.equals((Object)other._groupRef)) {
                return false;
            }
            if (this._barrier == null ? other._barrier != null : !this._barrier.equals(other._barrier)) {
                return false;
            }
            if (this._buckets == null ? other._buckets != null : !this._buckets.equals(other._buckets)) {
                return false;
            }
            if (this._containerName == null ? other._containerName != null : !this._containerName.equals(other._containerName)) {
                return false;
            }
            if (this._groupId == null ? other._groupId != null : !this._groupId.equals((Object)other._groupId)) {
                return false;
            }
            if (this._groupName == null ? other._groupName != null : !this._groupName.equals(other._groupName)) {
                return false;
            }
            if (this._groupType == null ? other._groupType != null : !this._groupType.equals((Object)other._groupType)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            if (this._transactionId == null ? other._transactionId != null : !this._transactionId.equals(other._transactionId)) {
                return false;
            }
            if (this._transactionUri == null ? other._transactionUri != null : !this._transactionUri.equals((Object)other._transactionUri)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupRemoved [_groupRef=");
            builder.append(this._groupRef);
            builder.append(", _barrier=");
            builder.append(this._barrier);
            builder.append(", _buckets=");
            builder.append(this._buckets);
            builder.append(", _containerName=");
            builder.append(this._containerName);
            builder.append(", _groupId=");
            builder.append(this._groupId);
            builder.append(", _groupName=");
            builder.append(this._groupName);
            builder.append(", _groupType=");
            builder.append(this._groupType);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", _transactionId=");
            builder.append(this._transactionId);
            builder.append(", _transactionUri=");
            builder.append(this._transactionUri);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

