/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowTableRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowModRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.GenericFlowAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.RemovedReasonFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.mod.removed.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SwitchFlowRemovedBuilder {
    private FlowTableRef _flowTable;
    private NodeRef _node;
    private BigInteger _byteCount;
    private Long _durationNsec;
    private Long _durationSec;
    private Match _match;
    private BigInteger _packetCount;
    private RemovedReasonFlags _removedReason;
    private BigInteger _cookie;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private Integer _priority;
    private Short _tableId;
    private Map<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>> augmentation = new HashMap<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>>();

    public SwitchFlowRemovedBuilder() {
    }

    public SwitchFlowRemovedBuilder(NodeFlowRemoved arg) {
        this._flowTable = arg.getFlowTable();
        this._node = arg.getNode();
        this._byteCount = arg.getByteCount();
        this._durationNsec = arg.getDurationNsec();
        this._durationSec = arg.getDurationSec();
        this._match = arg.getMatch();
        this._packetCount = arg.getPacketCount();
        this._removedReason = arg.getRemovedReason();
        this._cookie = arg.getCookie();
        this._hardTimeout = arg.getHardTimeout();
        this._idleTimeout = arg.getIdleTimeout();
        this._priority = arg.getPriority();
        this._tableId = arg.getTableId();
    }

    public SwitchFlowRemovedBuilder(FlowModRemoved arg) {
        this._byteCount = arg.getByteCount();
        this._durationNsec = arg.getDurationNsec();
        this._durationSec = arg.getDurationSec();
        this._match = arg.getMatch();
        this._packetCount = arg.getPacketCount();
        this._removedReason = arg.getRemovedReason();
        this._cookie = arg.getCookie();
        this._hardTimeout = arg.getHardTimeout();
        this._idleTimeout = arg.getIdleTimeout();
        this._priority = arg.getPriority();
        this._tableId = arg.getTableId();
    }

    public SwitchFlowRemovedBuilder(GenericFlowAttributes arg) {
        this._cookie = arg.getCookie();
        this._hardTimeout = arg.getHardTimeout();
        this._idleTimeout = arg.getIdleTimeout();
        this._priority = arg.getPriority();
        this._tableId = arg.getTableId();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GenericFlowAttributes) {
            this._cookie = ((GenericFlowAttributes)arg).getCookie();
            this._hardTimeout = ((GenericFlowAttributes)arg).getHardTimeout();
            this._idleTimeout = ((GenericFlowAttributes)arg).getIdleTimeout();
            this._priority = ((GenericFlowAttributes)arg).getPriority();
            this._tableId = ((GenericFlowAttributes)arg).getTableId();
            isValidArg = true;
        }
        if (arg instanceof FlowModRemoved) {
            this._byteCount = ((FlowModRemoved)arg).getByteCount();
            this._durationNsec = ((FlowModRemoved)arg).getDurationNsec();
            this._durationSec = ((FlowModRemoved)arg).getDurationSec();
            this._match = ((FlowModRemoved)arg).getMatch();
            this._packetCount = ((FlowModRemoved)arg).getPacketCount();
            this._removedReason = ((FlowModRemoved)arg).getRemovedReason();
            isValidArg = true;
        }
        if (arg instanceof NodeFlowRemoved) {
            this._flowTable = ((NodeFlowRemoved)arg).getFlowTable();
            this._node = ((NodeFlowRemoved)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.GenericFlowAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowModRemoved, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeFlowRemoved] \nbut was: " + arg);
        }
    }

    public FlowTableRef getFlowTable() {
        return this._flowTable;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Match getMatch() {
        return this._match;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public RemovedReasonFlags getRemovedReason() {
        return this._removedReason;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<SwitchFlowRemoved>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SwitchFlowRemovedBuilder setFlowTable(FlowTableRef value) {
        this._flowTable = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setByteCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._byteCount = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setDurationNsec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationNsec = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setDurationSec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationSec = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._packetCount = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setRemovedReason(RemovedReasonFlags value) {
        this._removedReason = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setCookie(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._cookie = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setHardTimeout(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._hardTimeout = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._idleTimeout = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setPriority(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._priority = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setTableId(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tableId = value;
        return this;
    }

    public SwitchFlowRemovedBuilder addAugmentation(Class<? extends Augmentation<SwitchFlowRemoved>> augmentationType, Augmentation<SwitchFlowRemoved> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SwitchFlowRemoved build() {
        return new SwitchFlowRemovedImpl(this);
    }

    private static final class SwitchFlowRemovedImpl
    implements SwitchFlowRemoved {
        private final FlowTableRef _flowTable;
        private final NodeRef _node;
        private final BigInteger _byteCount;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Match _match;
        private final BigInteger _packetCount;
        private final RemovedReasonFlags _removedReason;
        private final BigInteger _cookie;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final Integer _priority;
        private final Short _tableId;
        private Map<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>> augmentation = new HashMap<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>>();

        public Class<SwitchFlowRemoved> getImplementedInterface() {
            return SwitchFlowRemoved.class;
        }

        private SwitchFlowRemovedImpl(SwitchFlowRemovedBuilder builder) {
            this._flowTable = builder.getFlowTable();
            this._node = builder.getNode();
            this._byteCount = builder.getByteCount();
            this._durationNsec = builder.getDurationNsec();
            this._durationSec = builder.getDurationSec();
            this._match = builder.getMatch();
            this._packetCount = builder.getPacketCount();
            this._removedReason = builder.getRemovedReason();
            this._cookie = builder.getCookie();
            this._hardTimeout = builder.getHardTimeout();
            this._idleTimeout = builder.getIdleTimeout();
            this._priority = builder.getPriority();
            this._tableId = builder.getTableId();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public FlowTableRef getFlowTable() {
            return this._flowTable;
        }

        @Override
        public NodeRef getNode() {
            return this._node;
        }

        public BigInteger getByteCount() {
            return this._byteCount;
        }

        public Long getDurationNsec() {
            return this._durationNsec;
        }

        public Long getDurationSec() {
            return this._durationSec;
        }

        public Match getMatch() {
            return this._match;
        }

        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        public RemovedReasonFlags getRemovedReason() {
            return this._removedReason;
        }

        public BigInteger getCookie() {
            return this._cookie;
        }

        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        public Integer getPriority() {
            return this._priority;
        }

        public Short getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<SwitchFlowRemoved>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flowTable == null ? 0 : this._flowTable.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._byteCount == null ? 0 : this._byteCount.hashCode());
            result = 31 * result + (this._durationNsec == null ? 0 : this._durationNsec.hashCode());
            result = 31 * result + (this._durationSec == null ? 0 : this._durationSec.hashCode());
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this._packetCount == null ? 0 : this._packetCount.hashCode());
            result = 31 * result + (this._removedReason == null ? 0 : this._removedReason.hashCode());
            result = 31 * result + (this._cookie == null ? 0 : this._cookie.hashCode());
            result = 31 * result + (this._hardTimeout == null ? 0 : this._hardTimeout.hashCode());
            result = 31 * result + (this._idleTimeout == null ? 0 : this._idleTimeout.hashCode());
            result = 31 * result + (this._priority == null ? 0 : this._priority.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SwitchFlowRemovedImpl other = (SwitchFlowRemovedImpl)obj;
            if (this._flowTable == null ? other._flowTable != null : !this._flowTable.equals(other._flowTable)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            if (this._byteCount == null ? other._byteCount != null : !this._byteCount.equals(other._byteCount)) {
                return false;
            }
            if (this._durationNsec == null ? other._durationNsec != null : !this._durationNsec.equals(other._durationNsec)) {
                return false;
            }
            if (this._durationSec == null ? other._durationSec != null : !this._durationSec.equals(other._durationSec)) {
                return false;
            }
            if (this._match == null ? other._match != null : !this._match.equals(other._match)) {
                return false;
            }
            if (this._packetCount == null ? other._packetCount != null : !this._packetCount.equals(other._packetCount)) {
                return false;
            }
            if (this._removedReason == null ? other._removedReason != null : !this._removedReason.equals((Object)other._removedReason)) {
                return false;
            }
            if (this._cookie == null ? other._cookie != null : !this._cookie.equals(other._cookie)) {
                return false;
            }
            if (this._hardTimeout == null ? other._hardTimeout != null : !this._hardTimeout.equals(other._hardTimeout)) {
                return false;
            }
            if (this._idleTimeout == null ? other._idleTimeout != null : !this._idleTimeout.equals(other._idleTimeout)) {
                return false;
            }
            if (this._priority == null ? other._priority != null : !this._priority.equals(other._priority)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SwitchFlowRemoved [_flowTable=");
            builder.append(this._flowTable);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", _byteCount=");
            builder.append(this._byteCount);
            builder.append(", _durationNsec=");
            builder.append(this._durationNsec);
            builder.append(", _durationSec=");
            builder.append(this._durationSec);
            builder.append(", _match=");
            builder.append(this._match);
            builder.append(", _packetCount=");
            builder.append(this._packetCount);
            builder.append(", _removedReason=");
            builder.append(this._removedReason);
            builder.append(", _cookie=");
            builder.append(this._cookie);
            builder.append(", _hardTimeout=");
            builder.append(this._hardTimeout);
            builder.append(", _idleTimeout=");
            builder.append(this._idleTimeout);
            builder.append(", _priority=");
            builder.append(this._priority);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

