/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ExperimenterErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeExperimenterErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeExperimenterErrorNotificationBuilder {
    private TransactionId _transactionId;
    private String _data;
    private Integer _expType;
    private Long _experimenterId;
    private ErrorType _type;
    private Map<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>> augmentation = new HashMap<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>>();

    public NodeExperimenterErrorNotificationBuilder() {
    }

    public NodeExperimenterErrorNotificationBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public NodeExperimenterErrorNotificationBuilder(ExperimenterErrorMessage arg) {
        this._data = arg.getData();
        this._expType = arg.getExpType();
        this._experimenterId = arg.getExperimenterId();
        this._type = arg.getType();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ExperimenterErrorMessage) {
            this._data = ((ExperimenterErrorMessage)arg).getData();
            this._expType = ((ExperimenterErrorMessage)arg).getExpType();
            this._experimenterId = ((ExperimenterErrorMessage)arg).getExperimenterId();
            this._type = ((ExperimenterErrorMessage)arg).getType();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ExperimenterErrorMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionAware] \nbut was: " + arg);
        }
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public String getData() {
        return this._data;
    }

    public Integer getExpType() {
        return this._expType;
    }

    public Long getExperimenterId() {
        return this._experimenterId;
    }

    public ErrorType getType() {
        return this._type;
    }

    public <E extends Augmentation<NodeExperimenterErrorNotification>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeExperimenterErrorNotificationBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder setData(String value) {
        this._data = value;
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder setExpType(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._expType = value;
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder setExperimenterId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._experimenterId = value;
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder setType(ErrorType value) {
        this._type = value;
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder addAugmentation(Class<? extends Augmentation<NodeExperimenterErrorNotification>> augmentationType, Augmentation<NodeExperimenterErrorNotification> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeExperimenterErrorNotification build() {
        return new NodeExperimenterErrorNotificationImpl(this);
    }

    private static final class NodeExperimenterErrorNotificationImpl
    implements NodeExperimenterErrorNotification {
        private final TransactionId _transactionId;
        private final String _data;
        private final Integer _expType;
        private final Long _experimenterId;
        private final ErrorType _type;
        private Map<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>> augmentation = new HashMap<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>>();

        public Class<NodeExperimenterErrorNotification> getImplementedInterface() {
            return NodeExperimenterErrorNotification.class;
        }

        private NodeExperimenterErrorNotificationImpl(NodeExperimenterErrorNotificationBuilder builder) {
            this._transactionId = builder.getTransactionId();
            this._data = builder.getData();
            this._expType = builder.getExpType();
            this._experimenterId = builder.getExperimenterId();
            this._type = builder.getType();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public Integer getExpType() {
            return this._expType;
        }

        @Override
        public Long getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public ErrorType getType() {
            return this._type;
        }

        public <E extends Augmentation<NodeExperimenterErrorNotification>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            result = 31 * result + (this._data == null ? 0 : this._data.hashCode());
            result = 31 * result + (this._expType == null ? 0 : this._expType.hashCode());
            result = 31 * result + (this._experimenterId == null ? 0 : this._experimenterId.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeExperimenterErrorNotificationImpl other = (NodeExperimenterErrorNotificationImpl)obj;
            if (this._transactionId == null ? other._transactionId != null : !this._transactionId.equals(other._transactionId)) {
                return false;
            }
            if (this._data == null ? other._data != null : !this._data.equals(other._data)) {
                return false;
            }
            if (this._expType == null ? other._expType != null : !this._expType.equals(other._expType)) {
                return false;
            }
            if (this._experimenterId == null ? other._experimenterId != null : !this._experimenterId.equals(other._experimenterId)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NodeExperimenterErrorNotification [_transactionId=");
            builder.append(this._transactionId);
            builder.append(", _data=");
            builder.append(this._data);
            builder.append(", _expType=");
            builder.append(this._expType);
            builder.append(", _experimenterId=");
            builder.append(this._experimenterId);
            builder.append(", _type=");
            builder.append((Object)this._type);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

