/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeErrorNotificationBuilder {
    private Integer _code;
    private String _data;
    private ErrorType _type;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private Map<Class<? extends Augmentation<NodeErrorNotification>>, Augmentation<NodeErrorNotification>> augmentation = new HashMap<Class<? extends Augmentation<NodeErrorNotification>>, Augmentation<NodeErrorNotification>>();

    public NodeErrorNotificationBuilder() {
    }

    public NodeErrorNotificationBuilder(ErrorMessage arg) {
        this._code = arg.getCode();
        this._data = arg.getData();
        this._type = arg.getType();
    }

    public NodeErrorNotificationBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public NodeErrorNotificationBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ErrorMessage) {
            this._code = ((ErrorMessage)arg).getCode();
            this._data = ((ErrorMessage)arg).getData();
            this._type = ((ErrorMessage)arg).getType();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionAware] \nbut was: " + arg);
        }
    }

    public Integer getCode() {
        return this._code;
    }

    public String getData() {
        return this._data;
    }

    public ErrorType getType() {
        return this._type;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public <E extends Augmentation<NodeErrorNotification>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeErrorNotificationBuilder setCode(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._code = value;
        return this;
    }

    public NodeErrorNotificationBuilder setData(String value) {
        this._data = value;
        return this;
    }

    public NodeErrorNotificationBuilder setType(ErrorType value) {
        this._type = value;
        return this;
    }

    public NodeErrorNotificationBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public NodeErrorNotificationBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public NodeErrorNotificationBuilder addAugmentation(Class<? extends Augmentation<NodeErrorNotification>> augmentationType, Augmentation<NodeErrorNotification> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeErrorNotification build() {
        return new NodeErrorNotificationImpl(this);
    }

    private static final class NodeErrorNotificationImpl
    implements NodeErrorNotification {
        private final Integer _code;
        private final String _data;
        private final ErrorType _type;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private Map<Class<? extends Augmentation<NodeErrorNotification>>, Augmentation<NodeErrorNotification>> augmentation = new HashMap<Class<? extends Augmentation<NodeErrorNotification>>, Augmentation<NodeErrorNotification>>();

        public Class<NodeErrorNotification> getImplementedInterface() {
            return NodeErrorNotification.class;
        }

        private NodeErrorNotificationImpl(NodeErrorNotificationBuilder builder) {
            this._code = builder.getCode();
            this._data = builder.getData();
            this._type = builder.getType();
            this._transactionId = builder.getTransactionId();
            this._transactionUri = builder.getTransactionUri();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public ErrorType getType() {
            return this._type;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        public <E extends Augmentation<NodeErrorNotification>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._code == null ? 0 : this._code.hashCode());
            result = 31 * result + (this._data == null ? 0 : this._data.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._transactionId == null ? 0 : this._transactionId.hashCode());
            result = 31 * result + (this._transactionUri == null ? 0 : this._transactionUri.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeErrorNotificationImpl other = (NodeErrorNotificationImpl)obj;
            if (this._code == null ? other._code != null : !this._code.equals(other._code)) {
                return false;
            }
            if (this._data == null ? other._data != null : !this._data.equals(other._data)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
                return false;
            }
            if (this._transactionId == null ? other._transactionId != null : !this._transactionId.equals(other._transactionId)) {
                return false;
            }
            if (this._transactionUri == null ? other._transactionUri != null : !this._transactionUri.equals((Object)other._transactionUri)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NodeErrorNotification [_code=");
            builder.append(this._code);
            builder.append(", _data=");
            builder.append(this._data);
            builder.append(", _type=");
            builder.append((Object)this._type);
            builder.append(", _transactionId=");
            builder.append(this._transactionId);
            builder.append(", _transactionUri=");
            builder.append(this._transactionUri);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

