/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.TableFeatures;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableBuilder {
    private List<Flow> _flow;
    private Short _id;
    private TableKey _key;
    private List<TableFeatures> _tableFeatures;
    private Map<Class<? extends Augmentation<Table>>, Augmentation<Table>> augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>();

    public TableBuilder() {
    }

    public TableBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures arg) {
        this._tableFeatures = arg.getTableFeatures();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures) {
            this._tableFeatures = ((org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures)arg).getTableFeatures();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures] \nbut was: " + arg);
        }
    }

    public List<Flow> getFlow() {
        return this._flow;
    }

    public Short getId() {
        return this._id;
    }

    public TableKey getKey() {
        return this._key;
    }

    public List<TableFeatures> getTableFeatures() {
        return this._tableFeatures;
    }

    public <E extends Augmentation<Table>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableBuilder setFlow(List<Flow> value) {
        this._flow = value;
        return this;
    }

    public TableBuilder setId(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._id = value;
        return this;
    }

    public TableBuilder setKey(TableKey value) {
        this._key = value;
        return this;
    }

    public TableBuilder setTableFeatures(List<TableFeatures> value) {
        this._tableFeatures = value;
        return this;
    }

    public TableBuilder addAugmentation(Class<? extends Augmentation<Table>> augmentationType, Augmentation<Table> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Table build() {
        return new TableImpl(this);
    }

    private static final class TableImpl
    implements Table {
        private final List<Flow> _flow;
        private final Short _id;
        private final TableKey _key;
        private final List<TableFeatures> _tableFeatures;
        private Map<Class<? extends Augmentation<Table>>, Augmentation<Table>> augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>();

        public Class<Table> getImplementedInterface() {
            return Table.class;
        }

        private TableImpl(TableBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new TableKey(builder.getId());
                this._id = builder.getId();
            } else {
                this._key = builder.getKey();
                this._id = this._key.getId();
            }
            this._flow = builder.getFlow();
            this._tableFeatures = builder.getTableFeatures();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Flow> getFlow() {
            return this._flow;
        }

        @Override
        public Short getId() {
            return this._id;
        }

        @Override
        public TableKey getKey() {
            return this._key;
        }

        public List<TableFeatures> getTableFeatures() {
            return this._tableFeatures;
        }

        public <E extends Augmentation<Table>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flow == null ? 0 : this._flow.hashCode());
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._tableFeatures == null ? 0 : this._tableFeatures.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableImpl other = (TableImpl)obj;
            if (this._flow == null ? other._flow != null : !this._flow.equals(other._flow)) {
                return false;
            }
            if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._tableFeatures == null ? other._tableFeatures != null : !this._tableFeatures.equals(other._tableFeatures)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Table [_flow=");
            builder.append(this._flow);
            builder.append(", _id=");
            builder.append(this._id);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _tableFeatures=");
            builder.append(this._tableFeatures);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

