/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.queue;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.queue.Properties;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class PropertiesBuilder {
    private Long _maximumRate;
    private Long _minimumRate;
    private Map<Class<? extends Augmentation<Properties>>, Augmentation<Properties>> augmentation = new HashMap<Class<? extends Augmentation<Properties>>, Augmentation<Properties>>();

    public Long getMaximumRate() {
        return this._maximumRate;
    }

    public Long getMinimumRate() {
        return this._minimumRate;
    }

    public <E extends Augmentation<Properties>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PropertiesBuilder setMaximumRate(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maximumRate = value;
        return this;
    }

    public PropertiesBuilder setMinimumRate(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._minimumRate = value;
        return this;
    }

    public PropertiesBuilder addAugmentation(Class<? extends Augmentation<Properties>> augmentationType, Augmentation<Properties> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Properties build() {
        return new PropertiesImpl(this);
    }

    private static final class PropertiesImpl
    implements Properties {
        private final Long _maximumRate;
        private final Long _minimumRate;
        private Map<Class<? extends Augmentation<Properties>>, Augmentation<Properties>> augmentation = new HashMap<Class<? extends Augmentation<Properties>>, Augmentation<Properties>>();

        public Class<Properties> getImplementedInterface() {
            return Properties.class;
        }

        private PropertiesImpl(PropertiesBuilder builder) {
            this._maximumRate = builder.getMaximumRate();
            this._minimumRate = builder.getMinimumRate();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getMaximumRate() {
            return this._maximumRate;
        }

        @Override
        public Long getMinimumRate() {
            return this._minimumRate;
        }

        public <E extends Augmentation<Properties>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maximumRate == null ? 0 : this._maximumRate.hashCode());
            result = 31 * result + (this._minimumRate == null ? 0 : this._minimumRate.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertiesImpl other = (PropertiesImpl)obj;
            if (this._maximumRate == null ? other._maximumRate != null : !this._maximumRate.equals(other._maximumRate)) {
                return false;
            }
            if (this._minimumRate == null ? other._minimumRate != null : !this._minimumRate.equals(other._minimumRate)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Properties [_maximumRate=");
            builder.append(this._maximumRate);
            builder.append(", _minimumRate=");
            builder.append(this._minimumRate);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

