/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.MeterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.MeterBandHeaders;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterBuilder {
    private MeterKey _key;
    private Boolean _barrier;
    private String _containerName;
    private MeterFlags _flags;
    private MeterBandHeaders _meterBandHeaders;
    private MeterId _meterId;
    private String _meterName;
    private Map<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>();

    public MeterBuilder() {
    }

    public MeterBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter arg) {
        this._barrier = arg.isBarrier();
        this._containerName = arg.getContainerName();
        this._flags = arg.getFlags();
        this._meterBandHeaders = arg.getMeterBandHeaders();
        this._meterId = arg.getMeterId();
        this._meterName = arg.getMeterName();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter) {
            this._barrier = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).isBarrier();
            this._containerName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getContainerName();
            this._flags = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getFlags();
            this._meterBandHeaders = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getMeterBandHeaders();
            this._meterId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getMeterId();
            this._meterName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter)arg).getMeterName();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter] \nbut was: " + arg);
        }
    }

    public MeterKey getKey() {
        return this._key;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterBandHeaders getMeterBandHeaders() {
        return this._meterBandHeaders;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public String getMeterName() {
        return this._meterName;
    }

    public <E extends Augmentation<Meter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterBuilder setKey(MeterKey value) {
        this._key = value;
        return this;
    }

    public MeterBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public MeterBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public MeterBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public MeterBuilder setMeterBandHeaders(MeterBandHeaders value) {
        this._meterBandHeaders = value;
        return this;
    }

    public MeterBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterBuilder setMeterName(String value) {
        this._meterName = value;
        return this;
    }

    public MeterBuilder addAugmentation(Class<? extends Augmentation<Meter>> augmentationType, Augmentation<Meter> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Meter build() {
        return new MeterImpl(this);
    }

    private static final class MeterImpl
    implements Meter {
        private final MeterKey _key;
        private final Boolean _barrier;
        private final String _containerName;
        private final MeterFlags _flags;
        private final MeterBandHeaders _meterBandHeaders;
        private final MeterId _meterId;
        private final String _meterName;
        private Map<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>();

        public Class<Meter> getImplementedInterface() {
            return Meter.class;
        }

        private MeterImpl(MeterBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new MeterKey(builder.getMeterId());
                this._meterId = builder.getMeterId();
            } else {
                this._key = builder.getKey();
                this._meterId = this._key.getMeterId();
            }
            this._barrier = builder.isBarrier();
            this._containerName = builder.getContainerName();
            this._flags = builder.getFlags();
            this._meterBandHeaders = builder.getMeterBandHeaders();
            this._meterName = builder.getMeterName();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MeterKey getKey() {
            return this._key;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public MeterFlags getFlags() {
            return this._flags;
        }

        public MeterBandHeaders getMeterBandHeaders() {
            return this._meterBandHeaders;
        }

        public MeterId getMeterId() {
            return this._meterId;
        }

        public String getMeterName() {
            return this._meterName;
        }

        public <E extends Augmentation<Meter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._meterBandHeaders == null ? 0 : this._meterBandHeaders.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._meterName == null ? 0 : this._meterName.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterImpl other = (MeterImpl)obj;
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._barrier == null ? other._barrier != null : !this._barrier.equals(other._barrier)) {
                return false;
            }
            if (this._containerName == null ? other._containerName != null : !this._containerName.equals(other._containerName)) {
                return false;
            }
            if (this._flags == null ? other._flags != null : !this._flags.equals((Object)other._flags)) {
                return false;
            }
            if (this._meterBandHeaders == null ? other._meterBandHeaders != null : !this._meterBandHeaders.equals(other._meterBandHeaders)) {
                return false;
            }
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals((Object)other._meterId)) {
                return false;
            }
            if (this._meterName == null ? other._meterName != null : !this._meterName.equals(other._meterName)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Meter [_key=");
            builder.append(this._key);
            builder.append(", _barrier=");
            builder.append(this._barrier);
            builder.append(", _containerName=");
            builder.append(this._containerName);
            builder.append(", _flags=");
            builder.append(this._flags);
            builder.append(", _meterBandHeaders=");
            builder.append(this._meterBandHeaders);
            builder.append(", _meterId=");
            builder.append(this._meterId);
            builder.append(", _meterName=");
            builder.append(this._meterName);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

