/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.match.types;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.match.types.MatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.supported.match.types.MatchTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.SupportType;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchTypeBuilder {
    private String _match;
    private MatchTypeKey _key;
    private SupportType _supportState;
    private Map<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>> augmentation = new HashMap<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>>();

    public MatchTypeBuilder() {
    }

    public MatchTypeBuilder(Feature arg) {
        this._supportState = arg.getSupportState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Feature) {
            this._supportState = ((Feature)arg).getSupportState();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Feature] \nbut was: " + arg);
        }
    }

    public String getMatch() {
        return this._match;
    }

    public MatchTypeKey getKey() {
        return this._key;
    }

    public SupportType getSupportState() {
        return this._supportState;
    }

    public <E extends Augmentation<MatchType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchTypeBuilder setMatch(String value) {
        this._match = value;
        return this;
    }

    public MatchTypeBuilder setKey(MatchTypeKey value) {
        this._key = value;
        return this;
    }

    public MatchTypeBuilder setSupportState(SupportType value) {
        this._supportState = value;
        return this;
    }

    public MatchTypeBuilder addAugmentation(Class<? extends Augmentation<MatchType>> augmentationType, Augmentation<MatchType> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchType build() {
        return new MatchTypeImpl(this);
    }

    private static final class MatchTypeImpl
    implements MatchType {
        private final String _match;
        private final MatchTypeKey _key;
        private final SupportType _supportState;
        private Map<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>> augmentation = new HashMap<Class<? extends Augmentation<MatchType>>, Augmentation<MatchType>>();

        public Class<MatchType> getImplementedInterface() {
            return MatchType.class;
        }

        private MatchTypeImpl(MatchTypeBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new MatchTypeKey(builder.getMatch());
                this._match = builder.getMatch();
            } else {
                this._key = builder.getKey();
                this._match = this._key.getMatch();
            }
            this._supportState = builder.getSupportState();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public String getMatch() {
            return this._match;
        }

        @Override
        public MatchTypeKey getKey() {
            return this._key;
        }

        @Override
        public SupportType getSupportState() {
            return this._supportState;
        }

        public <E extends Augmentation<MatchType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._supportState == null ? 0 : this._supportState.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchTypeImpl other = (MatchTypeImpl)obj;
            if (this._match == null ? other._match != null : !this._match.equals(other._match)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._supportState == null ? other._supportState != null : !this._supportState.equals((Object)other._supportState)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchType [_match=");
            builder.append(this._match);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _supportState=");
            builder.append(this._supportState);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

