/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FeatureCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SwitchFeaturesBuilder {
    private List<Class<? extends FeatureCapability>> _capabilities;
    private Long _maxBuffers;
    private Short _maxTables;
    private Map<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>> augmentation = new HashMap<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>>();

    public List<Class<? extends FeatureCapability>> getCapabilities() {
        return this._capabilities;
    }

    public Long getMaxBuffers() {
        return this._maxBuffers;
    }

    public Short getMaxTables() {
        return this._maxTables;
    }

    public <E extends Augmentation<SwitchFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SwitchFeaturesBuilder setCapabilities(List<Class<? extends FeatureCapability>> value) {
        this._capabilities = value;
        return this;
    }

    public SwitchFeaturesBuilder setMaxBuffers(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxBuffers = value;
        return this;
    }

    public SwitchFeaturesBuilder setMaxTables(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxTables = value;
        return this;
    }

    public SwitchFeaturesBuilder addAugmentation(Class<? extends Augmentation<SwitchFeatures>> augmentationType, Augmentation<SwitchFeatures> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SwitchFeatures build() {
        return new SwitchFeaturesImpl(this);
    }

    private static final class SwitchFeaturesImpl
    implements SwitchFeatures {
        private final List<Class<? extends FeatureCapability>> _capabilities;
        private final Long _maxBuffers;
        private final Short _maxTables;
        private Map<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>> augmentation = new HashMap<Class<? extends Augmentation<SwitchFeatures>>, Augmentation<SwitchFeatures>>();

        public Class<SwitchFeatures> getImplementedInterface() {
            return SwitchFeatures.class;
        }

        private SwitchFeaturesImpl(SwitchFeaturesBuilder builder) {
            this._capabilities = builder.getCapabilities();
            this._maxBuffers = builder.getMaxBuffers();
            this._maxTables = builder.getMaxTables();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Class<? extends FeatureCapability>> getCapabilities() {
            return this._capabilities;
        }

        @Override
        public Long getMaxBuffers() {
            return this._maxBuffers;
        }

        @Override
        public Short getMaxTables() {
            return this._maxTables;
        }

        public <E extends Augmentation<SwitchFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._capabilities == null ? 0 : this._capabilities.hashCode());
            result = 31 * result + (this._maxBuffers == null ? 0 : this._maxBuffers.hashCode());
            result = 31 * result + (this._maxTables == null ? 0 : this._maxTables.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SwitchFeaturesImpl other = (SwitchFeaturesImpl)obj;
            if (this._capabilities == null ? other._capabilities != null : !this._capabilities.equals(other._capabilities)) {
                return false;
            }
            if (this._maxBuffers == null ? other._maxBuffers != null : !this._maxBuffers.equals(other._maxBuffers)) {
                return false;
            }
            if (this._maxTables == null ? other._maxTables != null : !this._maxTables.equals(other._maxTables)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SwitchFeatures [_capabilities=");
            builder.append(this._capabilities);
            builder.append(", _maxBuffers=");
            builder.append(this._maxBuffers);
            builder.append(", _maxTables=");
            builder.append(this._maxTables);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

