/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819;

import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Meters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SupportedActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SupportedInstructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SupportedMatchTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Groups;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowCapableNodeBuilder {
    private String _description;
    private String _hardware;
    private String _manufacturer;
    private String _serialNumber;
    private String _software;
    private SupportedActions _supportedActions;
    private SupportedInstructions _supportedInstructions;
    private SupportedMatchTypes _supportedMatchTypes;
    private SwitchFeatures _switchFeatures;
    private List<Table> _table;
    private List<Meter> _meter;
    private List<Group> _group;

    public FlowCapableNodeBuilder() {
    }

    public FlowCapableNodeBuilder(FlowNode arg) {
        this._description = arg.getDescription();
        this._hardware = arg.getHardware();
        this._manufacturer = arg.getManufacturer();
        this._serialNumber = arg.getSerialNumber();
        this._software = arg.getSoftware();
        this._supportedActions = arg.getSupportedActions();
        this._supportedInstructions = arg.getSupportedInstructions();
        this._supportedMatchTypes = arg.getSupportedMatchTypes();
        this._switchFeatures = arg.getSwitchFeatures();
        this._table = arg.getTable();
        this._meter = arg.getMeter();
        this._group = arg.getGroup();
    }

    public FlowCapableNodeBuilder(Tables arg) {
        this._table = arg.getTable();
    }

    public FlowCapableNodeBuilder(Meters arg) {
        this._meter = arg.getMeter();
    }

    public FlowCapableNodeBuilder(Groups arg) {
        this._group = arg.getGroup();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Groups) {
            this._group = ((Groups)arg).getGroup();
            isValidArg = true;
        }
        if (arg instanceof Meters) {
            this._meter = ((Meters)arg).getMeter();
            isValidArg = true;
        }
        if (arg instanceof Tables) {
            this._table = ((Tables)arg).getTable();
            isValidArg = true;
        }
        if (arg instanceof FlowNode) {
            this._description = ((FlowNode)arg).getDescription();
            this._hardware = ((FlowNode)arg).getHardware();
            this._manufacturer = ((FlowNode)arg).getManufacturer();
            this._serialNumber = ((FlowNode)arg).getSerialNumber();
            this._software = ((FlowNode)arg).getSoftware();
            this._supportedActions = ((FlowNode)arg).getSupportedActions();
            this._supportedInstructions = ((FlowNode)arg).getSupportedInstructions();
            this._supportedMatchTypes = ((FlowNode)arg).getSupportedMatchTypes();
            this._switchFeatures = ((FlowNode)arg).getSwitchFeatures();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Groups, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Meters, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.Tables, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowNode] \nbut was: " + arg);
        }
    }

    public String getDescription() {
        return this._description;
    }

    public String getHardware() {
        return this._hardware;
    }

    public String getManufacturer() {
        return this._manufacturer;
    }

    public String getSerialNumber() {
        return this._serialNumber;
    }

    public String getSoftware() {
        return this._software;
    }

    public SupportedActions getSupportedActions() {
        return this._supportedActions;
    }

    public SupportedInstructions getSupportedInstructions() {
        return this._supportedInstructions;
    }

    public SupportedMatchTypes getSupportedMatchTypes() {
        return this._supportedMatchTypes;
    }

    public SwitchFeatures getSwitchFeatures() {
        return this._switchFeatures;
    }

    public List<Table> getTable() {
        return this._table;
    }

    public List<Meter> getMeter() {
        return this._meter;
    }

    public List<Group> getGroup() {
        return this._group;
    }

    public FlowCapableNodeBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public FlowCapableNodeBuilder setHardware(String value) {
        this._hardware = value;
        return this;
    }

    public FlowCapableNodeBuilder setManufacturer(String value) {
        this._manufacturer = value;
        return this;
    }

    public FlowCapableNodeBuilder setSerialNumber(String value) {
        this._serialNumber = value;
        return this;
    }

    public FlowCapableNodeBuilder setSoftware(String value) {
        this._software = value;
        return this;
    }

    public FlowCapableNodeBuilder setSupportedActions(SupportedActions value) {
        this._supportedActions = value;
        return this;
    }

    public FlowCapableNodeBuilder setSupportedInstructions(SupportedInstructions value) {
        this._supportedInstructions = value;
        return this;
    }

    public FlowCapableNodeBuilder setSupportedMatchTypes(SupportedMatchTypes value) {
        this._supportedMatchTypes = value;
        return this;
    }

    public FlowCapableNodeBuilder setSwitchFeatures(SwitchFeatures value) {
        this._switchFeatures = value;
        return this;
    }

    public FlowCapableNodeBuilder setTable(List<Table> value) {
        this._table = value;
        return this;
    }

    public FlowCapableNodeBuilder setMeter(List<Meter> value) {
        this._meter = value;
        return this;
    }

    public FlowCapableNodeBuilder setGroup(List<Group> value) {
        this._group = value;
        return this;
    }

    public FlowCapableNode build() {
        return new FlowCapableNodeImpl(this);
    }

    private static final class FlowCapableNodeImpl
    implements FlowCapableNode {
        private final String _description;
        private final String _hardware;
        private final String _manufacturer;
        private final String _serialNumber;
        private final String _software;
        private final SupportedActions _supportedActions;
        private final SupportedInstructions _supportedInstructions;
        private final SupportedMatchTypes _supportedMatchTypes;
        private final SwitchFeatures _switchFeatures;
        private final List<Table> _table;
        private final List<Meter> _meter;
        private final List<Group> _group;

        public Class<FlowCapableNode> getImplementedInterface() {
            return FlowCapableNode.class;
        }

        private FlowCapableNodeImpl(FlowCapableNodeBuilder builder) {
            this._description = builder.getDescription();
            this._hardware = builder.getHardware();
            this._manufacturer = builder.getManufacturer();
            this._serialNumber = builder.getSerialNumber();
            this._software = builder.getSoftware();
            this._supportedActions = builder.getSupportedActions();
            this._supportedInstructions = builder.getSupportedInstructions();
            this._supportedMatchTypes = builder.getSupportedMatchTypes();
            this._switchFeatures = builder.getSwitchFeatures();
            this._table = builder.getTable();
            this._meter = builder.getMeter();
            this._group = builder.getGroup();
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public String getHardware() {
            return this._hardware;
        }

        @Override
        public String getManufacturer() {
            return this._manufacturer;
        }

        @Override
        public String getSerialNumber() {
            return this._serialNumber;
        }

        @Override
        public String getSoftware() {
            return this._software;
        }

        @Override
        public SupportedActions getSupportedActions() {
            return this._supportedActions;
        }

        @Override
        public SupportedInstructions getSupportedInstructions() {
            return this._supportedInstructions;
        }

        @Override
        public SupportedMatchTypes getSupportedMatchTypes() {
            return this._supportedMatchTypes;
        }

        @Override
        public SwitchFeatures getSwitchFeatures() {
            return this._switchFeatures;
        }

        @Override
        public List<Table> getTable() {
            return this._table;
        }

        @Override
        public List<Meter> getMeter() {
            return this._meter;
        }

        public List<Group> getGroup() {
            return this._group;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._description == null ? 0 : this._description.hashCode());
            result = 31 * result + (this._hardware == null ? 0 : this._hardware.hashCode());
            result = 31 * result + (this._manufacturer == null ? 0 : this._manufacturer.hashCode());
            result = 31 * result + (this._serialNumber == null ? 0 : this._serialNumber.hashCode());
            result = 31 * result + (this._software == null ? 0 : this._software.hashCode());
            result = 31 * result + (this._supportedActions == null ? 0 : this._supportedActions.hashCode());
            result = 31 * result + (this._supportedInstructions == null ? 0 : this._supportedInstructions.hashCode());
            result = 31 * result + (this._supportedMatchTypes == null ? 0 : this._supportedMatchTypes.hashCode());
            result = 31 * result + (this._switchFeatures == null ? 0 : this._switchFeatures.hashCode());
            result = 31 * result + (this._table == null ? 0 : this._table.hashCode());
            result = 31 * result + (this._meter == null ? 0 : this._meter.hashCode());
            result = 31 * result + (this._group == null ? 0 : this._group.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowCapableNodeImpl other = (FlowCapableNodeImpl)obj;
            if (this._description == null ? other._description != null : !this._description.equals(other._description)) {
                return false;
            }
            if (this._hardware == null ? other._hardware != null : !this._hardware.equals(other._hardware)) {
                return false;
            }
            if (this._manufacturer == null ? other._manufacturer != null : !this._manufacturer.equals(other._manufacturer)) {
                return false;
            }
            if (this._serialNumber == null ? other._serialNumber != null : !this._serialNumber.equals(other._serialNumber)) {
                return false;
            }
            if (this._software == null ? other._software != null : !this._software.equals(other._software)) {
                return false;
            }
            if (this._supportedActions == null ? other._supportedActions != null : !this._supportedActions.equals(other._supportedActions)) {
                return false;
            }
            if (this._supportedInstructions == null ? other._supportedInstructions != null : !this._supportedInstructions.equals(other._supportedInstructions)) {
                return false;
            }
            if (this._supportedMatchTypes == null ? other._supportedMatchTypes != null : !this._supportedMatchTypes.equals(other._supportedMatchTypes)) {
                return false;
            }
            if (this._switchFeatures == null ? other._switchFeatures != null : !this._switchFeatures.equals(other._switchFeatures)) {
                return false;
            }
            if (this._table == null ? other._table != null : !this._table.equals(other._table)) {
                return false;
            }
            if (this._meter == null ? other._meter != null : !this._meter.equals(other._meter)) {
                return false;
            }
            return !(this._group == null ? other._group != null : !this._group.equals(other._group));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FlowCapableNode [_description=");
            builder.append(this._description);
            builder.append(", _hardware=");
            builder.append(this._hardware);
            builder.append(", _manufacturer=");
            builder.append(this._manufacturer);
            builder.append(", _serialNumber=");
            builder.append(this._serialNumber);
            builder.append(", _software=");
            builder.append(this._software);
            builder.append(", _supportedActions=");
            builder.append(this._supportedActions);
            builder.append(", _supportedInstructions=");
            builder.append(this._supportedInstructions);
            builder.append(", _supportedMatchTypes=");
            builder.append(this._supportedMatchTypes);
            builder.append(", _switchFeatures=");
            builder.append(this._switchFeatures);
            builder.append(", _table=");
            builder.append(this._table);
            builder.append(", _meter=");
            builder.append(this._meter);
            builder.append(", _group=");
            builder.append(this._group);
            builder.append("]");
            return builder.toString();
        }
    }
}

