/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.util;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public class YangSchemaUtils {
    public static final String AUGMENT_IDENTIFIER = "augment-identifier";

    public YangSchemaUtils() {
        throw new UnsupportedOperationException("Helper class. Instantiation is prohibited");
    }

    public static QName getAugmentationQName(AugmentationSchema augmentation) {
        Preconditions.checkNotNull((Object)augmentation, (Object)"Augmentation must not be null.");
        QName identifier = YangSchemaUtils.getAugmentationIdentifier(augmentation);
        if (identifier != null) {
            return identifier;
        }
        Iterator i$ = augmentation.getChildNodes().iterator();
        if (i$.hasNext()) {
            DataSchemaNode child = (DataSchemaNode)i$.next();
            return QName.create((QName)child.getQName(), (String)"foo_augment");
        }
        return null;
    }

    public static QName getAugmentationIdentifier(AugmentationSchema augmentation) {
        for (UnknownSchemaNode extension : augmentation.getUnknownSchemaNodes()) {
            if (!AUGMENT_IDENTIFIER.equals(extension.getNodeType().getLocalName())) continue;
            return extension.getQName();
        }
        return null;
    }

    public static TypeDefinition<?> findTypeDefinition(SchemaContext context, SchemaPath path) {
        List arguments = path.getPath();
        QName first = (QName)arguments.get(0);
        QName typeQName = (QName)arguments.get(arguments.size() - 1);
        Module previous = context.findModuleByNamespaceAndRevision(first.getNamespace(), first.getRevision());
        if (previous == null) {
            return null;
        }
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0);
        for (QName qName : arguments) {
        }
        for (TypeDefinition typedef : previous.getTypeDefinitions()) {
            if (!typedef.getQName().equals((Object)typeQName)) continue;
            return typedef;
        }
        return null;
    }
}

