/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.yangtools.sal.binding.generator.util.ClassGenerator;
import org.opendaylight.yangtools.sal.binding.generator.util.MethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistUtils {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(JavassistUtils.class);
            return _logger;
        }
    }.apply();
    private final Map<ClassLoader, LoaderClassPath> loaderClassPaths = new Functions.Function0<Map<ClassLoader, LoaderClassPath>>(){

        public Map<ClassLoader, LoaderClassPath> apply() {
            WeakHashMap _weakHashMap = new WeakHashMap();
            Map<ClassLoader, LoaderClassPath> _synchronizedMap = Collections.synchronizedMap(_weakHashMap);
            return _synchronizedMap;
        }
    }.apply();
    private ClassPool classPool;
    private final Lock _lock = new Functions.Function0<Lock>(){

        public Lock apply() {
            ReentrantLock _reentrantLock = new ReentrantLock();
            return _reentrantLock;
        }
    }.apply();

    public Lock getLock() {
        return this._lock;
    }

    public JavassistUtils(ClassPool pool) {
        this.classPool = pool;
    }

    public void method(CtClass it, Class<? extends Object> returnType, String name, Class<? extends Object> parameter, MethodGenerator function1) {
        try {
            CtMethod _ctMethod;
            CtClass _asCtClass = this.asCtClass(returnType);
            CtClass _asCtClass_1 = this.asCtClass(parameter);
            List<CtClass> _asList = Arrays.asList(_asCtClass_1);
            CtMethod method = _ctMethod = new CtMethod(_asCtClass, name, (CtClass[])Conversions.unwrapArray(_asList, CtClass.class), it);
            function1.process(method);
            it.addMethod(method);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void method(CtClass it, Class<? extends Object> returnType, String name, Class<? extends Object> parameter1, Class<? extends Object> parameter2, MethodGenerator function1) {
        try {
            CtMethod _ctMethod;
            CtClass _asCtClass = this.asCtClass(returnType);
            CtClass _asCtClass_1 = this.asCtClass(parameter1);
            CtClass _asCtClass_2 = this.asCtClass(parameter2);
            List<CtClass> _asList = Arrays.asList(_asCtClass_1, _asCtClass_2);
            CtMethod method = _ctMethod = new CtMethod(_asCtClass, name, (CtClass[])Conversions.unwrapArray(_asList, CtClass.class), it);
            function1.process(method);
            it.addMethod(method);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void staticMethod(CtClass it, Class<? extends Object> returnType, String name, Class<? extends Object> parameter, MethodGenerator function1) {
        try {
            CtMethod _ctMethod;
            CtClass _asCtClass = this.asCtClass(returnType);
            CtClass _asCtClass_1 = this.asCtClass(parameter);
            List<CtClass> _asList = Arrays.asList(_asCtClass_1);
            CtMethod method = _ctMethod = new CtMethod(_asCtClass, name, (CtClass[])Conversions.unwrapArray(_asList, CtClass.class), it);
            function1.process(method);
            it.addMethod(method);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void implementMethodsFrom(CtClass target, CtClass source, MethodGenerator function1) {
        try {
            CtMethod[] _methods;
            for (CtMethod method : _methods = source.getMethods()) {
                CtMethod _ctMethod;
                CtClass _declaringClass = method.getDeclaringClass();
                boolean _equals = Objects.equal((Object)_declaringClass, (Object)source);
                if (!_equals) continue;
                CtMethod redeclaredMethod = _ctMethod = new CtMethod(method, target, null);
                function1.process(redeclaredMethod);
                target.addMethod(redeclaredMethod);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CtClass createClass(String fqn, ClassGenerator cls) {
        CtClass target = this.classPool.makeClass(fqn);
        cls.process(target);
        return target;
    }

    public CtClass createClass(String fqn, CtClass superInterface, ClassGenerator cls) {
        CtClass target = this.classPool.makeClass(fqn);
        this.implementsType(target, superInterface);
        cls.process(target);
        return target;
    }

    public void implementsType(CtClass it, CtClass supertype) {
        boolean _isInterface = supertype.isInterface();
        Preconditions.checkArgument((boolean)_isInterface, (Object)"Supertype must be interface");
        it.addInterface(supertype);
    }

    public CtClass asCtClass(Class<? extends Object> class1) {
        CtClass _get = this.get(this.classPool, class1);
        return _get;
    }

    public CtField field(CtClass it, String name, Class<? extends Object> returnValue) {
        try {
            CtField _ctField;
            CtClass _asCtClass = this.asCtClass(returnValue);
            CtField field = _ctField = new CtField(_asCtClass, name, it);
            field.setModifiers(1);
            it.addField(field);
            return field;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CtField staticField(CtClass it, String name, Class<? extends Object> returnValue) {
        try {
            CtField _ctField;
            CtClass _asCtClass = this.asCtClass(returnValue);
            CtField field = _ctField = new CtField(_asCtClass, name, it);
            int _plus = 9;
            field.setModifiers(_plus);
            it.addField(field);
            return field;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CtClass get(ClassPool pool, Class<? extends Object> cls) {
        try {
            String _name = cls.getName();
            return pool.get(_name);
        }
        catch (Throwable _e) {
            try {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
            catch (Throwable _t) {
                if (_t instanceof NotFoundException) {
                    NotFoundException e = (NotFoundException)_t;
                    ClassLoader _classLoader = cls.getClassLoader();
                    this.appendClassLoaderIfMissing(_classLoader);
                    try {
                        String _name_1 = cls.getName();
                        return pool.get(_name_1);
                    }
                    catch (Throwable _e_1) {
                        try {
                            throw Exceptions.sneakyThrow((Throwable)_e_1);
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof NotFoundException) {
                                NotFoundException ef = (NotFoundException)_t_1;
                                LOG.warn("Appending ClassClassPath for {}", cls);
                                ClassClassPath _classClassPath = new ClassClassPath(cls);
                                pool.appendClassPath((ClassPath)_classClassPath);
                                try {
                                    String _name_2 = cls.getName();
                                    return pool.get(_name_2);
                                }
                                catch (Throwable _e_2) {
                                    throw Exceptions.sneakyThrow((Throwable)_e_2);
                                }
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public void appendClassLoaderIfMissing(ClassLoader loader) {
        LoaderClassPath _loaderClassPath;
        boolean _containsKey = this.loaderClassPaths.containsKey(loader);
        if (_containsKey) {
            return;
        }
        LoaderClassPath ctLoader = _loaderClassPath = new LoaderClassPath(loader);
        this.classPool.appendClassPath((ClassPath)ctLoader);
    }

    public void ensureClassLoader(Class<? extends Object> child) {
        ClassLoader _classLoader = child.getClassLoader();
        this.appendClassLoaderIfMissing(_classLoader);
    }
}

