/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.util;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static <V> V withClassLoader(ClassLoader cls, Callable<V> function) throws Exception {
        return ClassLoaderUtils.withClassLoaderAndLock(cls, (Optional<Lock>)Optional.absent(), function);
    }

    public static <V> V withClassLoaderAndLock(ClassLoader cls, Lock lock, Callable<V> function) throws Exception {
        Preconditions.checkNotNull((Object)lock, (Object)"Lock should not be null");
        return ClassLoaderUtils.withClassLoaderAndLock(cls, (Optional<Lock>)Optional.of((Object)lock), function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V withClassLoaderAndLock(ClassLoader cls, Optional<Lock> lock, Callable<V> function) throws Exception {
        Preconditions.checkNotNull((Object)cls, (Object)"Classloader should not be null");
        Preconditions.checkNotNull(function, (Object)"Function should not be null");
        if (lock.isPresent()) {
            ((Lock)lock.get()).lock();
        }
        ClassLoader oldCls = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cls);
            V v = function.call();
            return v;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCls);
            if (lock.isPresent()) {
                ((Lock)lock.get()).unlock();
            }
        }
    }

    public static Object construct(Constructor<? extends Object> constructor, List<Object> objects) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] initargs = objects.toArray(new Object[0]);
        return constructor.newInstance(initargs);
    }

    public static Class<?> loadClassWithTCCL(String name) throws ClassNotFoundException {
        if ("byte[]".equals(name)) {
            return byte[].class;
        }
        if ("char[]".equals(name)) {
            return char[].class;
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            String potentialOuter;
            String[] components = name.split("\\.");
            int length = components.length;
            if (length > 2 && (potentialOuter = components[length - 2]) != null && Character.isUpperCase(potentialOuter.charAt(0))) {
                String outerName = Joiner.on((String)".").join(Arrays.asList(components).subList(0, length - 1));
                String innerName = outerName + "$" + components[length - 1];
                return Thread.currentThread().getContextClassLoader().loadClass(innerName);
            }
            throw e;
        }
    }

    public static Class<?> tryToLoadClassWithTCCL(String fullyQualifiedName) {
        try {
            return ClassLoaderUtils.loadClassWithTCCL(fullyQualifiedName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

