/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.impl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.SettableFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import javassist.ClassPool;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.binding.generator.util.ReferencedTypeImpl;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.sal.binding.generator.impl.BindingGeneratorImpl;
import org.opendaylight.yangtools.sal.binding.generator.impl.LazyGeneratedCodecRegistry;
import org.opendaylight.yangtools.sal.binding.generator.impl.ModuleContext;
import org.opendaylight.yangtools.sal.binding.generator.impl.SchemaLock;
import org.opendaylight.yangtools.sal.binding.generator.impl.TransformerGenerator;
import org.opendaylight.yangtools.sal.binding.generator.util.YangSchemaUtils;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.SimpleNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.codec.AugmentationCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.opendaylight.yangtools.yang.data.impl.codec.DataContainerCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.opendaylight.yangtools.yang.data.impl.codec.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.ValueWithQName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeGeneratedMappingServiceImpl
implements BindingIndependentMappingService,
SchemaServiceListener,
SchemaLock,
AutoCloseable {
    private ClassPool _pool;
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(RuntimeGeneratedMappingServiceImpl.class);
            return _logger;
        }
    }.apply();
    @Extension
    private TransformerGenerator _binding;
    @Extension
    private LazyGeneratedCodecRegistry _registry;
    private final ConcurrentMap<Type, Type> _typeDefinitions = new Functions.Function0<ConcurrentMap<Type, Type>>(){

        public ConcurrentMap<Type, Type> apply() {
            ConcurrentHashMap<Type, Type> _concurrentHashMap = new ConcurrentHashMap<Type, Type>();
            return _concurrentHashMap;
        }
    }.apply();
    private final ConcurrentMap<Type, GeneratedTypeBuilder> _typeToDefinition = new Functions.Function0<ConcurrentMap<Type, GeneratedTypeBuilder>>(){

        public ConcurrentMap<Type, GeneratedTypeBuilder> apply() {
            ConcurrentHashMap<Type, GeneratedTypeBuilder> _concurrentHashMap = new ConcurrentHashMap<Type, GeneratedTypeBuilder>();
            return _concurrentHashMap;
        }
    }.apply();
    private final ConcurrentMap<Type, SchemaNode> _typeToSchemaNode = new Functions.Function0<ConcurrentMap<Type, SchemaNode>>(){

        public ConcurrentMap<Type, SchemaNode> apply() {
            ConcurrentHashMap<Type, SchemaNode> _concurrentHashMap = new ConcurrentHashMap<Type, SchemaNode>();
            return _concurrentHashMap;
        }
    }.apply();
    private final ConcurrentMap<Type, Set<QName>> _serviceTypeToRpc = new Functions.Function0<ConcurrentMap<Type, Set<QName>>>(){

        public ConcurrentMap<Type, Set<QName>> apply() {
            ConcurrentHashMap<Type, Set<QName>> _concurrentHashMap = new ConcurrentHashMap<Type, Set<QName>>();
            return _concurrentHashMap;
        }
    }.apply();
    private final HashMultimap<Type, SettableFuture<GeneratedTypeBuilder>> promisedTypeDefinitions = new Functions.Function0<HashMultimap<Type, SettableFuture<GeneratedTypeBuilder>>>(){

        public HashMultimap<Type, SettableFuture<GeneratedTypeBuilder>> apply() {
            HashMultimap _create = HashMultimap.create();
            return _create;
        }
    }.apply();
    private final HashMultimap<Type, SettableFuture<Type>> promisedTypes = new Functions.Function0<HashMultimap<Type, SettableFuture<Type>>>(){

        public HashMultimap<Type, SettableFuture<Type>> apply() {
            HashMultimap _create = HashMultimap.create();
            return _create;
        }
    }.apply();

    public ClassPool getPool() {
        return this._pool;
    }

    public void setPool(ClassPool pool) {
        this._pool = pool;
    }

    public TransformerGenerator getBinding() {
        return this._binding;
    }

    public void setBinding(TransformerGenerator binding) {
        this._binding = binding;
    }

    public LazyGeneratedCodecRegistry getRegistry() {
        return this._registry;
    }

    public void setRegistry(LazyGeneratedCodecRegistry registry) {
        this._registry = registry;
    }

    public ConcurrentMap<Type, Type> getTypeDefinitions() {
        return this._typeDefinitions;
    }

    public ConcurrentMap<Type, GeneratedTypeBuilder> getTypeToDefinition() {
        return this._typeToDefinition;
    }

    public ConcurrentMap<Type, SchemaNode> getTypeToSchemaNode() {
        return this._typeToSchemaNode;
    }

    public ConcurrentMap<Type, Set<QName>> getServiceTypeToRpc() {
        return this._serviceTypeToRpc;
    }

    public void onGlobalContextUpdated(SchemaContext arg0) {
        this.recreateBindingContext(arg0);
        LazyGeneratedCodecRegistry _registry = this.getRegistry();
        _registry.onGlobalContextUpdated(arg0);
    }

    public void recreateBindingContext(SchemaContext schemaContext) {
        BindingGeneratorImpl _bindingGeneratorImpl;
        BindingGeneratorImpl newBinding = _bindingGeneratorImpl = new BindingGeneratorImpl();
        newBinding.generateTypes(schemaContext);
        Map<Module, ModuleContext> _moduleContexts = newBinding.getModuleContexts();
        Set<Map.Entry<Module, ModuleContext>> _entrySet = _moduleContexts.entrySet();
        for (Map.Entry<Module, ModuleContext> entry : _entrySet) {
            boolean _not;
            LazyGeneratedCodecRegistry _registry = this.getRegistry();
            Module _key = entry.getKey();
            ModuleContext _value = entry.getValue();
            _registry.onModuleContextAdded(schemaContext, _key, _value);
            TransformerGenerator _binding = this.getBinding();
            Map<SchemaPath, GeneratedTypeBuilder> _pathToType = _binding.getPathToType();
            ModuleContext _value_1 = entry.getValue();
            Map<SchemaPath, GeneratedTypeBuilder> _childNodes = _value_1.getChildNodes();
            _pathToType.putAll(_childNodes);
            Module module = entry.getKey();
            ModuleContext context = entry.getValue();
            Map<SchemaPath, GeneratedTypeBuilder> _childNodes_1 = context.getChildNodes();
            this.updateBindingFor(_childNodes_1, schemaContext);
            Map<SchemaPath, GeneratedTypeBuilder> _cases = context.getCases();
            this.updateBindingFor(_cases, schemaContext);
            String namespace = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
            Set _rpcs = module.getRpcs();
            boolean _isEmpty = _rpcs.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                ReferencedTypeImpl _referencedTypeImpl;
                Set _rpcs_1 = module.getRpcs();
                FluentIterable _from = FluentIterable.from((Iterable)_rpcs_1);
                Function<RpcDefinition, QName> _function = new Function<RpcDefinition, QName>(){

                    public QName apply(RpcDefinition it) {
                        QName _qName = it.getQName();
                        return _qName;
                    }
                };
                FluentIterable _transform = _from.transform((Function)_function);
                ImmutableSet rpcs = _transform.toSet();
                String _name = module.getName();
                String _parseToClassName = BindingGeneratorUtil.parseToClassName((String)_name);
                String _plus = _parseToClassName + "Service";
                ReferencedTypeImpl serviceClass = _referencedTypeImpl = new ReferencedTypeImpl(namespace, _plus);
                ConcurrentMap<Type, Set<QName>> _serviceTypeToRpc = this.getServiceTypeToRpc();
                _serviceTypeToRpc.put((Type)serviceClass, (Set<QName>)rpcs);
            }
            Map<SchemaPath, Type> typedefs = context.getTypedefs();
            Set<Map.Entry<SchemaPath, Type>> _entrySet_1 = typedefs.entrySet();
            for (Map.Entry<SchemaPath, Type> typedef : _entrySet_1) {
                boolean _notEquals;
                ReferencedTypeImpl _referencedTypeImpl_1;
                Type _value_2 = typedef.getValue();
                String _packageName = _value_2.getPackageName();
                Type _value_3 = typedef.getValue();
                String _name_1 = _value_3.getName();
                ReferencedTypeImpl typeRef = _referencedTypeImpl_1 = new ReferencedTypeImpl(_packageName, _name_1);
                TransformerGenerator _binding_1 = this.getBinding();
                Map<Type, Type> _typeDefinitions = _binding_1.getTypeDefinitions();
                Type _value_4 = typedef.getValue();
                _typeDefinitions.put((Type)typeRef, (Type)((GeneratedType)_value_4));
                SchemaPath _key_1 = typedef.getKey();
                TypeDefinition<?> schemaNode = YangSchemaUtils.findTypeDefinition(schemaContext, _key_1);
                boolean bl2 = _notEquals = !Objects.equal(schemaNode, null);
                if (_notEquals) {
                    TransformerGenerator _binding_2 = this.getBinding();
                    Map<Type, SchemaNode> _typeToSchemaNode = _binding_2.getTypeToSchemaNode();
                    _typeToSchemaNode.put((Type)typeRef, (SchemaNode)schemaNode);
                    continue;
                }
                Type _value_5 = typedef.getValue();
                LOG.error("Type definition for {} is not available", (Object)_value_5);
            }
            List<GeneratedTypeBuilder> augmentations = context.getAugmentations();
            for (GeneratedTypeBuilder augmentation : augmentations) {
                TransformerGenerator _binding_1 = this.getBinding();
                Map<Type, GeneratedTypeBuilder> _typeToDefinition = _binding_1.getTypeToDefinition();
                _typeToDefinition.put((Type)augmentation, augmentation);
            }
            TransformerGenerator _binding_2 = this.getBinding();
            Map<Type, AugmentationSchema> _typeToAugmentation = _binding_2.getTypeToAugmentation();
            Map<Type, AugmentationSchema> _typeToAugmentation_1 = context.getTypeToAugmentation();
            _typeToAugmentation.putAll(_typeToAugmentation_1);
            for (GeneratedTypeBuilder augmentation_1 : augmentations) {
                this.updatePromisedSchemas((Type)augmentation_1);
            }
        }
    }

    public CompositeNode toDataDom(DataObject data) {
        CompositeNode _compositeNodeImpl = this.toCompositeNodeImpl(data);
        return _compositeNodeImpl;
    }

    public Map.Entry<InstanceIdentifier, CompositeNode> toDataDom(Map.Entry<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> entry) {
        try {
            org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> _key = entry.getKey();
            InstanceIdentifier key = this.toDataDom(_key);
            CompositeNode data = null;
            org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> _key_1 = entry.getKey();
            Class _targetType = _key_1.getTargetType();
            boolean _isAssignableFrom = Augmentation.class.isAssignableFrom(_targetType);
            if (_isAssignableFrom) {
                CompositeNode _compositeNodeImplAugument;
                DataObject _value = entry.getValue();
                data = _compositeNodeImplAugument = this.toCompositeNodeImplAugument(key, _value);
            } else {
                CompositeNode _compositeNodeImpl;
                DataObject _value_1 = entry.getValue();
                data = _compositeNodeImpl = this.toCompositeNodeImpl(key, _value_1);
            }
            AbstractMap.SimpleEntry<InstanceIdentifier, CompositeNode> _simpleEntry = new AbstractMap.SimpleEntry<InstanceIdentifier, CompositeNode>(key, data);
            return _simpleEntry;
        }
        catch (Throwable _t) {
            try {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> _key_2 = entry.getKey();
                    LOG.error("Error during serialization for {}.", _key_2, (Object)e);
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    private CompositeNode toCompositeNodeImpl(DataObject object) {
        DataContainerCodec _codecForDataObject;
        Class cls = object.getImplementedInterface();
        this.waitForSchema(cls);
        LazyGeneratedCodecRegistry _registry = this.getRegistry();
        DataContainerCodec codec = _codecForDataObject = _registry.getCodecForDataObject(cls);
        ValueWithQName _valueWithQName = new ValueWithQName(null, (Object)object);
        CompositeNode ret = codec.serialize(_valueWithQName);
        return ret;
    }

    private CompositeNode toCompositeNodeImpl(InstanceIdentifier identifier, DataObject object) {
        DataContainerCodec _codecForDataObject;
        List _path = identifier.getPath();
        InstanceIdentifier.PathArgument last = (InstanceIdentifier.PathArgument)IterableExtensions.last((Iterable)_path);
        Class cls = object.getImplementedInterface();
        this.waitForSchema(cls);
        LazyGeneratedCodecRegistry _registry = this.getRegistry();
        DataContainerCodec codec = _codecForDataObject = _registry.getCodecForDataObject(cls);
        QName _nodeType = last.getNodeType();
        ValueWithQName _valueWithQName = new ValueWithQName(_nodeType, (Object)object);
        CompositeNode ret = codec.serialize(_valueWithQName);
        return ret;
    }

    private CompositeNode toCompositeNodeImplAugument(InstanceIdentifier identifier, DataObject object) {
        AugmentationCodec _codecForAugmentation;
        List _path = identifier.getPath();
        InstanceIdentifier.PathArgument last = (InstanceIdentifier.PathArgument)IterableExtensions.last((Iterable)_path);
        LazyGeneratedCodecRegistry _registry = this.getRegistry();
        Class _implementedInterface = object.getImplementedInterface();
        AugmentationCodec codec = _codecForAugmentation = _registry.getCodecForAugmentation(_implementedInterface);
        QName _nodeType = last.getNodeType();
        ValueWithQName _valueWithQName = new ValueWithQName(_nodeType, (Object)object);
        CompositeNode ret = codec.serialize(_valueWithQName);
        if (last instanceof InstanceIdentifier.NodeIdentifierWithPredicates) {
            ArrayList<SimpleNodeTOImpl> _arrayList;
            InstanceIdentifier.NodeIdentifierWithPredicates predicates = (InstanceIdentifier.NodeIdentifierWithPredicates)last;
            Map _keyValues = predicates.getKeyValues();
            int _size = _keyValues.size();
            ArrayList<SimpleNodeTOImpl> newNodes = _arrayList = new ArrayList<SimpleNodeTOImpl>(_size);
            Map _keyValues_1 = predicates.getKeyValues();
            Set _entrySet = _keyValues_1.entrySet();
            for (Map.Entry predicate : _entrySet) {
                QName _key = (QName)predicate.getKey();
                Object _value = predicate.getValue();
                SimpleNodeTOImpl _simpleNodeTOImpl = new SimpleNodeTOImpl(_key, null, _value);
                newNodes.add(_simpleNodeTOImpl);
            }
            List _children = ret.getChildren();
            newNodes.addAll(_children);
            QName _nodeType_1 = last.getNodeType();
            CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(_nodeType_1, null, newNodes);
            return _compositeNodeTOImpl;
        }
        return ret;
    }

    public void waitForSchema(Class class1) {
        LazyGeneratedCodecRegistry _registry = this.getRegistry();
        boolean _isCodecAvailable = _registry.isCodecAvailable(class1);
        if (_isCodecAvailable) {
            return;
        }
        ConcreteType ref = Types.typeForClass((Class)class1);
        this.getSchemaWithRetry((Type)ref);
    }

    public InstanceIdentifier toDataDom(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> path) {
        List _path = path.getPath();
        for (InstanceIdentifier.PathArgument arg : _path) {
            Class _type = arg.getType();
            this.waitForSchema(_type);
        }
        LazyGeneratedCodecRegistry _registry = this.getRegistry();
        InstanceIdentifierCodec _instanceIdentifierCodec = _registry.getInstanceIdentifierCodec();
        return _instanceIdentifierCodec.serialize(path);
    }

    public DataObject dataObjectFromDataDom(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> path, CompositeNode node) {
        Class _targetType = path.getTargetType();
        DataContainer _dataObjectFromDataDom = this.dataObjectFromDataDom(_targetType, node);
        return (DataObject)_dataObjectFromDataDom;
    }

    public org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends Object> fromDataDom(final InstanceIdentifier entry) {
        try {
            Callable<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends Object>> _function = new Callable<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends Object>>(){

                @Override
                public org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends Object> call() throws Exception {
                    LazyGeneratedCodecRegistry _registry = RuntimeGeneratedMappingServiceImpl.this.getRegistry();
                    InstanceIdentifierCodec _instanceIdentifierCodec = _registry.getInstanceIdentifierCodec();
                    org.opendaylight.yangtools.yang.binding.InstanceIdentifier _deserialize = _instanceIdentifierCodec.deserialize(entry);
                    return _deserialize;
                }
            };
            return RuntimeGeneratedMappingServiceImpl.tryDeserialization(_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CodecRegistry getCodecRegistry() {
        return this.getRegistry();
    }

    private static <T> T tryDeserialization(Callable<T> deserializationBlock) throws DeserializationException {
        T _xtrycatchfinallyexpression = null;
        try {
            T _call = deserializationBlock.call();
            _xtrycatchfinallyexpression = _call;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                DeserializationException _deserializationException = new DeserializationException((Throwable)e);
                throw _deserializationException;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private void updateBindingFor(Map<SchemaPath, GeneratedTypeBuilder> map, SchemaContext module) {
        Set<Map.Entry<SchemaPath, GeneratedTypeBuilder>> _entrySet = map.entrySet();
        for (Map.Entry<SchemaPath, GeneratedTypeBuilder> entry : _entrySet) {
            ReferencedTypeImpl _referencedTypeImpl;
            SchemaPath _key = entry.getKey();
            SchemaNode schemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)module, (SchemaPath)_key);
            GeneratedTypeBuilder _value = entry.getValue();
            String _packageName = _value.getPackageName();
            GeneratedTypeBuilder _value_1 = entry.getValue();
            String _name = _value_1.getName();
            ReferencedTypeImpl typeRef = _referencedTypeImpl = new ReferencedTypeImpl(_packageName, _name);
            ConcurrentMap<Type, GeneratedTypeBuilder> _typeToDefinition = this.getTypeToDefinition();
            GeneratedTypeBuilder _value_2 = entry.getValue();
            _typeToDefinition.put((Type)typeRef, _value_2);
            boolean _notEquals = !Objects.equal((Object)schemaNode, null);
            if (!_notEquals) continue;
            ConcurrentMap<Type, SchemaNode> _typeToSchemaNode = this.getTypeToSchemaNode();
            _typeToSchemaNode.put((Type)typeRef, schemaNode);
            GeneratedTypeBuilder _value_3 = entry.getValue();
            this.updatePromisedSchemas((Type)_value_3);
        }
    }

    public void init() {
        ClassPool _pool = this.getPool();
        TransformerGenerator _transformerGenerator = new TransformerGenerator(_pool);
        this.setBinding(_transformerGenerator);
        LazyGeneratedCodecRegistry _lazyGeneratedCodecRegistry = new LazyGeneratedCodecRegistry(this);
        this.setRegistry(_lazyGeneratedCodecRegistry);
        LazyGeneratedCodecRegistry _registry = this.getRegistry();
        TransformerGenerator _binding = this.getBinding();
        _registry.setGenerator(_binding);
        TransformerGenerator _binding_1 = this.getBinding();
        LazyGeneratedCodecRegistry _registry_1 = this.getRegistry();
        _binding_1.setListener(_registry_1);
        TransformerGenerator _binding_2 = this.getBinding();
        ConcurrentMap<Type, GeneratedTypeBuilder> _typeToDefinition = this.getTypeToDefinition();
        _binding_2.setTypeToDefinition(_typeToDefinition);
        TransformerGenerator _binding_3 = this.getBinding();
        ConcurrentMap<Type, SchemaNode> _typeToSchemaNode = this.getTypeToSchemaNode();
        _binding_3.setTypeToSchemaNode(_typeToSchemaNode);
        TransformerGenerator _binding_4 = this.getBinding();
        ConcurrentMap<Type, Type> _typeDefinitions = this.getTypeDefinitions();
        _binding_4.setTypeDefinitions(_typeDefinitions);
    }

    public Set<QName> getRpcQNamesFor(Class<? extends RpcService> service) {
        ConcurrentMap<Type, Set<QName>> _serviceTypeToRpc = this.getServiceTypeToRpc();
        Package _package = service.getPackage();
        String _name = _package.getName();
        String _simpleName = service.getSimpleName();
        ReferencedTypeImpl _referencedTypeImpl = new ReferencedTypeImpl(_name, _simpleName);
        return (Set)_serviceTypeToRpc.get(_referencedTypeImpl);
    }

    private void getSchemaWithRetry(Type type) {
        try {
            ConcurrentMap<Type, GeneratedTypeBuilder> _typeToDefinition = this.getTypeToDefinition();
            boolean _containsKey = _typeToDefinition.containsKey(type);
            if (_containsKey) {
                return;
            }
            String _fullyQualifiedName = type.getFullyQualifiedName();
            LOG.info("Thread blocked waiting for schema for: {}", (Object)_fullyQualifiedName);
            Future<Type> _waitForTypeDefinition = this.waitForTypeDefinition(type);
            _waitForTypeDefinition.get();
            String _fullyQualifiedName_1 = type.getFullyQualifiedName();
            LOG.info("Schema for {} became available, thread unblocked", (Object)_fullyQualifiedName_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Future<Type> waitForTypeDefinition(Type type) {
        SettableFuture future = SettableFuture.create();
        this.promisedTypes.put((Object)type, (Object)future);
        return future;
    }

    private void updatePromisedSchemas(Type builder) {
        boolean _tripleEquals;
        ReferencedTypeImpl _referencedTypeImpl;
        String _packageName = builder.getPackageName();
        String _name = builder.getName();
        ReferencedTypeImpl ref = _referencedTypeImpl = new ReferencedTypeImpl(_packageName, _name);
        Set futures = this.promisedTypes.get((Object)ref);
        boolean _or = false;
        boolean bl = _tripleEquals = futures == null;
        if (_tripleEquals) {
            _or = true;
        } else {
            boolean _isEmpty = futures.isEmpty();
            boolean bl2 = _or = _tripleEquals || _isEmpty;
        }
        if (_or) {
            return;
        }
        for (SettableFuture future : futures) {
            future.set((Object)builder);
        }
        this.promisedTypes.removeAll((Object)builder);
    }

    @Override
    public void close() throws Exception {
    }

    public DataContainer dataObjectFromDataDom(final Class<? extends DataContainer> container, final CompositeNode domData) {
        try {
            Callable<DataObject> _function = new Callable<DataObject>(){

                @Override
                public DataObject call() throws Exception {
                    boolean _equals = Objects.equal((Object)domData, null);
                    if (_equals) {
                        return null;
                    }
                    LazyGeneratedCodecRegistry _registry = RuntimeGeneratedMappingServiceImpl.this.getRegistry();
                    DataContainerCodec transformer = _registry.getCodecForDataObject(container);
                    ValueWithQName _deserialize = transformer.deserialize((Node)domData);
                    DataContainer _value = null;
                    if (_deserialize != null) {
                        _value = (DataContainer)_deserialize.getValue();
                    }
                    DataObject ret = (DataObject)_value;
                    return ret;
                }
            };
            return (DataContainer)RuntimeGeneratedMappingServiceImpl.tryDeserialization(_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

