/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.impl;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.yangtools.binding.generator.util.ReferencedTypeImpl;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.sal.binding.generator.impl.CodecMapping;
import org.opendaylight.yangtools.sal.binding.generator.impl.GeneratorListener;
import org.opendaylight.yangtools.sal.binding.generator.impl.InstanceIdentifierCodecImpl;
import org.opendaylight.yangtools.sal.binding.generator.impl.IntermediateMapping;
import org.opendaylight.yangtools.sal.binding.generator.impl.ModuleContext;
import org.opendaylight.yangtools.sal.binding.generator.impl.SchemaLock;
import org.opendaylight.yangtools.sal.binding.generator.impl.TransformerGenerator;
import org.opendaylight.yangtools.sal.binding.generator.util.ClassLoaderUtils;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.BindingCodec;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.codec.AugmentationCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.ChoiceCaseCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.ChoiceCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.opendaylight.yangtools.yang.data.impl.codec.DataContainerCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DomCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.IdentifierCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.IdentityCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.ValueWithQName;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyGeneratedCodecRegistry
implements CodecRegistry,
SchemaServiceListener,
GeneratorListener {
    private static final Logger LOG = LoggerFactory.getLogger(LazyGeneratedCodecRegistry.class);
    private static final LateMixinCodec NOT_READY_CODEC = new LateMixinCodec();
    private final InstanceIdentifierCodec instanceIdentifierCodec = new InstanceIdentifierCodecImpl(this);
    private final IdentityCompositeCodec identityRefCodec = new IdentityCompositeCodec();
    private TransformerGenerator generator;
    private static final Map<Class<?>, DataContainerCodec<?>> containerCodecs = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, IdentifierCodec<?>> identifierCodecs = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, ChoiceCodecImpl<?>> choiceCodecs = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, ChoiceCaseCodecImpl<?>> caseCodecs = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, AugmentableCompositeCodec> augmentableCodecs = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, AugmentationCodec<?>> augmentationCodecs = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, QName> identityQNames = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<QName, org.opendaylight.yangtools.sal.binding.model.api.Type> qnamesToIdentityMap = new ConcurrentHashMap<QName, org.opendaylight.yangtools.sal.binding.model.api.Type>();
    private static final Map<org.opendaylight.yangtools.sal.binding.model.api.Type, WeakReference<Class>> typeToClass = new ConcurrentHashMap<org.opendaylight.yangtools.sal.binding.model.api.Type, WeakReference<Class>>();
    private static final ConcurrentMap<org.opendaylight.yangtools.sal.binding.model.api.Type, ChoiceCaseCodecImpl> typeToCaseCodecs = new ConcurrentHashMap<org.opendaylight.yangtools.sal.binding.model.api.Type, ChoiceCaseCodecImpl>();
    private CaseClassMapFacade classToCaseRawCodec = new CaseClassMapFacade();
    private static final Map<SchemaPath, GeneratedTypeBuilder> pathToType = new ConcurrentHashMap<SchemaPath, GeneratedTypeBuilder>();
    private static final Map<List<QName>, org.opendaylight.yangtools.sal.binding.model.api.Type> pathToInstantiatedType = new ConcurrentHashMap<List<QName>, org.opendaylight.yangtools.sal.binding.model.api.Type>();
    private static final Map<org.opendaylight.yangtools.sal.binding.model.api.Type, QName> typeToQname = new ConcurrentHashMap<org.opendaylight.yangtools.sal.binding.model.api.Type, QName>();
    private final SchemaLock lock;
    private SchemaContext currentSchema;

    LazyGeneratedCodecRegistry(SchemaLock lock) {
        this.lock = (SchemaLock)Preconditions.checkNotNull((Object)lock);
    }

    public SchemaLock getLock() {
        return this.lock;
    }

    public TransformerGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(TransformerGenerator generator) {
        this.generator = generator;
    }

    public InstanceIdentifierCodec getInstanceIdentifierCodec() {
        return this.instanceIdentifierCodec;
    }

    public <T extends Augmentation<?>> AugmentationCodec<T> getCodecForAugmentation(Class<T> object) {
        AugmentationCodec<?> codec = null;
        AugmentationCodec<?> potentialCodec = augmentationCodecs.get(object);
        if (potentialCodec != null) {
            codec = potentialCodec;
        } else {
            try {
                this.lock.waitForSchema(object);
                Class<? extends BindingCodec<Map<QName, Object>, Object>> augmentRawCodec = this.generator.augmentationTransformerFor(object);
                BindingCodec<Map<QName, Object>, Object> rawCodec = augmentRawCodec.newInstance();
                codec = new AugmentationCodecWrapper(rawCodec);
                augmentationCodecs.put(augmentRawCodec, codec);
            }
            catch (InstantiationException e) {
                LOG.error("Can not instantiate raw augmentation codec {}", (Object)object.getSimpleName(), (Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.debug("BUG: Constructor for {} is not accessible.", (Object)object.getSimpleName(), (Object)e);
            }
        }
        Class<? extends Augmentable<?>> objectSupertype = LazyGeneratedCodecRegistry.getAugmentableArgumentFrom(object);
        if (objectSupertype != null) {
            this.getAugmentableCodec(objectSupertype).addAugmentationCodec(object, codec);
        } else {
            LOG.warn("Could not find augmentation target for augmentation {}", object);
        }
        return codec;
    }

    public QName getQNameForAugmentation(Class<?> cls) {
        Preconditions.checkArgument((boolean)Augmentation.class.isAssignableFrom(cls));
        return this.getCodecForAugmentation(cls).getAugmentationQName();
    }

    private static Class<? extends Augmentable<?>> getAugmentableArgumentFrom(final Class<? extends Augmentation<?>> augmentation) {
        try {
            Class ret = (Class)ClassLoaderUtils.withClassLoader(augmentation.getClassLoader(), new Callable<Class<? extends Augmentable<?>>>(){

                @Override
                public Class<? extends Augmentable<?>> call() throws Exception {
                    for (Type supertype : augmentation.getGenericInterfaces()) {
                        if (!(supertype instanceof ParameterizedType) || !Augmentation.class.equals((Object)((ParameterizedType)supertype).getRawType())) continue;
                        ParameterizedType augmentationGeneric = (ParameterizedType)supertype;
                        return (Class)augmentationGeneric.getActualTypeArguments()[0];
                    }
                    return null;
                }
            });
            return ret;
        }
        catch (Exception e) {
            LOG.debug("Could not find augmentable for {} using {}", new Object[]{augmentation, augmentation.getClassLoader(), e});
            return null;
        }
    }

    public Class<?> getClassForPath(List<QName> names) {
        DataSchemaNode node = this.getSchemaNode(names);
        SchemaPath path = node.getPath();
        Object type = (org.opendaylight.yangtools.sal.binding.model.api.Type)pathToType.get(path);
        type = type != null ? new ReferencedTypeImpl(type.getPackageName(), type.getName()) : pathToInstantiatedType.get(names);
        WeakReference<Class> weakRef = typeToClass.get(type);
        if (weakRef == null) {
            LOG.error("Could not find loaded class for path: {} and type: {}", (Object)path, (Object)type.getFullyQualifiedName());
        }
        return (Class)weakRef.get();
    }

    public void putPathToClass(List<QName> names, Class<?> cls) {
        ConcreteType reference = Types.typeForClass(cls);
        pathToInstantiatedType.put(names, (org.opendaylight.yangtools.sal.binding.model.api.Type)reference);
        this.bindingClassEncountered(cls);
    }

    public IdentifierCodec<?> getKeyCodecForPath(List<QName> names) {
        Class<?> cls = this.getClassForPath(names);
        return this.getIdentifierCodecForIdentifiable(cls);
    }

    public <T extends DataContainer> DataContainerCodec<T> getCodecForDataObject(Class<T> type) {
        DataContainerCodec<?> ret = containerCodecs.get(type);
        if (ret != null) {
            return ret;
        }
        Class<? extends BindingCodec<Map<QName, Object>, Object>> newType = this.generator.transformerFor(type);
        BindingCodec rawCodec = (BindingCodec)this.newInstanceOf(newType);
        DataContainerCodecImpl newWrapper = new DataContainerCodecImpl((BindingCodec<Map<QName, Object>, Object>)rawCodec);
        containerCodecs.put(type, newWrapper);
        return newWrapper;
    }

    public void bindingClassEncountered(Class cls) {
        ConcreteType typeRef = Types.typeForClass((Class)cls);
        if (typeToClass.containsKey(typeRef)) {
            return;
        }
        LOG.trace("Binding Class {} encountered.", (Object)cls);
        WeakReference<Class> weakRef = new WeakReference<Class>(cls);
        typeToClass.put((org.opendaylight.yangtools.sal.binding.model.api.Type)typeRef, weakRef);
        if (!Augmentation.class.isAssignableFrom(cls) && DataObject.class.isAssignableFrom(cls)) {
            DataContainerCodec cdc = this.getCodecForDataObject(cls);
        }
    }

    @Override
    public void onClassProcessed(Class<?> cls) {
        ConcreteType typeRef = Types.typeForClass(cls);
        if (typeToClass.containsKey(typeRef)) {
            return;
        }
        LOG.trace("Binding Class {} encountered.", cls);
        WeakReference weakRef = new WeakReference(cls);
        typeToClass.put((org.opendaylight.yangtools.sal.binding.model.api.Type)typeRef, weakRef);
    }

    private DataSchemaNode getSchemaNode(List<QName> path) {
        QName firstNode = path.get(0);
        Module previous = this.currentSchema.findModuleByNamespaceAndRevision(firstNode.getNamespace(), firstNode.getRevision());
        Iterator<QName> iterator = path.iterator();
        while (iterator.hasNext()) {
            QName arg = iterator.next();
            DataSchemaNode currentNode = previous.getDataChildByName(arg);
            if (currentNode == null && previous instanceof DataNodeContainer) {
                currentNode = this.searchInChoices((DataNodeContainer)previous, arg);
            }
            if (currentNode instanceof DataNodeContainer) {
                previous = (DataNodeContainer)currentNode;
                continue;
            }
            if (!(currentNode instanceof LeafSchemaNode) && !(currentNode instanceof LeafListSchemaNode)) continue;
            Preconditions.checkState((!iterator.hasNext() ? 1 : 0) != 0, (Object)"Path tries to nest inside leaf node.");
            return currentNode;
        }
        return (DataSchemaNode)previous;
    }

    private DataSchemaNode searchInChoices(DataNodeContainer node, QName arg) {
        Set children = node.getChildNodes();
        for (DataSchemaNode child : children) {
            ChoiceNode choiceNode;
            DataSchemaNode potential;
            if (!(child instanceof ChoiceNode) || (potential = this.searchInCases(choiceNode = (ChoiceNode)child, arg)) == null) continue;
            return potential;
        }
        return null;
    }

    private DataSchemaNode searchInCases(ChoiceNode choiceNode, QName arg) {
        Set cases = choiceNode.getCases();
        for (ChoiceCaseNode caseNode : cases) {
            DataSchemaNode node = caseNode.getDataChildByName(arg);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private <T> T newInstanceOf(Class<?> newType) {
        try {
            Object ret = newType.newInstance();
            return (T)ret;
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T extends Identifiable<?>> IdentifierCodec<?> getIdentifierCodecForIdentifiable(Class<T> type) {
        IdentifierCodec<?> obj = identifierCodecs.get(type);
        if (obj != null) {
            return obj;
        }
        Class<? extends BindingCodec<Map<QName, Object>, Object>> newCodec = this.generator.keyTransformerForIdentifiable(type);
        BindingCodec newInstance = (BindingCodec)this.newInstanceOf(newCodec);
        IdentifierCodecImpl newWrapper = new IdentifierCodecImpl((BindingCodec<Map<QName, Object>, Object>)newInstance);
        identifierCodecs.put(type, newWrapper);
        return newWrapper;
    }

    public IdentityCodec<?> getIdentityCodec() {
        return this.identityRefCodec;
    }

    public <T extends BaseIdentity> IdentityCodec<T> getCodecForIdentity(Class<T> codec) {
        this.bindingClassEncountered(codec);
        return this.identityRefCodec;
    }

    @Override
    public void onCodecCreated(Class<?> cls) {
        CodecMapping.setIdentifierCodec(cls, this.instanceIdentifierCodec);
        CodecMapping.setIdentityRefCodec(cls, this.identityRefCodec);
    }

    public <T extends Identifier<?>> IdentifierCodec<T> getCodecForIdentifier(Class<T> object) {
        IdentifierCodec<?> obj = identifierCodecs.get(object);
        if (obj != null) {
            return obj;
        }
        Class<? extends BindingCodec<Map<QName, Object>, Object>> newCodec = this.generator.keyTransformerForIdentifier(object);
        BindingCodec newInstance = (BindingCodec)this.newInstanceOf(newCodec);
        IdentifierCodecImpl newWrapper = new IdentifierCodecImpl((BindingCodec<Map<QName, Object>, Object>)newInstance);
        identifierCodecs.put(object, newWrapper);
        return newWrapper;
    }

    public ChoiceCaseCodecImpl getCaseCodecFor(Class caseClass) {
        ChoiceCaseCodecImpl<?> potential = caseCodecs.get(caseClass);
        if (potential != null) {
            return potential;
        }
        ConcreteType typeref = Types.typeForClass((Class)caseClass);
        ChoiceCaseCodecImpl caseCodec = (ChoiceCaseCodecImpl)typeToCaseCodecs.get(typeref);
        Preconditions.checkState((caseCodec != null ? 1 : 0) != 0, (String)"Case Codec was not created proactivelly for %s", (Object[])new Object[]{caseClass.getName()});
        Preconditions.checkState((caseCodec.getSchema() != null ? 1 : 0) != 0, (String)"Case schema is not available for %s", (Object[])new Object[]{caseClass.getName()});
        Class<? extends BindingCodec<Object, Object>> newCodec = this.generator.caseCodecFor(caseClass, caseCodec.getSchema());
        BindingCodec newInstance = (BindingCodec)this.newInstanceOf(newCodec);
        caseCodec.setDelegate(newInstance);
        caseCodecs.put(caseClass, caseCodec);
        for (Map.Entry<Class<?>, ChoiceCodecImpl<?>> choice : choiceCodecs.entrySet()) {
            if (!choice.getKey().isAssignableFrom(caseClass)) continue;
            ((ChoiceCodecImpl)choice.getValue()).cases.put(caseClass, caseCodec);
        }
        return caseCodec;
    }

    public void onModuleContextAdded(SchemaContext schemaContext, Module module, ModuleContext context) {
        pathToType.putAll(context.getChildNodes());
        qnamesToIdentityMap.putAll(context.getIdentities());
        for (Map.Entry<QName, GeneratedTOBuilder> identity : context.getIdentities().entrySet()) {
            typeToQname.put((org.opendaylight.yangtools.sal.binding.model.api.Type)new ReferencedTypeImpl(identity.getValue().getPackageName(), identity.getValue().getName()), identity.getKey());
        }
        this.captureCases(context.getCases(), schemaContext);
    }

    private void captureCases(Map<SchemaPath, GeneratedTypeBuilder> cases, SchemaContext module) {
        for (Map.Entry<SchemaPath, GeneratedTypeBuilder> caseNode : cases.entrySet()) {
            ChoiceCaseCodecImpl value;
            ReferencedTypeImpl typeref = new ReferencedTypeImpl(caseNode.getValue().getPackageName(), caseNode.getValue().getName());
            pathToType.put(caseNode.getKey(), caseNode.getValue());
            ChoiceCaseNode node = (ChoiceCaseNode)SchemaContextUtil.findDataSchemaNode((SchemaContext)module, (SchemaPath)caseNode.getKey());
            if (node == null) {
                LOG.error("YANGTools Bug: SchemaNode for {}, with path {} was not found in context.", (Object)typeref.getFullyQualifiedName(), (Object)caseNode.getKey());
                value = new ChoiceCaseCodecImpl();
                typeToCaseCodecs.putIfAbsent((org.opendaylight.yangtools.sal.binding.model.api.Type)typeref, value);
                continue;
            }
            value = new ChoiceCaseCodecImpl(node);
            typeToCaseCodecs.putIfAbsent((org.opendaylight.yangtools.sal.binding.model.api.Type)typeref, value);
        }
    }

    public void onGlobalContextUpdated(SchemaContext context) {
        this.currentSchema = context;
    }

    @Override
    public void onChoiceCodecCreated(Class<?> choiceClass, Class<? extends BindingCodec<Map<QName, Object>, Object>> choiceCodec, ChoiceNode schema) {
        ChoiceCodec oldCodec = choiceCodecs.get(choiceClass);
        Preconditions.checkState((oldCodec == null ? 1 : 0) != 0);
        BindingCodec delegate = (BindingCodec)this.newInstanceOf(choiceCodec);
        ChoiceCodecImpl newCodec = new ChoiceCodecImpl((BindingCodec<Map<QName, Object>, Object>)delegate);
        choiceCodecs.put(choiceClass, newCodec);
        CodecMapping.setClassToCaseMap(choiceCodec, this.classToCaseRawCodec);
        CodecMapping.setCompositeNodeToCaseMap(choiceCodec, newCodec.getCompositeToCase());
        this.tryToCreateCasesCodecs(schema);
    }

    private void tryToCreateCasesCodecs(ChoiceNode schema) {
        for (ChoiceCaseNode caseNode : schema.getCases()) {
            Class<?> caseClass;
            GeneratedTypeBuilder type;
            SchemaPath path = caseNode.getPath();
            if (path == null || (type = pathToType.get(path)) == null) continue;
            ReferencedTypeImpl typeref = new ReferencedTypeImpl(type.getPackageName(), type.getName());
            ChoiceCaseCodecImpl partialCodec = (ChoiceCaseCodecImpl)typeToCaseCodecs.get(typeref);
            if (partialCodec.getSchema() == null) {
                partialCodec.setSchema(caseNode);
            }
            if ((caseClass = ClassLoaderUtils.tryToLoadClassWithTCCL(type.getFullyQualifiedName())) == null) continue;
            this.getCaseCodecFor(caseClass);
        }
    }

    @Override
    public void onValueCodecCreated(Class<?> valueClass, Class<?> valueCodec) {
    }

    @Override
    public void onCaseCodecCreated(Class<?> choiceClass, Class<? extends BindingCodec<Map<QName, Object>, Object>> choiceCodec) {
    }

    @Override
    public void onDataContainerCodecCreated(Class<?> dataClass, Class<? extends BindingCodec<?, ?>> dataCodec) {
        if (Augmentable.class.isAssignableFrom(dataClass)) {
            AugmentableCompositeCodec augmentableCodec = this.getAugmentableCodec(dataClass);
            CodecMapping.setAugmentationCodec(dataCodec, augmentableCodec);
        }
    }

    public AugmentableCompositeCodec getAugmentableCodec(Class<?> dataClass) {
        AugmentableCompositeCodec ret = augmentableCodecs.get(dataClass);
        if (ret != null) {
            return ret;
        }
        ret = new AugmentableCompositeCodec(dataClass);
        augmentableCodecs.put(dataClass, ret);
        return ret;
    }

    public boolean isCodecAvailable(Class<? extends DataContainer> cls) {
        if (containerCodecs.containsKey(cls)) {
            return true;
        }
        if (identifierCodecs.containsKey(cls)) {
            return true;
        }
        if (choiceCodecs.containsKey(cls)) {
            return true;
        }
        if (caseCodecs.containsKey(cls)) {
            return true;
        }
        if (augmentableCodecs.containsKey(cls)) {
            return true;
        }
        return augmentationCodecs.containsKey(cls);
    }

    static /* synthetic */ LateMixinCodec access$400() {
        return NOT_READY_CODEC;
    }

    private class IdentityCompositeCodec
    implements IdentityCodec {
        private IdentityCompositeCodec() {
        }

        public Object deserialize(Object input) {
            Preconditions.checkArgument((boolean)(input instanceof QName));
            return this.deserialize((QName)input);
        }

        public Class<?> deserialize(QName input) {
            org.opendaylight.yangtools.sal.binding.model.api.Type type = (org.opendaylight.yangtools.sal.binding.model.api.Type)qnamesToIdentityMap.get(input);
            if (type == null) {
                return null;
            }
            ReferencedTypeImpl typeref = new ReferencedTypeImpl(type.getPackageName(), type.getName());
            WeakReference softref = (WeakReference)typeToClass.get(typeref);
            if (softref == null) {
                return null;
            }
            return (Class)softref.get();
        }

        public QName serialize(Class input) {
            Preconditions.checkArgument((boolean)BaseIdentity.class.isAssignableFrom(input));
            LazyGeneratedCodecRegistry.this.bindingClassEncountered(input);
            QName qname = (QName)identityQNames.get(input);
            if (qname != null) {
                return qname;
            }
            ConcreteType typeref = Types.typeForClass((Class)input);
            qname = (QName)typeToQname.get(typeref);
            if (qname != null) {
                identityQNames.put(input, qname);
            }
            return qname;
        }

        public Object serialize(Object input) {
            Preconditions.checkArgument((boolean)(input instanceof Class));
            return this.serialize((Class)input);
        }
    }

    private static class AugmentationCodecWrapper<T extends Augmentation<?>>
    implements AugmentationCodec<T>,
    Delegator<BindingCodec> {
        private BindingCodec delegate;
        private QName augmentationQName;

        public AugmentationCodecWrapper(BindingCodec<Map<QName, Object>, Object> rawCodec) {
            this.delegate = rawCodec;
            this.augmentationQName = BindingReflections.findQName(rawCodec.getClass());
        }

        public BindingCodec getDelegate() {
            return this.delegate;
        }

        public CompositeNode serialize(ValueWithQName<T> input) {
            List rawValues = (List)this.getDelegate().serialize(input);
            ArrayList<Node<? extends Object>> serialized = new ArrayList<Node<? extends Object>>(rawValues.size());
            for (Map val : rawValues) {
                serialized.add(IntermediateMapping.toNode(val));
            }
            return new CompositeNodeTOImpl(input.getQname(), null, serialized);
        }

        public ValueWithQName<T> deserialize(Node<?> input) {
            Object rawCodecValue = this.getDelegate().deserialize((Object)((Map)input));
            return new ValueWithQName(input.getNodeType(), (Object)((Augmentation)rawCodecValue));
        }

        public QName getAugmentationQName() {
            return this.augmentationQName;
        }
    }

    private static class LateMixinCodec
    implements BindingCodec,
    Delegator<BindingCodec> {
        private BindingCodec delegate;

        private LateMixinCodec() {
        }

        public BindingCodec getDelegate() {
            if (this.delegate == null) {
                throw new IllegalStateException("Codec not initialized yet.");
            }
            return this.delegate;
        }

        public Object deserialize(Object input) {
            return this.getDelegate().deserialize(input);
        }

        public Object serialize(Object input) {
            return this.getDelegate().serialize(input);
        }
    }

    private class AugmentableCompositeCodec
    implements BindingCodec {
        private final Class augmentableType;
        Map<Class, AugmentationCodec<?>> localAugmentationCodecs = Collections.synchronizedMap(new WeakHashMap());

        public AugmentableCompositeCodec(Class type) {
            Preconditions.checkArgument((boolean)Augmentable.class.isAssignableFrom(type));
            this.augmentableType = type;
        }

        public Object serialize(Object input) {
            if (input instanceof Augmentable) {
                Map<Class, Augmentation> augmentations = this.getAugmentations(input);
                return this.serializeImpl(augmentations);
            }
            return null;
        }

        private Map<Class, Augmentation> getAugmentations(Object input) {
            try {
                Field augmentationField = input.getClass().getDeclaredField("augmentation");
                augmentationField.setAccessible(true);
                Map augMap = (Map)augmentationField.get(input);
                return augMap;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOG.debug("Could not read augmentations for {}", input, (Object)e);
                return Collections.emptyMap();
            }
        }

        private List serializeImpl(Map<Class, Augmentation> input) {
            ArrayList ret = new ArrayList();
            for (Map.Entry<Class, Augmentation> entry : input.entrySet()) {
                AugmentationCodec codec = LazyGeneratedCodecRegistry.this.getCodecForAugmentation(entry.getKey());
                CompositeNode node = codec.serialize(new ValueWithQName(null, (Object)entry.getValue()));
                ret.addAll(node.getChildren());
            }
            return ret;
        }

        public synchronized <T extends Augmentation<?>> void addAugmentationCodec(Class<T> augmentationClass, AugmentationCodec<T> value) {
            this.localAugmentationCodecs.put(augmentationClass, value);
        }

        public Map<Class, Augmentation> deserialize(Object input) {
            HashMap<Class, Augmentation> ret = new HashMap<Class, Augmentation>();
            if (input instanceof CompositeNode) {
                ArrayList codecs = new ArrayList(this.localAugmentationCodecs.entrySet());
                for (Map.Entry entry : codecs) {
                    ValueWithQName value = ((AugmentationCodec)entry.getValue()).deserialize((Node)((CompositeNode)input));
                    if (value == null || value.getValue() == null) continue;
                    ret.put((Class)entry.getKey(), (Augmentation)value.getValue());
                }
            }
            return ret;
        }

        public Class getAugmentableType() {
            return this.augmentableType;
        }
    }

    private static abstract class MapFacadeBase<T>
    implements Map<T, BindingCodec<?, ?>> {
        private MapFacadeBase() {
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public void clear() {
            throw this.notModifiable();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public BindingCodec remove(Object key) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<BindingCodec<?, ?>> values() {
            return Collections.emptySet();
        }

        private UnsupportedOperationException notModifiable() {
            return new UnsupportedOperationException("Not externally modifiable.");
        }

        @Override
        public BindingCodec<Map<QName, Object>, Object> put(T key, BindingCodec<?, ?> value) {
            throw this.notModifiable();
        }

        @Override
        public void putAll(Map<? extends T, ? extends BindingCodec<?, ?>> m) {
            throw this.notModifiable();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Set<T> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<T, BindingCodec<?, ?>>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }
    }

    private static class CaseCompositeNodeMapFacade
    extends MapFacadeBase<CompositeNode> {
        final Map<Class, ChoiceCaseCodecImpl<?>> choiceCases;

        public CaseCompositeNodeMapFacade(Map<Class, ChoiceCaseCodecImpl<?>> choiceCases) {
            this.choiceCases = choiceCases;
        }

        @Override
        public BindingCodec get(Object key) {
            if (!(key instanceof CompositeNode)) {
                return null;
            }
            for (Map.Entry<Class, ChoiceCaseCodecImpl<?>> entry : this.choiceCases.entrySet()) {
                ChoiceCaseCodecImpl<?> codec = entry.getValue();
                if (!codec.isAcceptable((Node<?>)((CompositeNode)key))) continue;
                return codec.getDelegate();
            }
            return null;
        }
    }

    private class CaseClassMapFacade
    extends MapFacadeBase {
        private CaseClassMapFacade() {
        }

        @Override
        public Set<Map.Entry<Class, BindingCodec<Object, Object>>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public BindingCodec get(Object key) {
            if (key instanceof Class) {
                Class cls = (Class)key;
                ChoiceCaseCodecImpl caseCodec = LazyGeneratedCodecRegistry.this.getCaseCodecFor(cls);
                return caseCodec.getDelegate();
            }
            return null;
        }
    }

    private static class ChoiceCodecImpl<T>
    implements ChoiceCodec<T> {
        private final BindingCodec<Map<QName, Object>, Object> delegate;
        private final Map<Class, ChoiceCaseCodecImpl<?>> cases = Collections.synchronizedMap(new WeakHashMap());
        private final CaseCompositeNodeMapFacade CompositeToCase;

        public ChoiceCodecImpl(BindingCodec<Map<QName, Object>, Object> delegate) {
            this.delegate = delegate;
            this.CompositeToCase = new CaseCompositeNodeMapFacade(this.cases);
        }

        public ValueWithQName<T> deserialize(Node<?> input) {
            throw new UnsupportedOperationException("Direct invocation of this codec is not allowed.");
        }

        public Node<?> serialize(ValueWithQName<T> input) {
            throw new UnsupportedOperationException("Direct invocation of this codec is not allowed.");
        }

        public CaseCompositeNodeMapFacade getCompositeToCase() {
            return this.CompositeToCase;
        }

        public Map<Class, ChoiceCaseCodecImpl<?>> getCases() {
            return this.cases;
        }

        public BindingCodec<Map<QName, Object>, Object> getDelegate() {
            return this.delegate;
        }
    }

    private static class ChoiceCaseCodecImpl<T extends DataContainer>
    implements ChoiceCaseCodec<T>,
    Delegator<BindingCodec> {
        private boolean augmenting;
        private BindingCodec delegate = LazyGeneratedCodecRegistry.access$400();
        private Set<String> validNames;
        private Set<QName> validQNames;
        private ChoiceCaseNode schema;

        public void setSchema(ChoiceCaseNode caseNode) {
            this.schema = this.schema;
            this.schema = caseNode;
            this.validNames = new HashSet<String>();
            this.validQNames = new HashSet<QName>();
            for (DataSchemaNode node : caseNode.getChildNodes()) {
                QName qname = node.getQName();
                this.validQNames.add(qname);
                this.validNames.add(qname.getLocalName());
            }
            this.augmenting = caseNode.isAugmenting();
        }

        public ChoiceCaseCodecImpl() {
        }

        public ChoiceCaseCodecImpl(ChoiceCaseNode caseNode) {
            this.setSchema(caseNode);
        }

        public ValueWithQName<T> deserialize(Node<?> input) {
            throw new UnsupportedOperationException("Direct invocation of this codec is not allowed.");
        }

        public CompositeNode serialize(ValueWithQName<T> input) {
            throw new UnsupportedOperationException("Direct invocation of this codec is not allowed.");
        }

        public BindingCodec getDelegate() {
            return this.delegate;
        }

        public void setDelegate(BindingCodec delegate) {
            this.delegate = delegate;
        }

        public ChoiceCaseNode getSchema() {
            return this.schema;
        }

        public boolean isAcceptable(Node<?> input) {
            if (input instanceof CompositeNode) {
                if (this.augmenting) {
                    return this.checkAugmenting((CompositeNode)input);
                }
                return this.checkLocal((CompositeNode)input);
            }
            return false;
        }

        private boolean checkLocal(CompositeNode input) {
            QName parent = input.getNodeType();
            for (Node childNode : input.getChildren()) {
                QName child = childNode.getNodeType();
                if (!Objects.equals(parent.getNamespace(), child.getNamespace()) || !Objects.equals(parent.getRevision(), child.getRevision()) || !this.validNames.contains(child.getLocalName())) continue;
                return true;
            }
            return false;
        }

        private boolean checkAugmenting(CompositeNode input) {
            for (Node child : input.getChildren()) {
                if (!this.validQNames.contains(child.getNodeType())) continue;
                return true;
            }
            return false;
        }
    }

    private static class DataContainerCodecImpl<T extends DataContainer>
    extends IntermediateCodec<T>
    implements DataContainerCodec<T> {
        public DataContainerCodecImpl(BindingCodec<Map<QName, Object>, Object> delegate) {
            super(delegate);
        }

        public ValueWithQName<T> deserialize(Node<?> input) {
            if (input == null) {
                return null;
            }
            QName qname = input.getNodeType();
            DataContainer value = (DataContainer)this.getDelegate().deserialize((Object)((Map)input));
            return new ValueWithQName(qname, (Object)value);
        }

        public CompositeNode serialize(ValueWithQName<T> input) {
            return (CompositeNode)super.serialize(input);
        }
    }

    private static class IdentifierCodecImpl<T extends Identifier<?>>
    extends IntermediateCodec<T>
    implements IdentifierCodec<T> {
        public IdentifierCodecImpl(BindingCodec<Map<QName, Object>, Object> delegate) {
            super(delegate);
        }

        public ValueWithQName<T> deserialize(Node<?> input) {
            QName qname = input.getNodeType();
            Identifier value = (Identifier)this.getDelegate().deserialize((Object)((Map)input));
            return new ValueWithQName(qname, (Object)value);
        }

        public CompositeNode serialize(ValueWithQName<T> input) {
            return (CompositeNode)super.serialize(input);
        }
    }

    private static abstract class IntermediateCodec<T>
    implements DomCodec<T>,
    Delegator<BindingCodec<Map<QName, Object>, Object>> {
        private final BindingCodec<Map<QName, Object>, Object> delegate;

        public BindingCodec<Map<QName, Object>, Object> getDelegate() {
            return this.delegate;
        }

        public IntermediateCodec(BindingCodec<Map<QName, Object>, Object> delegate) {
            this.delegate = delegate;
        }

        public Node<?> serialize(ValueWithQName<T> input) {
            Map intermediateOutput = (Map)this.delegate.serialize(input);
            return IntermediateMapping.toNode(intermediateOutput);
        }
    }
}

