/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.impl;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.yangtools.sal.binding.generator.impl.CodecTypeUtils;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.SimpleNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.opendaylight.yangtools.yang.data.impl.codec.IdentifierCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.ValueWithQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceIdentifierCodecImpl
implements InstanceIdentifierCodec {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(InstanceIdentifierCodecImpl.class);
            return _logger;
        }
    }.apply();
    private final CodecRegistry codecRegistry;
    private final Map<Class<? extends Object>, Map<List<QName>, Class<? extends Object>>> classToPreviousAugment = new Functions.Function0<Map<Class<? extends Object>, Map<List<QName>, Class<? extends Object>>>>(){

        public Map<Class<? extends Object>, Map<List<QName>, Class<? extends Object>>> apply() {
            WeakHashMap _weakHashMap = new WeakHashMap();
            Map<Class<? extends Object>, Map<List<QName>, Class<? extends Object>>> _synchronizedMap = Collections.synchronizedMap(_weakHashMap);
            return _synchronizedMap;
        }
    }.apply();

    public InstanceIdentifierCodecImpl(CodecRegistry registry) {
        this.codecRegistry = registry;
    }

    public org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends Object> deserialize(InstanceIdentifier input) {
        org.opendaylight.yangtools.yang.binding.InstanceIdentifier _instanceIdentifier;
        ArrayList<Object> _arrayList_1;
        ArrayList<QName> _arrayList;
        Class baType = null;
        List biArgs = input.getPath();
        int _size = biArgs.size();
        ArrayList<QName> scannedPath = _arrayList = new ArrayList<QName>(_size);
        int _size_1 = biArgs.size();
        ArrayList<Object> baArgs = _arrayList_1 = new ArrayList<Object>(_size_1);
        for (InstanceIdentifier.PathArgument biArg : biArgs) {
            Map<List<QName>, Class<? extends Object>> injectAugment;
            boolean _notEquals;
            QName _nodeType = biArg.getNodeType();
            scannedPath.add(_nodeType);
            InstanceIdentifier.PathArgument baArg = this.deserializePathArgument(biArg, scannedPath);
            Class _type = null;
            if (baArg != null) {
                _type = baArg.getType();
            }
            boolean bl = _notEquals = !Objects.equal(injectAugment = this.classToPreviousAugment.get(baType = _type), null);
            if (_notEquals) {
                boolean _notEquals_1;
                Class<? extends Object> _get = injectAugment.get(scannedPath);
                Class<? extends Object> augment = _get;
                boolean bl2 = _notEquals_1 = !Objects.equal(augment, null);
                if (_notEquals_1) {
                    InstanceIdentifier.Item _item = new InstanceIdentifier.Item(augment);
                    baArgs.add(_item);
                }
            }
            baArgs.add(baArg);
        }
        org.opendaylight.yangtools.yang.binding.InstanceIdentifier ret = _instanceIdentifier = new org.opendaylight.yangtools.yang.binding.InstanceIdentifier(baArgs, baType);
        LOG.debug("DOM Instance Identifier {} deserialized to {}", (Object)input, (Object)ret);
        return ret;
    }

    private InstanceIdentifier.PathArgument _deserializePathArgument(InstanceIdentifier.NodeIdentifier argument, List<QName> processedPath) {
        Class cls = this.codecRegistry.getClassForPath(processedPath);
        InstanceIdentifier.Item _item = new InstanceIdentifier.Item(cls);
        return _item;
    }

    private InstanceIdentifier.PathArgument _deserializePathArgument(InstanceIdentifier.NodeIdentifierWithPredicates argument, List<QName> processedPath) {
        Class type = this.codecRegistry.getClassForPath(processedPath);
        IdentifierCodec codec = this.codecRegistry.getIdentifierCodecForIdentifiable(type);
        CompositeNode _compositeNode = this.toCompositeNode(argument);
        ValueWithQName _deserialize = codec.deserialize((Node)_compositeNode);
        Object _value = null;
        if (_deserialize != null) {
            _value = _deserialize.getValue();
        }
        Object value = _value;
        return CodecTypeUtils.newIdentifiableItem(type, value);
    }

    public CompositeNode toCompositeNode(InstanceIdentifier.NodeIdentifierWithPredicates predicates) {
        ArrayList<SimpleNodeTOImpl> _arrayList;
        Map _keyValues = predicates.getKeyValues();
        Set keyValues = _keyValues.entrySet();
        int _size = keyValues.size();
        ArrayList<SimpleNodeTOImpl> values = _arrayList = new ArrayList<SimpleNodeTOImpl>(_size);
        for (Map.Entry keyValue : keyValues) {
            QName _key = (QName)keyValue.getKey();
            Object _value = keyValue.getValue();
            SimpleNodeTOImpl _simpleNodeTOImpl = new SimpleNodeTOImpl(_key, null, _value);
            values.add(_simpleNodeTOImpl);
        }
        QName _nodeType = predicates.getNodeType();
        CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(_nodeType, null, values);
        return _compositeNodeTOImpl;
    }

    public InstanceIdentifier serialize(org.opendaylight.yangtools.yang.binding.InstanceIdentifier input) {
        InstanceIdentifier _instanceIdentifier;
        ArrayList<QName> _arrayList_1;
        ArrayList<InstanceIdentifier.PathArgument> _arrayList;
        List _path;
        Class previousAugmentation = null;
        List pathArgs = _path = input.getPath();
        QName previousQName = null;
        int _size = pathArgs.size();
        ArrayList<InstanceIdentifier.PathArgument> components = _arrayList = new ArrayList<InstanceIdentifier.PathArgument>(_size);
        int _size_1 = pathArgs.size();
        ArrayList<QName> qnamePath = _arrayList_1 = new ArrayList<QName>(_size_1);
        for (InstanceIdentifier.PathArgument baArg : pathArgs) {
            Class _type_4;
            QName _qNameForAugmentation;
            boolean _not;
            Class _type = baArg.getType();
            boolean _isAssignableFrom = Augmentation.class.isAssignableFrom(_type);
            boolean bl = _not = !_isAssignableFrom;
            if (_not) {
                boolean _tripleNotEquals;
                QName _nodeType;
                InstanceIdentifier.PathArgument biArg = this.serializePathArgument(baArg, previousQName);
                previousQName = _nodeType = biArg.getNodeType();
                components.add(biArg);
                QName _nodeType_1 = biArg.getNodeType();
                qnamePath.add(_nodeType_1);
                ImmutableList immutableList = ImmutableList.copyOf(qnamePath);
                Class _type_1 = baArg.getType();
                this.codecRegistry.putPathToClass((List)immutableList, _type_1);
                boolean bl2 = _tripleNotEquals = previousAugmentation != null;
                if (_tripleNotEquals) {
                    Class _type_2 = baArg.getType();
                    this.updateAugmentationInjection(_type_2, (ImmutableList<QName>)immutableList, previousAugmentation);
                }
                previousAugmentation = null;
                continue;
            }
            Class _type_3 = baArg.getType();
            previousQName = _qNameForAugmentation = this.codecRegistry.getQNameForAugmentation(_type_3);
            previousAugmentation = _type_4 = baArg.getType();
        }
        InstanceIdentifier ret = _instanceIdentifier = new InstanceIdentifier(components);
        LOG.debug("Binding Instance Identifier {} serialized to DOM InstanceIdentifier {}", (Object)input, (Object)ret);
        return ret;
    }

    public Class<? extends Object> updateAugmentationInjection(Class<? extends DataObject> class1, ImmutableList<QName> list, Class<? extends Object> augmentation) {
        Class<? extends Object> _put;
        Class<? extends Object> _xblockexpression = null;
        Map<List<QName>, Class<? extends Object>> _get = this.classToPreviousAugment.get(class1);
        boolean _equals = Objects.equal(_get, null);
        if (_equals) {
            ConcurrentHashMap _concurrentHashMap = new ConcurrentHashMap();
            this.classToPreviousAugment.put(class1, _concurrentHashMap);
        }
        Map<List<QName>, Class<? extends Object>> _get_1 = this.classToPreviousAugment.get(class1);
        _xblockexpression = _put = _get_1.put((List<QName>)list, augmentation);
        return _xblockexpression;
    }

    private InstanceIdentifier.PathArgument _serializePathArgument(InstanceIdentifier.Item argument, QName previousQname) {
        Class type = argument.getType();
        QName qname = BindingReflections.findQName((Class)type);
        boolean _or = false;
        boolean _equals = Objects.equal((Object)previousQname, null);
        if (_equals) {
            _or = true;
        } else {
            Class _type = argument.getType();
            boolean _isAugmentationChild = BindingReflections.isAugmentationChild((Class)_type);
            boolean bl = _or = _equals || _isAugmentationChild;
        }
        if (_or) {
            InstanceIdentifier.NodeIdentifier _nodeIdentifier = new InstanceIdentifier.NodeIdentifier(qname);
            return _nodeIdentifier;
        }
        String _localName = qname.getLocalName();
        QName _create = QName.create((QName)previousQname, (String)_localName);
        InstanceIdentifier.NodeIdentifier _nodeIdentifier_1 = new InstanceIdentifier.NodeIdentifier(_create);
        return _nodeIdentifier_1;
    }

    private InstanceIdentifier.PathArgument _serializePathArgument(InstanceIdentifier.IdentifiableItem argument, QName previousQname) {
        ValueWithQName _valueWithQName;
        boolean _notEquals;
        HashMap<QName, Object> _hashMap;
        HashMap<QName, Object> predicates = _hashMap = new HashMap<QName, Object>();
        Class type = argument.getType();
        IdentifierCodec keyCodec = this.codecRegistry.getIdentifierCodecForIdentifiable(type);
        QName qname = BindingReflections.findQName((Class)type);
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)previousQname, null);
        if (!_notEquals) {
            _and = false;
        } else {
            Class _type = argument.getType();
            boolean _isAugmentationChild = BindingReflections.isAugmentationChild((Class)_type);
            boolean _not = !_isAugmentationChild;
            boolean bl2 = _and = _notEquals && _not;
        }
        if (_and) {
            QName _create;
            String _localName = qname.getLocalName();
            qname = _create = QName.create((QName)previousQname, (String)_localName);
        }
        Identifier _key = argument.getKey();
        ValueWithQName combinedInput = _valueWithQName = new ValueWithQName(previousQname, (Object)_key);
        CompositeNode compositeOutput = keyCodec.serialize(combinedInput);
        List _value = (List)compositeOutput.getValue();
        for (Node outputValue : _value) {
            QName _nodeType = outputValue.getNodeType();
            Object _value_1 = outputValue.getValue();
            predicates.put(_nodeType, _value_1);
        }
        boolean _equals = Objects.equal((Object)previousQname, null);
        if (_equals) {
            InstanceIdentifier.NodeIdentifierWithPredicates _nodeIdentifierWithPredicates = new InstanceIdentifier.NodeIdentifierWithPredicates(qname, predicates);
            return _nodeIdentifierWithPredicates;
        }
        InstanceIdentifier.NodeIdentifierWithPredicates _nodeIdentifierWithPredicates_1 = new InstanceIdentifier.NodeIdentifierWithPredicates(qname, predicates);
        return _nodeIdentifierWithPredicates_1;
    }

    private InstanceIdentifier.PathArgument deserializePathArgument(InstanceIdentifier.PathArgument argument, List<QName> processedPath) {
        if (argument instanceof InstanceIdentifier.NodeIdentifier) {
            return this._deserializePathArgument((InstanceIdentifier.NodeIdentifier)argument, processedPath);
        }
        if (argument instanceof InstanceIdentifier.NodeIdentifierWithPredicates) {
            return this._deserializePathArgument((InstanceIdentifier.NodeIdentifierWithPredicates)argument, processedPath);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(argument, processedPath).toString());
    }

    private InstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument argument, QName previousQname) {
        if (argument instanceof InstanceIdentifier.IdentifiableItem) {
            return this._serializePathArgument((InstanceIdentifier.IdentifiableItem)argument, previousQname);
        }
        if (argument instanceof InstanceIdentifier.Item) {
            return this._serializePathArgument((InstanceIdentifier.Item)argument, previousQname);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(argument, previousQname).toString());
    }
}

