/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924;

import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class DomainName {
    private static final List<Pattern> patterns = new ArrayList<Pattern>();
    public static final List<String> PATTERN_CONSTANTS = Arrays.asList("((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.");
    private final String _value;

    @ConstructorProperties(value={"value"})
    public DomainName(String _value) {
        if (_value != null) {
            boolean isValidLength = false;
            ArrayList<Range> lengthConstraints = new ArrayList<Range>();
            lengthConstraints.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(253)));
            for (Range r : lengthConstraints) {
                if (!r.contains((Comparable)Integer.valueOf(_value.length()))) continue;
                isValidLength = true;
            }
            if (!isValidLength) {
                throw new IllegalArgumentException(String.format("Invalid length: {}, expected: {}.", _value, lengthConstraints));
            }
        }
        this._value = _value;
    }

    public DomainName(DomainName source) {
        this._value = source._value;
    }

    public static DomainName getDefaultInstance(String defaultValue) {
        return new DomainName(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainName other = (DomainName)obj;
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DomainName [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }

    public static List<Range<Integer>> getLength() {
        ArrayList<Range<Integer>> result = new ArrayList<Range<Integer>>();
        result.add(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(253)));
        return result;
    }

    static {
        for (String regEx : PATTERN_CONSTANTS) {
            patterns.add(Pattern.compile(regEx));
        }
    }
}

