/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service.Instance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service.InstanceKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class InstanceBuilder {
    private String _name;
    private String _provider;
    private InstanceKey _key;
    private Map<Class<? extends Augmentation<Instance>>, Augmentation<Instance>> augmentation = new HashMap<Class<? extends Augmentation<Instance>>, Augmentation<Instance>>();

    public String getName() {
        return this._name;
    }

    public String getProvider() {
        return this._provider;
    }

    public InstanceKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Instance>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstanceBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public InstanceBuilder setProvider(String value) {
        this._provider = value;
        return this;
    }

    public InstanceBuilder setKey(InstanceKey value) {
        this._key = value;
        return this;
    }

    public InstanceBuilder addAugmentation(Class<? extends Augmentation<Instance>> augmentationType, Augmentation<Instance> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Instance build() {
        return new InstanceImpl(this);
    }

    private static final class InstanceImpl
    implements Instance {
        private final String _name;
        private final String _provider;
        private final InstanceKey _key;
        private Map<Class<? extends Augmentation<Instance>>, Augmentation<Instance>> augmentation = new HashMap<Class<? extends Augmentation<Instance>>, Augmentation<Instance>>();

        public Class<Instance> getImplementedInterface() {
            return Instance.class;
        }

        private InstanceImpl(InstanceBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new InstanceKey(builder.getName());
                this._name = builder.getName();
            } else {
                this._key = builder.getKey();
                this._name = this._key.getName();
            }
            this._provider = builder.getProvider();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getProvider() {
            return this._provider;
        }

        @Override
        public InstanceKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Instance>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._provider == null ? 0 : this._provider.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceImpl other = (InstanceImpl)obj;
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            if (this._provider == null ? other._provider != null : !this._provider.equals(other._provider)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Instance [_name=");
            builder.append(this._name);
            builder.append(", _provider=");
            builder.append(this._provider);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

