/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.Service;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.ServiceKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service.Instance;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ServiceBuilder {
    private List<Instance> _instance;
    private Class<? extends ServiceType> _type;
    private ServiceKey _key;
    private Map<Class<? extends Augmentation<Service>>, Augmentation<Service>> augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>();

    public List<Instance> getInstance() {
        return this._instance;
    }

    public Class<? extends ServiceType> getType() {
        return this._type;
    }

    public ServiceKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Service>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceBuilder setInstance(List<Instance> value) {
        this._instance = value;
        return this;
    }

    public ServiceBuilder setType(Class<? extends ServiceType> value) {
        this._type = value;
        return this;
    }

    public ServiceBuilder setKey(ServiceKey value) {
        this._key = value;
        return this;
    }

    public ServiceBuilder addAugmentation(Class<? extends Augmentation<Service>> augmentationType, Augmentation<Service> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Service build() {
        return new ServiceImpl(this);
    }

    private static final class ServiceImpl
    implements Service {
        private final List<Instance> _instance;
        private final Class<? extends ServiceType> _type;
        private final ServiceKey _key;
        private Map<Class<? extends Augmentation<Service>>, Augmentation<Service>> augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>();

        public Class<Service> getImplementedInterface() {
            return Service.class;
        }

        private ServiceImpl(ServiceBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new ServiceKey(builder.getType());
                this._type = builder.getType();
            } else {
                this._key = builder.getKey();
                this._type = this._key.getType();
            }
            this._instance = builder.getInstance();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Instance> getInstance() {
            return this._instance;
        }

        @Override
        public Class<? extends ServiceType> getType() {
            return this._type;
        }

        @Override
        public ServiceKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Service>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._instance == null ? 0 : this._instance.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceImpl other = (ServiceImpl)obj;
            if (this._instance == null ? other._instance != null : !this._instance.equals(other._instance)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals(other._type)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Service [_instance=");
            builder.append(this._instance);
            builder.append(", _type=");
            builder.append(this._type);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

