/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ModuleType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.Module;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.ModuleKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.State;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ModuleBuilder {
    private Configuration _configuration;
    private String _name;
    private State _state;
    private Class<? extends ModuleType> _type;
    private ModuleKey _key;
    private Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>();

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public String getName() {
        return this._name;
    }

    public State getState() {
        return this._state;
    }

    public Class<? extends ModuleType> getType() {
        return this._type;
    }

    public ModuleKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Module>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ModuleBuilder setConfiguration(Configuration value) {
        this._configuration = value;
        return this;
    }

    public ModuleBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ModuleBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ModuleBuilder setType(Class<? extends ModuleType> value) {
        this._type = value;
        return this;
    }

    public ModuleBuilder setKey(ModuleKey value) {
        this._key = value;
        return this;
    }

    public ModuleBuilder addAugmentation(Class<? extends Augmentation<Module>> augmentationType, Augmentation<Module> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Module build() {
        return new ModuleImpl(this);
    }

    private static final class ModuleImpl
    implements Module {
        private final Configuration _configuration;
        private final String _name;
        private final State _state;
        private final Class<? extends ModuleType> _type;
        private final ModuleKey _key;
        private Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>();

        public Class<Module> getImplementedInterface() {
            return Module.class;
        }

        private ModuleImpl(ModuleBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new ModuleKey(builder.getName());
                this._name = builder.getName();
            } else {
                this._key = builder.getKey();
                this._name = this._key.getName();
            }
            this._configuration = builder.getConfiguration();
            this._state = builder.getState();
            this._type = builder.getType();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Class<? extends ModuleType> getType() {
            return this._type;
        }

        @Override
        public ModuleKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Module>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._configuration == null ? 0 : this._configuration.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._state == null ? 0 : this._state.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleImpl other = (ModuleImpl)obj;
            if (this._configuration == null ? other._configuration != null : !this._configuration.equals(other._configuration)) {
                return false;
            }
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            if (this._state == null ? other._state != null : !this._state.equals(other._state)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals(other._type)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Module [_configuration=");
            builder.append(this._configuration);
            builder.append(", _name=");
            builder.append(this._name);
            builder.append(", _state=");
            builder.append(this._state);
            builder.append(", _type=");
            builder.append(this._type);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

