/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.api.ModuleIdentifier;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = -6072893219820274247L;
    private final Map<String, Map<String, ExceptionMessageWithStackTrace>> failedValidations;

    public ValidationException(Map<String, Map<String, ExceptionMessageWithStackTrace>> failedValidations) {
        super(failedValidations.toString());
        this.failedValidations = Collections.unmodifiableMap(failedValidations);
    }

    public static ValidationException createFromCollectedValidationExceptions(List<ValidationException> collectedExceptions) {
        HashMap<String, Map<String, ExceptionMessageWithStackTrace>> failedValidations = new HashMap<String, Map<String, ExceptionMessageWithStackTrace>>();
        for (ValidationException ve : collectedExceptions) {
            for (Map.Entry<String, Map<String, ExceptionMessageWithStackTrace>> outerEntry : ve.getFailedValidations().entrySet()) {
                for (Map.Entry<String, ExceptionMessageWithStackTrace> innerEntry : outerEntry.getValue().entrySet()) {
                    String moduleName = outerEntry.getKey();
                    String instanceName = innerEntry.getKey();
                    ExceptionMessageWithStackTrace ex = innerEntry.getValue();
                    HashMap<String, ExceptionMessageWithStackTrace> instanceToExMap = (HashMap<String, ExceptionMessageWithStackTrace>)failedValidations.get(moduleName);
                    if (instanceToExMap == null) {
                        instanceToExMap = new HashMap<String, ExceptionMessageWithStackTrace>();
                        failedValidations.put(moduleName, instanceToExMap);
                    }
                    if (instanceToExMap.containsKey(instanceName)) {
                        throw new IllegalArgumentException("Cannot merge with same module name " + moduleName + " and instance name " + instanceName);
                    }
                    instanceToExMap.put(instanceName, ex);
                }
            }
        }
        return new ValidationException(failedValidations);
    }

    public static ValidationException createForSingleException(ModuleIdentifier moduleIdentifier, Exception e) {
        HashMap<String, Map<String, ExceptionMessageWithStackTrace>> failedValidations = new HashMap<String, Map<String, ExceptionMessageWithStackTrace>>();
        HashMap<String, ExceptionMessageWithStackTrace> innerMap = new HashMap<String, ExceptionMessageWithStackTrace>();
        failedValidations.put(moduleIdentifier.getFactoryName(), innerMap);
        innerMap.put(moduleIdentifier.getInstanceName(), new ExceptionMessageWithStackTrace(e));
        return new ValidationException(failedValidations);
    }

    public Map<String, Map<String, ExceptionMessageWithStackTrace>> getFailedValidations() {
        return this.failedValidations;
    }

    public static class ExceptionMessageWithStackTrace {
        private String message;
        private String stackTrace;

        public ExceptionMessageWithStackTrace() {
        }

        public ExceptionMessageWithStackTrace(String message, String stackTrace) {
            this.message = message;
            this.stackTrace = stackTrace;
        }

        public ExceptionMessageWithStackTrace(Exception e) {
            this(e.getMessage(), Arrays.toString(e.getStackTrace()));
        }

        public String getMessage() {
            return this.message;
        }

        public String getTrace() {
            return this.stackTrace;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.stackTrace == null ? 0 : this.stackTrace.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExceptionMessageWithStackTrace other = (ExceptionMessageWithStackTrace)obj;
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            return !(this.stackTrace == null ? other.stackTrace != null : !this.stackTrace.equals(other.stackTrace));
        }

        public String toString() {
            return this.message;
        }
    }
}

