/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.arphandler;

import java.net.InetAddress;
import org.opendaylight.controller.arphandler.ARPEvent;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.switchmanager.Subnet;

public class ARPRequest
extends ARPEvent {
    private final Subnet subnet;
    private final HostNodeConnector host;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.subnet == null ? 0 : this.subnet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ARPRequest)) {
            return false;
        }
        ARPRequest other = (ARPRequest)obj;
        if (this.host == null ? other.host != null : !this.host.equals((Object)other.host)) {
            return false;
        }
        return !(this.subnet == null ? other.subnet != null : !this.subnet.equals((Object)other.subnet));
    }

    public ARPRequest(InetAddress ip, Subnet subnet) {
        super(ip);
        this.subnet = subnet;
        this.host = null;
    }

    public ARPRequest(HostNodeConnector host, Subnet subnet) {
        super(host.getNetworkAddress());
        this.host = host;
        this.subnet = subnet;
    }

    public Subnet getSubnet() {
        return this.subnet;
    }

    public HostNodeConnector getHost() {
        return this.host;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ARPRequest [");
        if (this.subnet != null) {
            builder.append("subnet=").append(this.subnet).append(", ");
        }
        if (this.host != null) {
            builder.append("host=").append(this.host);
        }
        builder.append("]");
        return builder.toString();
    }
}

