/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.arphandler;

import java.net.InetAddress;
import java.util.Arrays;
import org.opendaylight.controller.arphandler.ARPEvent;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.HexEncode;

public class ARPReply
extends ARPEvent {
    private final NodeConnector port;
    private final byte[] tMac;
    private final byte[] sMac;
    private final InetAddress sIP;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sIP == null ? 0 : this.sIP.hashCode());
        result = 31 * result + Arrays.hashCode(this.sMac);
        result = 31 * result + Arrays.hashCode(this.tMac);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ARPReply)) {
            return false;
        }
        ARPReply other = (ARPReply)obj;
        if (this.sIP == null ? other.sIP != null : !this.sIP.equals(other.sIP)) {
            return false;
        }
        if (!Arrays.equals(this.sMac, other.sMac)) {
            return false;
        }
        return Arrays.equals(this.tMac, other.tMac);
    }

    public ARPReply(NodeConnector port, InetAddress sIP, byte[] sMAC, InetAddress tIP, byte[] tMAC) {
        super(tIP);
        this.tMac = tMAC;
        this.sIP = sIP;
        this.sMac = sMAC;
        this.port = port;
    }

    public ARPReply(InetAddress tIP, byte[] tMAC) {
        super(tIP);
        this.tMac = tMAC;
        this.sIP = null;
        this.sMac = null;
        this.port = null;
    }

    public byte[] getTargetMac() {
        return this.tMac;
    }

    public byte[] getSourceMac() {
        return this.sMac;
    }

    public InetAddress getSourceIP() {
        return this.sIP;
    }

    public NodeConnector getPort() {
        return this.port;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ARPReply [");
        if (this.port != null) {
            builder.append("port=").append(this.port).append(", ");
        }
        if (this.tMac != null) {
            builder.append("tMac=").append(HexEncode.bytesToHexString((byte[])this.tMac)).append(", ");
        }
        if (this.sMac != null) {
            builder.append("sMac=").append(HexEncode.bytesToHexString((byte[])this.sMac)).append(", ");
        }
        if (this.sIP != null) {
            builder.append("sIP=").append(this.sIP);
        }
        builder.append("]");
        return builder.toString();
    }
}

