/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.arphandler;

import java.io.Serializable;
import java.net.InetAddress;

public abstract class ARPEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InetAddress tIP;

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.tIP == null ? 0 : this.tIP.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ARPEvent)) {
            return false;
        }
        ARPEvent other = (ARPEvent)obj;
        return !(this.tIP == null ? other.tIP != null : !this.tIP.equals(other.tIP));
    }

    public ARPEvent(InetAddress ip) {
        this.tIP = ip;
    }

    public InetAddress getTargetIP() {
        return this.tIP;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ARPEvent [");
        if (this.tIP != null) {
            builder.append("tIP=").append(this.tIP);
        }
        builder.append("]");
        return builder.toString();
    }
}

