/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.opendaylight.controller.sal.restconf.impl.NodeWrapper;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.MutableSimpleNode;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.NodeFactory;

public final class SimpleNodeWrapper
implements NodeWrapper<SimpleNode<?>>,
SimpleNode<Object> {
    private SimpleNode<Object> simpleNode;
    private String localName;
    private Object value;
    private URI namespace;
    private QName name;

    public SimpleNodeWrapper(String localName, Object value) {
        this.localName = (String)Preconditions.checkNotNull((Object)localName);
        this.value = value;
    }

    public SimpleNodeWrapper(URI namespace, String localName, Object value) {
        this(localName, value);
        this.namespace = namespace;
    }

    @Override
    public void setQname(QName name) {
        Preconditions.checkState((this.simpleNode == null ? 1 : 0) != 0, (Object)"Cannot change the object, due to data inconsistencies.");
        this.name = name;
    }

    @Override
    public QName getQname() {
        return this.name;
    }

    @Override
    public String getLocalName() {
        if (this.simpleNode != null) {
            return this.simpleNode.getNodeType().getLocalName();
        }
        return this.localName;
    }

    @Override
    public URI getNamespace() {
        if (this.simpleNode != null) {
            return this.simpleNode.getNodeType().getNamespace();
        }
        return this.namespace;
    }

    @Override
    public void setNamespace(URI namespace) {
        Preconditions.checkState((this.simpleNode == null ? 1 : 0) != 0, (Object)"Cannot change the object, due to data inconsistencies.");
        this.namespace = namespace;
    }

    @Override
    public boolean isChangeAllowed() {
        return this.simpleNode == null;
    }

    @Override
    public SimpleNode<Object> unwrap() {
        if (this.simpleNode == null) {
            if (this.name == null) {
                Preconditions.checkNotNull((Object)this.namespace);
                this.name = new QName(this.namespace, this.localName);
            }
            this.simpleNode = NodeFactory.createImmutableSimpleNode((QName)this.name, null, (Object)this.value);
            this.value = null;
            this.namespace = null;
            this.localName = null;
            this.name = null;
        }
        return this.simpleNode;
    }

    public QName getNodeType() {
        return this.unwrap().getNodeType();
    }

    public CompositeNode getParent() {
        return this.unwrap().getParent();
    }

    public Object getValue() {
        return this.unwrap().getValue();
    }

    public ModifyAction getModificationAction() {
        return this.unwrap().getModificationAction();
    }

    public MutableSimpleNode<Object> asMutable() {
        return this.unwrap().asMutable();
    }

    public QName getKey() {
        return (QName)this.unwrap().getKey();
    }

    public Object setValue(Object value) {
        return this.unwrap().setValue(value);
    }
}

