/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.sal.core.api.mount.MountInstance;
import org.opendaylight.controller.sal.rest.api.RestconfService;
import org.opendaylight.controller.sal.restconf.impl.BrokerFacade;
import org.opendaylight.controller.sal.restconf.impl.CompositeNodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.ControllerContext;
import org.opendaylight.controller.sal.restconf.impl.EmptyNodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.IdentityValuesDTO;
import org.opendaylight.controller.sal.restconf.impl.InstanceIdWithSchemaNode;
import org.opendaylight.controller.sal.restconf.impl.NodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.ResponseException;
import org.opendaylight.controller.sal.restconf.impl.RestCodec;
import org.opendaylight.controller.sal.restconf.impl.SimpleNodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.StructuredData;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.MutableCompositeNode;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.NodeFactory;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;

public class RestconfImpl
implements RestconfService {
    private static final RestconfImpl INSTANCE = new Functions.Function0<RestconfImpl>(){

        @Override
        public RestconfImpl apply() {
            RestconfImpl _restconfImpl = new RestconfImpl();
            return _restconfImpl;
        }
    }.apply();
    private static final String MOUNT_POINT_MODULE_NAME = "ietf-netconf";
    private BrokerFacade _broker;
    @Extension
    private ControllerContext _controllerContext;

    public BrokerFacade getBroker() {
        return this._broker;
    }

    public void setBroker(BrokerFacade broker) {
        this._broker = broker;
    }

    public ControllerContext getControllerContext() {
        return this._controllerContext;
    }

    public void setControllerContext(ControllerContext controllerContext) {
        this._controllerContext = controllerContext;
    }

    private RestconfImpl() {
        boolean _tripleNotEquals;
        boolean bl = _tripleNotEquals = INSTANCE != null;
        if (_tripleNotEquals) {
            IllegalStateException _illegalStateException = new IllegalStateException("Already instantiated");
            throw _illegalStateException;
        }
    }

    public static RestconfImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public StructuredData readAllData() {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Reading all data is currently not supported.");
        throw _unsupportedOperationException;
    }

    @Override
    public StructuredData getModules() {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("TODO: auto-generated method stub");
        throw _unsupportedOperationException;
    }

    @Override
    public Object getRoot() {
        return null;
    }

    @Override
    public StructuredData invokeRpc(String identifier, CompositeNode payload) {
        RpcDefinition _rpcDefinition = this._controllerContext.getRpcDefinition(identifier);
        return this.callRpc(_rpcDefinition, payload);
    }

    @Override
    public StructuredData invokeRpc(String identifier) {
        RpcDefinition _rpcDefinition = this._controllerContext.getRpcDefinition(identifier);
        return this.callRpc(_rpcDefinition, null);
    }

    private StructuredData callRpc(RpcDefinition rpc, CompositeNode payload) {
        boolean _tripleEquals_2;
        boolean _not;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = rpc == null;
        if (_tripleEquals) {
            ResponseException _responseException = new ResponseException(Response.Status.NOT_FOUND, "RPC does not exist.");
            throw _responseException;
        }
        MutableCompositeNode rpcRequest = null;
        boolean bl2 = _tripleEquals_1 = payload == null;
        if (_tripleEquals_1) {
            MutableCompositeNode _createMutableCompositeNode;
            QName _qName = rpc.getQName();
            rpcRequest = _createMutableCompositeNode = NodeFactory.createMutableCompositeNode((QName)_qName, null, null, null, null);
        } else {
            MutableCompositeNode _createMutableCompositeNode_1;
            ArrayList<CompositeNode> _arrayList;
            ContainerSchemaNode _input = rpc.getInput();
            CompositeNode value = this.normalizeNode(payload, (DataSchemaNode)_input, null);
            ArrayList<CompositeNode> input = _arrayList = new ArrayList<CompositeNode>();
            input.add(value);
            QName _qName_1 = rpc.getQName();
            rpcRequest = _createMutableCompositeNode_1 = NodeFactory.createMutableCompositeNode((QName)_qName_1, null, input, null, null);
        }
        BrokerFacade _broker = this.getBroker();
        QName _qName_2 = rpc.getQName();
        RpcResult<CompositeNode> rpcResult = _broker.invokeRpc(_qName_2, (CompositeNode)rpcRequest);
        boolean _isSuccessful = rpcResult.isSuccessful();
        boolean bl3 = _not = !_isSuccessful;
        if (_not) {
            ResponseException _responseException_1 = new ResponseException(Response.Status.INTERNAL_SERVER_ERROR, "Operation failed");
            throw _responseException_1;
        }
        CompositeNode _result = (CompositeNode)rpcResult.getResult();
        boolean bl4 = _tripleEquals_2 = _result == null;
        if (_tripleEquals_2) {
            return null;
        }
        CompositeNode _result_1 = (CompositeNode)rpcResult.getResult();
        ContainerSchemaNode _output = rpc.getOutput();
        StructuredData _structuredData = new StructuredData(_result_1, (DataSchemaNode)_output, null);
        return _structuredData;
    }

    @Override
    public StructuredData readData(String identifier) {
        boolean _tripleNotEquals;
        InstanceIdWithSchemaNode iiWithData = this._controllerContext.toInstanceIdentifier(identifier);
        CompositeNode data = null;
        MountInstance _mountPoint = iiWithData.getMountPoint();
        boolean bl = _tripleNotEquals = _mountPoint != null;
        if (_tripleNotEquals) {
            CompositeNode _readOperationalDataBehindMountPoint;
            BrokerFacade _broker = this.getBroker();
            MountInstance _mountPoint_1 = iiWithData.getMountPoint();
            InstanceIdentifier _instanceIdentifier = iiWithData.getInstanceIdentifier();
            data = _readOperationalDataBehindMountPoint = _broker.readOperationalDataBehindMountPoint(_mountPoint_1, _instanceIdentifier);
        } else {
            CompositeNode _readOperationalData;
            BrokerFacade _broker_1 = this.getBroker();
            InstanceIdentifier _instanceIdentifier_1 = iiWithData.getInstanceIdentifier();
            data = _readOperationalData = _broker_1.readOperationalData(_instanceIdentifier_1);
        }
        DataSchemaNode _schemaNode = iiWithData.getSchemaNode();
        MountInstance _mountPoint_2 = iiWithData.getMountPoint();
        StructuredData _structuredData = new StructuredData(data, _schemaNode, _mountPoint_2);
        return _structuredData;
    }

    @Override
    public StructuredData readConfigurationData(String identifier) {
        boolean _tripleNotEquals;
        InstanceIdWithSchemaNode iiWithData = this._controllerContext.toInstanceIdentifier(identifier);
        CompositeNode data = null;
        MountInstance _mountPoint = iiWithData.getMountPoint();
        boolean bl = _tripleNotEquals = _mountPoint != null;
        if (_tripleNotEquals) {
            CompositeNode _readConfigurationDataBehindMountPoint;
            BrokerFacade _broker = this.getBroker();
            MountInstance _mountPoint_1 = iiWithData.getMountPoint();
            InstanceIdentifier _instanceIdentifier = iiWithData.getInstanceIdentifier();
            data = _readConfigurationDataBehindMountPoint = _broker.readConfigurationDataBehindMountPoint(_mountPoint_1, _instanceIdentifier);
        } else {
            CompositeNode _readConfigurationData;
            BrokerFacade _broker_1 = this.getBroker();
            InstanceIdentifier _instanceIdentifier_1 = iiWithData.getInstanceIdentifier();
            data = _readConfigurationData = _broker_1.readConfigurationData(_instanceIdentifier_1);
        }
        DataSchemaNode _schemaNode = iiWithData.getSchemaNode();
        MountInstance _mountPoint_2 = iiWithData.getMountPoint();
        StructuredData _structuredData = new StructuredData(data, _schemaNode, _mountPoint_2);
        return _structuredData;
    }

    @Override
    public StructuredData readOperationalData(String identifier) {
        boolean _tripleNotEquals;
        InstanceIdWithSchemaNode iiWithData = this._controllerContext.toInstanceIdentifier(identifier);
        CompositeNode data = null;
        MountInstance _mountPoint = iiWithData.getMountPoint();
        boolean bl = _tripleNotEquals = _mountPoint != null;
        if (_tripleNotEquals) {
            CompositeNode _readOperationalDataBehindMountPoint;
            BrokerFacade _broker = this.getBroker();
            MountInstance _mountPoint_1 = iiWithData.getMountPoint();
            InstanceIdentifier _instanceIdentifier = iiWithData.getInstanceIdentifier();
            data = _readOperationalDataBehindMountPoint = _broker.readOperationalDataBehindMountPoint(_mountPoint_1, _instanceIdentifier);
        } else {
            CompositeNode _readOperationalData;
            BrokerFacade _broker_1 = this.getBroker();
            InstanceIdentifier _instanceIdentifier_1 = iiWithData.getInstanceIdentifier();
            data = _readOperationalData = _broker_1.readOperationalData(_instanceIdentifier_1);
        }
        DataSchemaNode _schemaNode = iiWithData.getSchemaNode();
        MountInstance _mountPoint_2 = iiWithData.getMountPoint();
        StructuredData _structuredData = new StructuredData(data, _schemaNode, _mountPoint_2);
        return _structuredData;
    }

    @Override
    public Response updateConfigurationDataLegacy(String identifier, CompositeNode payload) {
        Response _updateConfigurationData = this.updateConfigurationData(identifier, payload);
        return _updateConfigurationData;
    }

    @Override
    public Response updateConfigurationData(String identifier, CompositeNode payload) {
        try {
            TransactionStatus _result;
            boolean _tripleNotEquals;
            Response _xblockexpression = null;
            InstanceIdWithSchemaNode iiWithData = this._controllerContext.toInstanceIdentifier(identifier);
            DataSchemaNode _schemaNode = iiWithData.getSchemaNode();
            MountInstance _mountPoint = iiWithData.getMountPoint();
            CompositeNode value = this.normalizeNode(payload, _schemaNode, _mountPoint);
            RpcResult<TransactionStatus> status = null;
            MountInstance _mountPoint_1 = iiWithData.getMountPoint();
            boolean bl = _tripleNotEquals = _mountPoint_1 != null;
            if (_tripleNotEquals) {
                BrokerFacade _broker = this.getBroker();
                MountInstance _mountPoint_2 = iiWithData.getMountPoint();
                InstanceIdentifier _instanceIdentifier = iiWithData.getInstanceIdentifier();
                Future<RpcResult<TransactionStatus>> _commitConfigurationDataPutBehindMountPoint = _broker.commitConfigurationDataPutBehindMountPoint(_mountPoint_2, _instanceIdentifier, value);
                RpcResult<TransactionStatus> _get = _commitConfigurationDataPutBehindMountPoint.get();
                status = _get;
            } else {
                RpcResult<TransactionStatus> _get_1;
                BrokerFacade _broker_1 = this.getBroker();
                InstanceIdentifier _instanceIdentifier_1 = iiWithData.getInstanceIdentifier();
                Future<RpcResult<TransactionStatus>> _commitConfigurationDataPut = _broker_1.commitConfigurationDataPut(_instanceIdentifier_1, value);
                status = _get_1 = _commitConfigurationDataPut.get();
            }
            Response _switchResult = null;
            TransactionStatus _switchValue = _result = (TransactionStatus)status.getResult();
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_switchValue, (Object)TransactionStatus.COMMITED)) {
                Response _build;
                _matched = true;
                Response.ResponseBuilder _status = Response.status((Response.Status)Response.Status.OK);
                _switchResult = _build = _status.build();
            }
            if (!_matched) {
                Response _build_1;
                Response.ResponseBuilder _status_1 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                _switchResult = _build_1 = _status_1.build();
            }
            _xblockexpression = _switchResult;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    @Override
    public Response createConfigurationDataLegacy(String identifier, CompositeNode payload) {
        Response _createConfigurationData = this.createConfigurationData(identifier, payload);
        return _createConfigurationData;
    }

    @Override
    public Response createConfigurationData(String identifier, CompositeNode payload) {
        try {
            TransactionStatus _result;
            boolean _tripleEquals_2;
            boolean _tripleNotEquals;
            boolean _tripleEquals;
            Response _xblockexpression = null;
            URI _namespace = this.namespace(payload);
            boolean bl = _tripleEquals = _namespace == null;
            if (_tripleEquals) {
                ResponseException _responseException = new ResponseException(Response.Status.BAD_REQUEST, "Data has bad format. Root element node must have namespace (XML format) or module name(JSON format)");
                throw _responseException;
            }
            InstanceIdWithSchemaNode iiWithData = null;
            CompositeNode value = null;
            boolean _representsMountPointRootData = this.representsMountPointRootData(payload);
            if (_representsMountPointRootData) {
                CompositeNode _normalizeNode;
                InstanceIdWithSchemaNode _instanceIdentifier;
                boolean _endsWithMountPoint = this.endsWithMountPoint(identifier);
                if (_endsWithMountPoint) {
                    String _plus = "URI has bad format. URI should be without \"yang-ext:mount";
                    String _plus_1 = _plus + "\" for POST operation.";
                    ResponseException _responseException_1 = new ResponseException(Response.Status.BAD_REQUEST, _plus_1);
                    throw _responseException_1;
                }
                String completIdentifier = this.addMountPointIdentifier(identifier);
                iiWithData = _instanceIdentifier = this._controllerContext.toInstanceIdentifier(completIdentifier);
                DataSchemaNode _schemaNode = iiWithData.getSchemaNode();
                MountInstance _mountPoint = iiWithData.getMountPoint();
                value = _normalizeNode = this.normalizeNode(payload, _schemaNode, _mountPoint);
            } else {
                InstanceIdWithSchemaNode _addLastIdentifierFromData;
                CompositeNode _normalizeNode_1;
                boolean _tripleEquals_1;
                InstanceIdWithSchemaNode uncompleteInstIdWithData = this._controllerContext.toInstanceIdentifier(identifier);
                DataSchemaNode _schemaNode_1 = uncompleteInstIdWithData.getSchemaNode();
                DataNodeContainer parentSchema = (DataNodeContainer)_schemaNode_1;
                MountInstance _mountPoint_1 = uncompleteInstIdWithData.getMountPoint();
                Module module = this.findModule(_mountPoint_1, payload);
                boolean bl2 = _tripleEquals_1 = module == null;
                if (_tripleEquals_1) {
                    URI _namespace_1 = this.namespace(payload);
                    String _plus_2 = "Module was not found for \"" + _namespace_1;
                    String _plus_3 = _plus_2 + "\"";
                    ResponseException _responseException_2 = new ResponseException(Response.Status.BAD_REQUEST, _plus_3);
                    throw _responseException_2;
                }
                String _name = this.getName(payload);
                URI _namespace_2 = module.getNamespace();
                DataSchemaNode schemaNode = this._controllerContext.findInstanceDataChildByNameAndNamespace(parentSchema, _name, _namespace_2);
                MountInstance _mountPoint_2 = uncompleteInstIdWithData.getMountPoint();
                value = _normalizeNode_1 = this.normalizeNode(payload, schemaNode, _mountPoint_2);
                iiWithData = _addLastIdentifierFromData = this.addLastIdentifierFromData(uncompleteInstIdWithData, value, schemaNode);
            }
            RpcResult<TransactionStatus> status = null;
            MountInstance _mountPoint_3 = iiWithData.getMountPoint();
            boolean bl3 = _tripleNotEquals = _mountPoint_3 != null;
            if (_tripleNotEquals) {
                BrokerFacade _broker = this.getBroker();
                MountInstance _mountPoint_4 = iiWithData.getMountPoint();
                InstanceIdentifier _instanceIdentifier_1 = iiWithData.getInstanceIdentifier();
                Future<RpcResult<TransactionStatus>> _commitConfigurationDataPostBehindMountPoint = _broker.commitConfigurationDataPostBehindMountPoint(_mountPoint_4, _instanceIdentifier_1, value);
                RpcResult<TransactionStatus> _get = null;
                if (_commitConfigurationDataPostBehindMountPoint != null) {
                    _get = _commitConfigurationDataPostBehindMountPoint.get();
                }
                status = _get;
            } else {
                BrokerFacade _broker_1 = this.getBroker();
                InstanceIdentifier _instanceIdentifier_2 = iiWithData.getInstanceIdentifier();
                Future<RpcResult<TransactionStatus>> _commitConfigurationDataPost = _broker_1.commitConfigurationDataPost(_instanceIdentifier_2, value);
                RpcResult<TransactionStatus> _get_1 = null;
                if (_commitConfigurationDataPost != null) {
                    _get_1 = _commitConfigurationDataPost.get();
                }
                status = _get_1;
            }
            boolean bl4 = _tripleEquals_2 = status == null;
            if (_tripleEquals_2) {
                Response.ResponseBuilder _status = Response.status((Response.Status)Response.Status.ACCEPTED);
                return _status.build();
            }
            Response _switchResult = null;
            TransactionStatus _switchValue = _result = (TransactionStatus)status.getResult();
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_switchValue, (Object)TransactionStatus.COMMITED)) {
                Response _build;
                _matched = true;
                Response.ResponseBuilder _status_1 = Response.status((Response.Status)Response.Status.NO_CONTENT);
                _switchResult = _build = _status_1.build();
            }
            if (!_matched) {
                Response _build_1;
                Response.ResponseBuilder _status_2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                _switchResult = _build_1 = _status_2.build();
            }
            _xblockexpression = _switchResult;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    @Override
    public Response createConfigurationData(CompositeNode payload) {
        try {
            TransactionStatus _result;
            boolean _tripleEquals_2;
            boolean _tripleNotEquals;
            boolean _tripleEquals_1;
            boolean _tripleEquals;
            Response _xblockexpression = null;
            URI _namespace = this.namespace(payload);
            boolean bl = _tripleEquals = _namespace == null;
            if (_tripleEquals) {
                ResponseException _responseException = new ResponseException(Response.Status.BAD_REQUEST, "Data has bad format. Root element node must have namespace (XML format) or module name(JSON format)");
                throw _responseException;
            }
            Module module = this.findModule(null, payload);
            boolean bl2 = _tripleEquals_1 = module == null;
            if (_tripleEquals_1) {
                ResponseException _responseException_1 = new ResponseException(Response.Status.BAD_REQUEST, "Data has bad format. Root element node has incorrect namespace (XML format) or module name(JSON format)");
                throw _responseException_1;
            }
            String _name = this.getName(payload);
            URI _namespace_1 = module.getNamespace();
            DataSchemaNode schemaNode = this._controllerContext.findInstanceDataChildByNameAndNamespace((DataNodeContainer)module, _name, _namespace_1);
            CompositeNode value = this.normalizeNode(payload, schemaNode, null);
            InstanceIdWithSchemaNode iiWithData = this.addLastIdentifierFromData(null, value, schemaNode);
            RpcResult<TransactionStatus> status = null;
            MountInstance _mountPoint = iiWithData.getMountPoint();
            boolean bl3 = _tripleNotEquals = _mountPoint != null;
            if (_tripleNotEquals) {
                BrokerFacade _broker = this.getBroker();
                MountInstance _mountPoint_1 = iiWithData.getMountPoint();
                InstanceIdentifier _instanceIdentifier = iiWithData.getInstanceIdentifier();
                Future<RpcResult<TransactionStatus>> _commitConfigurationDataPostBehindMountPoint = _broker.commitConfigurationDataPostBehindMountPoint(_mountPoint_1, _instanceIdentifier, value);
                RpcResult<TransactionStatus> _get = null;
                if (_commitConfigurationDataPostBehindMountPoint != null) {
                    _get = _commitConfigurationDataPostBehindMountPoint.get();
                }
                status = _get;
            } else {
                BrokerFacade _broker_1 = this.getBroker();
                InstanceIdentifier _instanceIdentifier_1 = iiWithData.getInstanceIdentifier();
                Future<RpcResult<TransactionStatus>> _commitConfigurationDataPost = _broker_1.commitConfigurationDataPost(_instanceIdentifier_1, value);
                RpcResult<TransactionStatus> _get_1 = null;
                if (_commitConfigurationDataPost != null) {
                    _get_1 = _commitConfigurationDataPost.get();
                }
                status = _get_1;
            }
            boolean bl4 = _tripleEquals_2 = status == null;
            if (_tripleEquals_2) {
                Response.ResponseBuilder _status = Response.status((Response.Status)Response.Status.ACCEPTED);
                return _status.build();
            }
            Response _switchResult = null;
            TransactionStatus _switchValue = _result = (TransactionStatus)status.getResult();
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_switchValue, (Object)TransactionStatus.COMMITED)) {
                Response _build;
                _matched = true;
                Response.ResponseBuilder _status_1 = Response.status((Response.Status)Response.Status.NO_CONTENT);
                _switchResult = _build = _status_1.build();
            }
            if (!_matched) {
                Response _build_1;
                Response.ResponseBuilder _status_2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                _switchResult = _build_1 = _status_2.build();
            }
            _xblockexpression = _switchResult;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    @Override
    public Response deleteConfigurationData(String identifier) {
        try {
            TransactionStatus _result;
            boolean _tripleNotEquals;
            Response _xblockexpression = null;
            InstanceIdWithSchemaNode iiWithData = this._controllerContext.toInstanceIdentifier(identifier);
            RpcResult<TransactionStatus> status = null;
            MountInstance _mountPoint = iiWithData.getMountPoint();
            boolean bl = _tripleNotEquals = _mountPoint != null;
            if (_tripleNotEquals) {
                BrokerFacade _broker = this.getBroker();
                MountInstance _mountPoint_1 = iiWithData.getMountPoint();
                InstanceIdentifier _instanceIdentifier = iiWithData.getInstanceIdentifier();
                Future<RpcResult<TransactionStatus>> _commitConfigurationDataDeleteBehindMountPoint = _broker.commitConfigurationDataDeleteBehindMountPoint(_mountPoint_1, _instanceIdentifier);
                RpcResult<TransactionStatus> _get = _commitConfigurationDataDeleteBehindMountPoint.get();
                status = _get;
            } else {
                RpcResult<TransactionStatus> _get_1;
                BrokerFacade _broker_1 = this.getBroker();
                InstanceIdentifier _instanceIdentifier_1 = iiWithData.getInstanceIdentifier();
                Future<RpcResult<TransactionStatus>> _commitConfigurationDataDelete = _broker_1.commitConfigurationDataDelete(_instanceIdentifier_1);
                status = _get_1 = _commitConfigurationDataDelete.get();
            }
            Response _switchResult = null;
            TransactionStatus _switchValue = _result = (TransactionStatus)status.getResult();
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_switchValue, (Object)TransactionStatus.COMMITED)) {
                Response _build;
                _matched = true;
                Response.ResponseBuilder _status = Response.status((Response.Status)Response.Status.OK);
                _switchResult = _build = _status.build();
            }
            if (!_matched) {
                Response _build_1;
                Response.ResponseBuilder _status_1 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                _switchResult = _build_1 = _status_1.build();
            }
            _xblockexpression = _switchResult;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    private URI _namespace(CompositeNode data) {
        QName _nodeType = data.getNodeType();
        return _nodeType.getNamespace();
    }

    private URI _namespace(CompositeNodeWrapper data) {
        return data.getNamespace();
    }

    private String _localName(CompositeNode data) {
        QName _nodeType = data.getNodeType();
        return _nodeType.getLocalName();
    }

    private String _localName(CompositeNodeWrapper data) {
        return data.getLocalName();
    }

    private Module _findModule(MountInstance mountPoint, CompositeNode data) {
        boolean _tripleNotEquals;
        boolean bl = _tripleNotEquals = mountPoint != null;
        if (_tripleNotEquals) {
            QName _nodeType = data.getNodeType();
            URI _namespace = _nodeType.getNamespace();
            return this._controllerContext.findModuleByNamespace(mountPoint, _namespace);
        }
        QName _nodeType_1 = data.getNodeType();
        URI _namespace_1 = _nodeType_1.getNamespace();
        return this._controllerContext.findModuleByNamespace(_namespace_1);
    }

    private Module _findModule(MountInstance mountPoint, CompositeNodeWrapper data) {
        boolean _tripleNotEquals;
        URI _namespace = data.getNamespace();
        Preconditions.checkNotNull((Object)_namespace);
        Module module = null;
        boolean bl = _tripleNotEquals = mountPoint != null;
        if (_tripleNotEquals) {
            boolean _tripleEquals;
            URI _namespace_1 = data.getNamespace();
            Module _findModuleByNamespace = this._controllerContext.findModuleByNamespace(mountPoint, _namespace_1);
            module = _findModuleByNamespace;
            boolean bl2 = _tripleEquals = module == null;
            if (_tripleEquals) {
                Module _findModuleByName;
                URI _namespace_2 = data.getNamespace();
                String _string = _namespace_2.toString();
                module = _findModuleByName = this._controllerContext.findModuleByName(mountPoint, _string);
            }
        } else {
            boolean _tripleEquals_1;
            URI _namespace_3 = data.getNamespace();
            Module _findModuleByNamespace_1 = this._controllerContext.findModuleByNamespace(_namespace_3);
            module = _findModuleByNamespace_1;
            boolean bl3 = _tripleEquals_1 = module == null;
            if (_tripleEquals_1) {
                Module _findModuleByName_1;
                URI _namespace_4 = data.getNamespace();
                String _string_1 = _namespace_4.toString();
                module = _findModuleByName_1 = this._controllerContext.findModuleByName(_string_1);
            }
        }
        return module;
    }

    private String _getName(CompositeNode data) {
        QName _nodeType = data.getNodeType();
        return _nodeType.getLocalName();
    }

    private String _getName(CompositeNodeWrapper data) {
        return data.getLocalName();
    }

    private InstanceIdWithSchemaNode addLastIdentifierFromData(InstanceIdWithSchemaNode identifierWithSchemaNode, CompositeNode data, DataSchemaNode schemaOfData) {
        InstanceIdentifier.InstanceIdentifierBuilder _builder_1;
        InstanceIdentifier.InstanceIdentifierBuilder _builder;
        InstanceIdentifier _instanceIdentifier = null;
        if (identifierWithSchemaNode != null) {
            _instanceIdentifier = identifierWithSchemaNode.getInstanceIdentifier();
        }
        InstanceIdentifier iiOriginal = _instanceIdentifier;
        InstanceIdentifier.InstanceIdentifierBuilder iiBuilder = null;
        boolean _tripleEquals = iiOriginal == null;
        iiBuilder = _tripleEquals ? (_builder = InstanceIdentifier.builder()) : (_builder_1 = InstanceIdentifier.builder((InstanceIdentifier)iiOriginal));
        if (schemaOfData instanceof ListSchemaNode) {
            QName _qName = schemaOfData.getQName();
            HashMap<QName, Object> _resolveKeysFromData = this.resolveKeysFromData((ListSchemaNode)schemaOfData, data);
            iiBuilder.nodeWithKey(_qName, _resolveKeysFromData);
        } else {
            QName _qName_1 = schemaOfData.getQName();
            iiBuilder.node(_qName_1);
        }
        InstanceIdentifier _instance = (InstanceIdentifier)iiBuilder.toInstance();
        MountInstance _mountPoint = null;
        if (identifierWithSchemaNode != null) {
            _mountPoint = identifierWithSchemaNode.getMountPoint();
        }
        InstanceIdWithSchemaNode _instanceIdWithSchemaNode = new InstanceIdWithSchemaNode(_instance, schemaOfData, _mountPoint);
        return _instanceIdWithSchemaNode;
    }

    private HashMap<QName, Object> resolveKeysFromData(ListSchemaNode listNode, CompositeNode dataNode) {
        HashMap<QName, Object> _hashMap;
        HashMap<QName, Object> keyValues = _hashMap = new HashMap<QName, Object>();
        List _keyDefinition = listNode.getKeyDefinition();
        for (QName key : _keyDefinition) {
            Object dataNodeKeyValueObject;
            boolean _tripleEquals;
            SimpleNode _head = null;
            String _localName = key.getLocalName();
            List _simpleNodesByName = dataNode.getSimpleNodesByName(_localName);
            if (_simpleNodesByName != null) {
                _head = (SimpleNode)IterableExtensions.head(_simpleNodesByName);
            }
            Object _value = null;
            if (_head != null) {
                _value = _head.getValue();
            }
            boolean bl = _tripleEquals = (dataNodeKeyValueObject = _value) == null;
            if (_tripleEquals) {
                QName _nodeType = dataNode.getNodeType();
                String _localName_1 = _nodeType.getLocalName();
                String _plus = "Data contains list \"" + _localName_1;
                String _plus_1 = _plus + "\" which does not contain key: \"";
                String _localName_2 = key.getLocalName();
                String _plus_2 = _plus_1 + _localName_2;
                String _plus_3 = _plus_2 + "\"";
                ResponseException _responseException = new ResponseException(Response.Status.BAD_REQUEST, _plus_3);
                throw _responseException;
            }
            keyValues.put(key, dataNodeKeyValueObject);
        }
        return keyValues;
    }

    private boolean endsWithMountPoint(String identifier) {
        boolean _or = false;
        boolean _endsWith = identifier.endsWith("yang-ext:mount");
        if (_endsWith) {
            _or = true;
        } else {
            String _plus = "yang-ext:mount/";
            boolean _endsWith_1 = identifier.endsWith(_plus);
            _or = _endsWith || _endsWith_1;
        }
        return _or;
    }

    private boolean representsMountPointRootData(CompositeNode data) {
        URI _namespace_1;
        boolean _and = false;
        boolean _or = false;
        URI _namespace = this.namespace(data);
        boolean _equals = Objects.equal((Object)_namespace, (Object)(_namespace_1 = SchemaContext.NAME.getNamespace()));
        if (_equals) {
            _or = true;
        } else {
            URI _namespace_2 = this.namespace(data);
            boolean _equals_1 = Objects.equal((Object)_namespace_2, (Object)MOUNT_POINT_MODULE_NAME);
            boolean bl = _or = _equals || _equals_1;
        }
        if (!_or) {
            _and = false;
        } else {
            String _localName = this.localName(data);
            String _localName_1 = SchemaContext.NAME.getLocalName();
            boolean _equals_2 = Objects.equal((Object)_localName, (Object)_localName_1);
            _and = _or && _equals_2;
        }
        return _and;
    }

    private String addMountPointIdentifier(String identifier) {
        boolean _endsWith = identifier.endsWith("/");
        if (_endsWith) {
            return identifier + "yang-ext:mount";
        }
        String _plus = identifier + "/";
        return _plus + "yang-ext:mount";
    }

    private CompositeNode normalizeNode(CompositeNode node, DataSchemaNode schema, MountInstance mountPoint) {
        boolean _not;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = schema == null;
        if (_tripleEquals) {
            QName _nodeType = null;
            if (node != null) {
                _nodeType = node.getNodeType();
            }
            String _localName = null;
            if (_nodeType != null) {
                _localName = _nodeType.getLocalName();
            }
            String _plus = "Data schema node was not found for " + _localName;
            ResponseException _responseException = new ResponseException(Response.Status.INTERNAL_SERVER_ERROR, _plus);
            throw _responseException;
        }
        boolean bl2 = _not = !(schema instanceof DataNodeContainer);
        if (_not) {
            ResponseException _responseException_1 = new ResponseException(Response.Status.BAD_REQUEST, "Root element has to be container or list yang datatype.");
            throw _responseException_1;
        }
        if (node instanceof CompositeNodeWrapper) {
            boolean _isChangeAllowed = ((CompositeNodeWrapper)node).isChangeAllowed();
            if (_isChangeAllowed) {
                this.normalizeNode((CompositeNodeWrapper)node, schema, null, mountPoint);
            }
            return ((CompositeNodeWrapper)node).unwrap();
        }
        return node;
    }

    private void normalizeNode(NodeWrapper<? extends Object> nodeBuilder, DataSchemaNode schema, QName previousAugment, MountInstance mountPoint) {
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = schema == null;
        if (_tripleEquals) {
            String _localName = nodeBuilder.getLocalName();
            String _plus = "Data has bad format.\n\"" + _localName;
            String _plus_1 = _plus + "\" does not exist in yang schema.";
            ResponseException _responseException = new ResponseException(Response.Status.BAD_REQUEST, _plus_1);
            throw _responseException;
        }
        QName currentAugment = null;
        QName _qname = nodeBuilder.getQname();
        boolean bl2 = _tripleNotEquals = _qname != null;
        if (_tripleNotEquals) {
            currentAugment = previousAugment;
        } else {
            boolean _tripleEquals_1;
            QName _normalizeNodeName;
            currentAugment = _normalizeNodeName = this.normalizeNodeName(nodeBuilder, schema, previousAugment, mountPoint);
            QName _qname_1 = nodeBuilder.getQname();
            boolean bl3 = _tripleEquals_1 = _qname_1 == null;
            if (_tripleEquals_1) {
                String _localName_1 = nodeBuilder.getLocalName();
                String _plus_2 = "Data has bad format.\nIf data is in XML format then namespace for \"" + _localName_1;
                String _plus_3 = _plus_2 + "\" should be \"";
                QName _qName = schema.getQName();
                URI _namespace = _qName.getNamespace();
                String _plus_4 = _plus_3 + _namespace;
                String _plus_5 = _plus_4 + "\".\n";
                String _plus_6 = _plus_5 + "If data is in JSON format then module name for \"";
                String _localName_2 = nodeBuilder.getLocalName();
                String _plus_7 = _plus_6 + _localName_2;
                String _plus_8 = _plus_7 + "\" should be corresponding to namespace \"";
                QName _qName_1 = schema.getQName();
                URI _namespace_1 = _qName_1.getNamespace();
                String _plus_9 = _plus_8 + _namespace_1;
                String _plus_10 = _plus_9 + "\".";
                ResponseException _responseException_1 = new ResponseException(Response.Status.BAD_REQUEST, _plus_10);
                throw _responseException_1;
            }
        }
        if (nodeBuilder instanceof CompositeNodeWrapper) {
            String _localName_4;
            List<NodeWrapper<?>> children = ((CompositeNodeWrapper)nodeBuilder).getValues();
            for (NodeWrapper<?> child : children) {
                boolean _greaterThan;
                String _localName_3 = child.getLocalName();
                List<DataSchemaNode> potentialSchemaNodes = this._controllerContext.findInstanceDataChildrenByName((DataNodeContainer)schema, _localName_3);
                boolean _and = false;
                int _size = potentialSchemaNodes.size();
                boolean bl4 = _greaterThan = _size > 1;
                if (!_greaterThan) {
                    _and = false;
                } else {
                    URI _namespace_2 = child.getNamespace();
                    boolean _tripleEquals_2 = _namespace_2 == null;
                    boolean bl5 = _and = _greaterThan && _tripleEquals_2;
                }
                if (_and) {
                    StringBuilder _stringBuilder;
                    StringBuilder namespacesOfPotentialModules = _stringBuilder = new StringBuilder();
                    for (DataSchemaNode potentialSchemaNode : potentialSchemaNodes) {
                        StringBuilder _append = namespacesOfPotentialModules.append("   ");
                        QName _qName_2 = potentialSchemaNode.getQName();
                        URI _namespace_3 = _qName_2.getNamespace();
                        String _string = _namespace_3.toString();
                        StringBuilder _append_1 = _append.append(_string);
                        _append_1.append("\n");
                    }
                    _localName_4 = child.getLocalName();
                    String _plus_11 = "Node \"" + _localName_4;
                    String _plus_12 = _plus_11 + "\" is added as augment from more than one module. ";
                    String _plus_13 = _plus_12 + "Therefore node must have namespace (XML format) or module name (JSON format).";
                    String _plus_14 = _plus_13 + "\nThe node is added as augment from modules with namespaces:\n";
                    String _plus_15 = _plus_14 + namespacesOfPotentialModules;
                    ResponseException _responseException_2 = new ResponseException(Response.Status.BAD_REQUEST, _plus_15);
                    throw _responseException_2;
                }
                boolean rightNodeSchemaFound = false;
                for (DataSchemaNode potentialSchemaNode_1 : potentialSchemaNodes) {
                    boolean _not = !rightNodeSchemaFound;
                    if (!_not) continue;
                    QName potentialCurrentAugment = this.normalizeNodeName(child, potentialSchemaNode_1, currentAugment, mountPoint);
                    QName _qname_2 = child.getQname();
                    boolean _tripleNotEquals_1 = _qname_2 != null;
                    if (!_tripleNotEquals_1) continue;
                    this.normalizeNode(child, potentialSchemaNode_1, potentialCurrentAugment, mountPoint);
                    rightNodeSchemaFound = true;
                }
                boolean _not_1 = !rightNodeSchemaFound;
                if (!_not_1) continue;
                String _localName_5 = child.getLocalName();
                String _plus_16 = "Schema node \"" + _localName_5;
                String _plus_17 = _plus_16 + "\" was not found in module.";
                ResponseException _responseException_3 = new ResponseException(Response.Status.BAD_REQUEST, _plus_17);
                throw _responseException_3;
            }
            if (schema instanceof ListSchemaNode) {
                List listKeys = ((ListSchemaNode)schema).getKeyDefinition();
                for (QName listKey : listKeys) {
                    boolean foundKey = false;
                    for (NodeWrapper<?> child_1 : children) {
                        Object _unwrap = child_1.unwrap();
                        QName _nodeType = _unwrap.getNodeType();
                        String _localName_3 = _nodeType.getLocalName();
                        boolean _equals = Objects.equal((Object)_localName_3, (Object)(_localName_4 = listKey.getLocalName()));
                        if (!_equals) continue;
                        foundKey = true;
                    }
                    boolean _not = !foundKey;
                    if (!_not) continue;
                    String _localName_5 = listKey.getLocalName();
                    String _plus_11 = "Missing key in URI \"" + _localName_5;
                    String _plus_12 = _plus_11 + "\" of list \"";
                    QName _qName_2 = schema.getQName();
                    String _localName_6 = _qName_2.getLocalName();
                    String _plus_13 = _plus_12 + _localName_6;
                    String _plus_14 = _plus_13 + "\"";
                    ResponseException _responseException_2 = new ResponseException(Response.Status.BAD_REQUEST, _plus_14);
                    throw _responseException_2;
                }
            }
        } else if (nodeBuilder instanceof SimpleNodeWrapper) {
            Object value;
            SimpleNodeWrapper simpleNode = (SimpleNodeWrapper)nodeBuilder;
            Object inputValue = value = simpleNode.getValue();
            TypeDefinition<? extends Object> _typeDefinition = this.typeDefinition(schema);
            if (_typeDefinition instanceof IdentityrefTypeDefinition && value instanceof String) {
                URI _namespace_2 = nodeBuilder.getNamespace();
                String _string = _namespace_2.toString();
                IdentityValuesDTO _identityValuesDTO = new IdentityValuesDTO(_string, (String)value, null);
                inputValue = _identityValuesDTO;
            }
            TypeDefinition<? extends Object> _typeDefinition_1 = this.typeDefinition(schema);
            Codec<Object, Object> _from = RestCodec.from(_typeDefinition_1, mountPoint);
            Object _deserialize = null;
            if (_from != null) {
                _deserialize = _from.deserialize(inputValue);
            }
            Object outputValue = _deserialize;
            simpleNode.setValue(outputValue);
        } else if (nodeBuilder instanceof EmptyNodeWrapper) {
            EmptyNodeWrapper emptyNodeBuilder = (EmptyNodeWrapper)nodeBuilder;
            if (schema instanceof LeafSchemaNode) {
                emptyNodeBuilder.setComposite(false);
            } else if (schema instanceof ContainerSchemaNode) {
                emptyNodeBuilder.setComposite(true);
            }
        }
    }

    private TypeDefinition<? extends Object> _typeDefinition(LeafSchemaNode node) {
        boolean _tripleNotEquals;
        TypeDefinition _xblockexpression = null;
        TypeDefinition baseType = node.getType();
        TypeDefinition _baseType = baseType.getBaseType();
        boolean _while = _tripleNotEquals = _baseType != null;
        while (_while) {
            boolean _tripleNotEquals_1;
            TypeDefinition _baseType_1 = baseType.getBaseType();
            TypeDefinition _baseType_2 = (baseType = _baseType_1).getBaseType();
            _while = _tripleNotEquals_1 = _baseType_2 != null;
        }
        _xblockexpression = baseType;
        return _xblockexpression;
    }

    private TypeDefinition<? extends Object> _typeDefinition(LeafListSchemaNode node) {
        boolean _tripleNotEquals;
        TypeDefinition _xblockexpression = null;
        TypeDefinition baseType = node.getType();
        TypeDefinition _baseType = baseType.getBaseType();
        boolean _while = _tripleNotEquals = _baseType != null;
        while (_while) {
            boolean _tripleNotEquals_1;
            TypeDefinition _baseType_1 = baseType.getBaseType();
            TypeDefinition _baseType_2 = (baseType = _baseType_1).getBaseType();
            _while = _tripleNotEquals_1 = _baseType_2 != null;
        }
        _xblockexpression = baseType;
        return _xblockexpression;
    }

    private QName normalizeNodeName(NodeWrapper<? extends Object> nodeBuilder, DataSchemaNode schema, QName previousAugment, MountInstance mountPoint) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        QName validQName = schema.getQName();
        QName currentAugment = previousAugment;
        boolean _isAugmenting = schema.isAugmenting();
        if (_isAugmenting) {
            QName _qName;
            currentAugment = _qName = schema.getQName();
        } else {
            boolean _tripleNotEquals;
            boolean _and = false;
            boolean bl = _tripleNotEquals = previousAugment != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                URI _namespace_1;
                QName _qName_1 = schema.getQName();
                URI _namespace = _qName_1.getNamespace();
                boolean _tripleNotEquals_1 = _namespace != (_namespace_1 = previousAugment.getNamespace());
                boolean bl2 = _and = _tripleNotEquals && _tripleNotEquals_1;
            }
            if (_and) {
                QName _create;
                QName _qName_2 = schema.getQName();
                String _localName = _qName_2.getLocalName();
                validQName = _create = QName.create((QName)currentAugment, (String)_localName);
            }
        }
        String moduleName = null;
        boolean bl = _tripleEquals = mountPoint == null;
        if (_tripleEquals) {
            String _findModuleNameByNamespace;
            ControllerContext _controllerContext = this.getControllerContext();
            URI _namespace_2 = validQName.getNamespace();
            moduleName = _findModuleNameByNamespace = _controllerContext.findModuleNameByNamespace(_namespace_2);
        } else {
            String _findModuleNameByNamespace_1;
            ControllerContext _controllerContext_1 = this.getControllerContext();
            URI _namespace_3 = validQName.getNamespace();
            moduleName = _findModuleNameByNamespace_1 = _controllerContext_1.findModuleNameByNamespace(mountPoint, _namespace_3);
        }
        boolean _or = false;
        boolean _or_1 = false;
        boolean _or_2 = false;
        URI _namespace_4 = nodeBuilder.getNamespace();
        boolean bl3 = _tripleEquals_1 = _namespace_4 == null;
        if (_tripleEquals_1) {
            _or_2 = true;
        } else {
            URI _namespace_5 = nodeBuilder.getNamespace();
            URI _namespace_6 = validQName.getNamespace();
            boolean _equals = Objects.equal((Object)_namespace_5, (Object)_namespace_6);
            boolean bl4 = _or_2 = _tripleEquals_1 || _equals;
        }
        if (_or_2) {
            _or_1 = true;
        } else {
            URI _namespace_7 = nodeBuilder.getNamespace();
            String _string = _namespace_7.toString();
            boolean _equals_1 = Objects.equal((Object)_string, (Object)moduleName);
            boolean bl5 = _or_1 = _or_2 || _equals_1;
        }
        if (_or_1) {
            _or = true;
        } else {
            URI _namespace_8 = nodeBuilder.getNamespace();
            boolean _equals_2 = Objects.equal((Object)_namespace_8, (Object)MOUNT_POINT_MODULE_NAME);
            boolean bl6 = _or = _or_1 || _equals_2;
        }
        if (_or) {
            nodeBuilder.setQname(validQName);
        }
        return currentAugment;
    }

    private URI namespace(CompositeNode data) {
        if (data instanceof CompositeNodeWrapper) {
            return this._namespace((CompositeNodeWrapper)data);
        }
        if (data != null) {
            return this._namespace(data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }

    private String localName(CompositeNode data) {
        if (data instanceof CompositeNodeWrapper) {
            return this._localName((CompositeNodeWrapper)data);
        }
        if (data != null) {
            return this._localName(data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }

    private Module findModule(MountInstance mountPoint, CompositeNode data) {
        if (data instanceof CompositeNodeWrapper) {
            return this._findModule(mountPoint, (CompositeNodeWrapper)data);
        }
        if (data != null) {
            return this._findModule(mountPoint, data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(mountPoint, data).toString());
    }

    private String getName(CompositeNode data) {
        if (data instanceof CompositeNodeWrapper) {
            return this._getName((CompositeNodeWrapper)data);
        }
        if (data != null) {
            return this._getName(data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }

    private TypeDefinition<? extends Object> typeDefinition(DataSchemaNode node) {
        if (node instanceof LeafListSchemaNode) {
            return this._typeDefinition((LeafListSchemaNode)node);
        }
        if (node instanceof LeafSchemaNode) {
            return this._typeDefinition((LeafSchemaNode)node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }
}

