/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.sal.core.api.mount.MountInstance;
import org.opendaylight.controller.sal.rest.impl.RestUtil;
import org.opendaylight.controller.sal.restconf.impl.ControllerContext;
import org.opendaylight.controller.sal.restconf.impl.IdentityValuesDTO;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.codec.IdentityrefCodec;
import org.opendaylight.yangtools.yang.data.api.codec.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.api.codec.LeafrefCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCodec {
    private static final Logger logger = LoggerFactory.getLogger(RestCodec.class);

    private RestCodec() {
    }

    public static final Codec<Object, Object> from(TypeDefinition<?> typeDefinition, MountInstance mountPoint) {
        return new ObjectCodec(typeDefinition, mountPoint);
    }

    private static Module getModuleByNamespace(String namespace, MountInstance mountPoint) {
        URI validNamespace = RestCodec.resolveValidNamespace(namespace, mountPoint);
        Module module = null;
        module = mountPoint != null ? ControllerContext.getInstance().findModuleByNamespace(mountPoint, validNamespace) : ControllerContext.getInstance().findModuleByNamespace(validNamespace);
        if (module == null) {
            logger.info("Module for namespace " + validNamespace + " wasn't found.");
            return null;
        }
        return module;
    }

    private static URI resolveValidNamespace(String namespace, MountInstance mountPoint) {
        URI validNamespace = mountPoint != null ? ControllerContext.getInstance().findNamespaceByModuleName(mountPoint, namespace) : ControllerContext.getInstance().findNamespaceByModuleName(namespace);
        if (validNamespace == null) {
            validNamespace = URI.create(namespace);
        }
        return validNamespace;
    }

    public static class InstanceIdentifierCodecImpl
    implements InstanceIdentifierCodec<IdentityValuesDTO> {
        private final Logger logger = LoggerFactory.getLogger(InstanceIdentifierCodecImpl.class);
        private final MountInstance mountPoint;

        public InstanceIdentifierCodecImpl(MountInstance mountPoint) {
            this.mountPoint = mountPoint;
        }

        public IdentityValuesDTO serialize(InstanceIdentifier data) {
            List pathArguments = data.getPath();
            IdentityValuesDTO identityValuesDTO = new IdentityValuesDTO();
            for (InstanceIdentifier.PathArgument pathArgument : pathArguments) {
                IdentityValuesDTO.IdentityValue identityValue = this.qNameToIdentityValue(pathArgument.getNodeType());
                if (pathArgument instanceof InstanceIdentifier.NodeIdentifierWithPredicates && identityValue != null) {
                    List<IdentityValuesDTO.Predicate> predicates = this.keyValuesToPredicateList(((InstanceIdentifier.NodeIdentifierWithPredicates)pathArgument).getKeyValues());
                    identityValue.setPredicates(predicates);
                }
                identityValuesDTO.add(identityValue);
            }
            return identityValuesDTO;
        }

        public InstanceIdentifier deserialize(IdentityValuesDTO data) {
            ArrayList<InstanceIdentifier.NodeIdentifier> result = new ArrayList<InstanceIdentifier.NodeIdentifier>();
            IdentityValuesDTO.IdentityValue valueWithNamespace = data.getValuesWithNamespaces().get(0);
            Module module = RestCodec.getModuleByNamespace(valueWithNamespace.getNamespace(), this.mountPoint);
            if (module == null) {
                this.logger.info("Module by namespace '{}' of first node in instance-identiefier was not found.", (Object)valueWithNamespace.getNamespace());
                this.logger.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(valueWithNamespace.getValue()));
                return null;
            }
            Module parentContainer = module;
            List<IdentityValuesDTO.IdentityValue> identities = data.getValuesWithNamespaces();
            for (int i = 0; i < identities.size(); ++i) {
                IdentityValuesDTO.IdentityValue identityValue = identities.get(i);
                URI validNamespace = RestCodec.resolveValidNamespace(identityValue.getNamespace(), this.mountPoint);
                DataSchemaNode node = ControllerContext.getInstance().findInstanceDataChildByNameAndNamespace((DataNodeContainer)parentContainer, identityValue.getValue(), validNamespace);
                if (node == null) {
                    this.logger.info("'{}' node was not found in {}", (Object)identityValue, (Object)parentContainer.getChildNodes());
                    this.logger.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(identityValue.getValue()));
                    return null;
                }
                QName qName = node.getQName();
                InstanceIdentifier.NodeIdentifier pathArgument = null;
                if (identityValue.getPredicates().isEmpty()) {
                    pathArgument = new InstanceIdentifier.NodeIdentifier(qName);
                } else if (node instanceof LeafListSchemaNode) {
                    IdentityValuesDTO.Predicate leafListPredicate = identityValue.getPredicates().get(0);
                    if (!leafListPredicate.isLeafList()) {
                        this.logger.info("Predicate's data is not type of leaf-list. It should be in format \".='value'\"");
                        this.logger.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(identityValue.getValue()));
                        return null;
                    }
                    pathArgument = new InstanceIdentifier.NodeWithValue(qName, (Object)leafListPredicate.getValue());
                } else if (node instanceof ListSchemaNode) {
                    DataNodeContainer listNode = (DataNodeContainer)node;
                    HashMap<QName, String> predicatesMap = new HashMap<QName, String>();
                    for (IdentityValuesDTO.Predicate predicate : identityValue.getPredicates()) {
                        validNamespace = RestCodec.resolveValidNamespace(predicate.getName().getNamespace(), this.mountPoint);
                        DataSchemaNode listKey = ControllerContext.getInstance().findInstanceDataChildByNameAndNamespace(listNode, predicate.getName().getValue(), validNamespace);
                        predicatesMap.put(listKey.getQName(), predicate.getValue());
                    }
                    pathArgument = new InstanceIdentifier.NodeIdentifierWithPredicates(qName, predicatesMap);
                } else {
                    this.logger.info("Node {} is not List or Leaf-list.", (Object)node);
                    this.logger.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(identityValue.getValue()));
                    return null;
                }
                result.add(pathArgument);
                if (i >= identities.size() - 1) continue;
                if (node instanceof DataNodeContainer) {
                    parentContainer = (DataNodeContainer)node;
                    continue;
                }
                this.logger.info("Node {} isn't instance of DataNodeContainer", (Object)node);
                this.logger.info("Instance-identifier will be translated as NULL for data - {}", (Object)String.valueOf(identityValue.getValue()));
                return null;
            }
            return result.isEmpty() ? null : new InstanceIdentifier(result);
        }

        private List<IdentityValuesDTO.Predicate> keyValuesToPredicateList(Map<QName, Object> keyValues) {
            ArrayList<IdentityValuesDTO.Predicate> result = new ArrayList<IdentityValuesDTO.Predicate>();
            for (QName qName : keyValues.keySet()) {
                Object value = keyValues.get(qName);
                result.add(new IdentityValuesDTO.Predicate(this.qNameToIdentityValue(qName), String.valueOf(value)));
            }
            return result;
        }

        private IdentityValuesDTO.IdentityValue qNameToIdentityValue(QName qName) {
            if (qName != null) {
                return new IdentityValuesDTO.IdentityValue(qName.getNamespace().toString(), qName.getLocalName(), qName.getPrefix());
            }
            return null;
        }
    }

    public static class LeafrefCodecImpl
    implements LeafrefCodec<String> {
        public String serialize(Object data) {
            return String.valueOf(data);
        }

        public Object deserialize(String data) {
            return data;
        }
    }

    public static class IdentityrefCodecImpl
    implements IdentityrefCodec<IdentityValuesDTO> {
        private final Logger logger = LoggerFactory.getLogger(IdentityrefCodecImpl.class);
        private final MountInstance mountPoint;

        public IdentityrefCodecImpl(MountInstance mountPoint) {
            this.mountPoint = mountPoint;
        }

        public IdentityValuesDTO serialize(QName data) {
            return new IdentityValuesDTO(data.getNamespace().toString(), data.getLocalName(), data.getPrefix());
        }

        public QName deserialize(IdentityValuesDTO data) {
            IdentityValuesDTO.IdentityValue valueWithNamespace = data.getValuesWithNamespaces().get(0);
            Module module = RestCodec.getModuleByNamespace(valueWithNamespace.getNamespace(), this.mountPoint);
            if (module == null) {
                this.logger.info("Module was not found for namespace {}", (Object)valueWithNamespace.getNamespace());
                this.logger.info("Idenetityref will be translated as NULL for data - {}", (Object)String.valueOf(valueWithNamespace));
                return null;
            }
            return QName.create((URI)module.getNamespace(), (Date)module.getRevision(), (String)valueWithNamespace.getValue());
        }
    }

    public static final class ObjectCodec
    implements Codec<Object, Object> {
        private final Logger logger = LoggerFactory.getLogger(RestCodec.class);
        public static final Codec LEAFREF_DEFAULT_CODEC = new LeafrefCodecImpl();
        private final Codec instanceIdentifier;
        private final Codec identityrefCodec;
        private final TypeDefinition<?> type;

        private ObjectCodec(TypeDefinition<?> typeDefinition, MountInstance mountPoint) {
            this.type = RestUtil.resolveBaseTypeFrom(typeDefinition);
            this.identityrefCodec = this.type instanceof IdentityrefTypeDefinition ? new IdentityrefCodecImpl(mountPoint) : null;
            this.instanceIdentifier = this.type instanceof InstanceIdentifierTypeDefinition ? new InstanceIdentifierCodecImpl(mountPoint) : null;
        }

        public Object deserialize(Object input) {
            try {
                if (this.type instanceof IdentityrefTypeDefinition) {
                    if (input instanceof IdentityValuesDTO) {
                        return this.identityrefCodec.deserialize(input);
                    }
                    this.logger.info("Value is not instance of IdentityrefTypeDefinition but is {}. Therefore NULL is used as translation of  - {}", input == null ? "null" : input.getClass(), (Object)String.valueOf(input));
                    return null;
                }
                if (this.type instanceof LeafrefTypeDefinition) {
                    return LEAFREF_DEFAULT_CODEC.deserialize(input);
                }
                if (this.type instanceof InstanceIdentifierTypeDefinition) {
                    if (input instanceof IdentityValuesDTO) {
                        return this.instanceIdentifier.deserialize(input);
                    }
                    this.logger.info("Value is not instance of InstanceIdentifierTypeDefinition but is {}. Therefore NULL is used as translation of  - {}", input == null ? "null" : input.getClass(), (Object)String.valueOf(input));
                    return null;
                }
                TypeDefinitionAwareCodec typeAwarecodec = TypeDefinitionAwareCodec.from(this.type);
                if (typeAwarecodec != null) {
                    return typeAwarecodec.deserialize(String.valueOf(input));
                }
                this.logger.debug("Codec for type \"" + this.type.getQName().getLocalName() + "\" is not implemented yet.");
                return null;
            }
            catch (ClassCastException e) {
                this.logger.error("ClassCastException was thrown when codec is invoked with parameter " + String.valueOf(input), (Throwable)e);
                return null;
            }
        }

        public Object serialize(Object input) {
            try {
                if (this.type instanceof IdentityrefTypeDefinition) {
                    return this.identityrefCodec.serialize(input);
                }
                if (this.type instanceof LeafrefTypeDefinition) {
                    return LEAFREF_DEFAULT_CODEC.serialize(input);
                }
                if (this.type instanceof InstanceIdentifierTypeDefinition) {
                    return this.instanceIdentifier.serialize(input);
                }
                TypeDefinitionAwareCodec typeAwarecodec = TypeDefinitionAwareCodec.from(this.type);
                if (typeAwarecodec != null) {
                    return typeAwarecodec.serialize(input);
                }
                this.logger.debug("Codec for type \"" + this.type.getQName().getLocalName() + "\" is not implemented yet.");
                return null;
            }
            catch (ClassCastException e) {
                this.logger.error("ClassCastException was thrown when codec is invoked with parameter " + String.valueOf(input), (Throwable)e);
                return input;
            }
        }
    }
}

