/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IdentityValuesDTO {
    private final List<IdentityValue> elementData = new ArrayList<IdentityValue>();

    public IdentityValuesDTO(String namespace, String value, String prefix) {
        this.elementData.add(new IdentityValue(namespace, value, prefix));
    }

    public IdentityValuesDTO() {
    }

    public void add(String namespace, String value, String prefix) {
        this.elementData.add(new IdentityValue(namespace, value, prefix));
    }

    public void add(IdentityValue identityValue) {
        this.elementData.add(identityValue);
    }

    public List<IdentityValue> getValuesWithNamespaces() {
        return Collections.unmodifiableList(this.elementData);
    }

    public String toString() {
        return this.elementData.toString();
    }

    public static final class Predicate {
        private final IdentityValue name;
        private final String value;

        public Predicate(IdentityValue name, String value) {
            this.name = name;
            this.value = value;
        }

        public IdentityValue getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append(this.name.toString());
            }
            if (this.value != null) {
                sb.append("=").append(this.value);
            }
            return sb.toString();
        }

        public boolean isLeafList() {
            return this.name == null;
        }
    }

    public static final class IdentityValue {
        private final String namespace;
        private final String value;
        private final String prefix;
        private List<Predicate> predicates;

        public IdentityValue(String namespace, String value, String prefix) {
            this.namespace = namespace;
            this.value = value;
            this.prefix = prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getValue() {
            return this.value;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public List<Predicate> getPredicates() {
            if (this.predicates == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.predicates);
        }

        public void setPredicates(List<Predicate> predicates) {
            this.predicates = predicates;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.namespace != null) {
                sb.append(this.namespace);
            }
            if (this.prefix != null) {
                sb.append("(").append(this.prefix).append(")");
            }
            if (this.value != null) {
                sb.append(" - ").append(this.value);
            }
            if (this.predicates != null && !this.predicates.isEmpty()) {
                for (Predicate predicate : this.predicates) {
                    sb.append("[");
                    predicate.toString();
                    sb.append("]");
                }
            }
            return sb.toString();
        }
    }
}

