/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collections;
import org.opendaylight.controller.sal.restconf.impl.NodeWrapper;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.impl.NodeFactory;

public final class EmptyNodeWrapper
implements NodeWrapper<Node<?>>,
Node<Void> {
    private Node<?> unwrapped;
    private String localName;
    private URI namespace;
    private QName name;
    private boolean composite;

    public boolean isComposite() {
        return this.composite;
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    public EmptyNodeWrapper(URI namespace, String localName) {
        this.localName = (String)Preconditions.checkNotNull((Object)localName);
        this.namespace = namespace;
    }

    @Override
    public void setQname(QName name) {
        Preconditions.checkState((this.unwrapped == null ? 1 : 0) != 0, (Object)"Cannot change the object, due to data inconsistencies.");
        this.name = name;
    }

    @Override
    public QName getQname() {
        return this.name;
    }

    @Override
    public String getLocalName() {
        if (this.unwrapped != null) {
            return this.unwrapped.getNodeType().getLocalName();
        }
        return this.localName;
    }

    @Override
    public URI getNamespace() {
        if (this.unwrapped != null) {
            return this.unwrapped.getNodeType().getNamespace();
        }
        return this.namespace;
    }

    @Override
    public void setNamespace(URI namespace) {
        Preconditions.checkState((this.unwrapped == null ? 1 : 0) != 0, (Object)"Cannot change the object, due to data inconsistencies.");
        this.namespace = namespace;
    }

    @Override
    public boolean isChangeAllowed() {
        return this.unwrapped == null;
    }

    @Override
    public Node<?> unwrap() {
        if (this.unwrapped == null) {
            if (this.name == null) {
                Preconditions.checkNotNull((Object)this.namespace);
                this.name = new QName(this.namespace, this.localName);
            }
            this.unwrapped = this.composite ? NodeFactory.createImmutableCompositeNode((QName)this.name, null, Collections.emptyList(), null) : NodeFactory.createImmutableSimpleNode((QName)this.name, null, null);
            this.namespace = null;
            this.localName = null;
            this.name = null;
        }
        return this.unwrapped;
    }

    public QName getNodeType() {
        return this.unwrap().getNodeType();
    }

    public CompositeNode getParent() {
        return this.unwrap().getParent();
    }

    public Void getValue() {
        return null;
    }

    public QName getKey() {
        return (QName)this.unwrap().getKey();
    }

    public Void setValue(Void value) {
        return null;
    }
}

