/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.impl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.controller.sal.core.api.mount.MountInstance;
import org.opendaylight.controller.sal.core.api.mount.MountService;
import org.opendaylight.controller.sal.rest.impl.RestUtil;
import org.opendaylight.controller.sal.restconf.impl.InstanceIdWithSchemaNode;
import org.opendaylight.controller.sal.restconf.impl.ResponseException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerContext
implements SchemaServiceListener {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        @Override
        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(ControllerContext.class);
            return _logger;
        }
    }.apply();
    private static final ControllerContext INSTANCE = new Functions.Function0<ControllerContext>(){

        @Override
        public ControllerContext apply() {
            ControllerContext _controllerContext = new ControllerContext();
            return _controllerContext;
        }
    }.apply();
    private static final String NULL_VALUE = "null";
    private static final String MOUNT_MODULE = "yang-ext";
    private static final String MOUNT_NODE = "mount";
    public static final String MOUNT = "yang-ext:mount";
    private SchemaContext _globalSchema;
    private MountService _mountService;
    private final BiMap<URI, String> uriToModuleName = new Functions.Function0<BiMap<URI, String>>(){

        @Override
        public BiMap<URI, String> apply() {
            HashBiMap _create = HashBiMap.create();
            return _create;
        }
    }.apply();
    private final Map<String, URI> moduleNameToUri = new Functions.Function0<Map<String, URI>>(){

        @Override
        public Map<String, URI> apply() {
            BiMap _inverse = ControllerContext.this.uriToModuleName.inverse();
            return _inverse;
        }
    }.apply();
    private final Map<QName, RpcDefinition> qnameToRpc = new Functions.Function0<Map<QName, RpcDefinition>>(){

        @Override
        public Map<QName, RpcDefinition> apply() {
            ConcurrentHashMap<QName, RpcDefinition> _concurrentHashMap = new ConcurrentHashMap<QName, RpcDefinition>();
            return _concurrentHashMap;
        }
    }.apply();

    public SchemaContext getGlobalSchema() {
        return this._globalSchema;
    }

    public void setGlobalSchema(SchemaContext globalSchema) {
        this._globalSchema = globalSchema;
    }

    public MountService getMountService() {
        return this._mountService;
    }

    public void setMountService(MountService mountService) {
        this._mountService = mountService;
    }

    private ControllerContext() {
        boolean _tripleNotEquals;
        boolean bl = _tripleNotEquals = INSTANCE != null;
        if (_tripleNotEquals) {
            IllegalStateException _illegalStateException = new IllegalStateException("Already instantiated");
            throw _illegalStateException;
        }
    }

    public static ControllerContext getInstance() {
        return INSTANCE;
    }

    private void checkPreconditions() {
        boolean _tripleEquals;
        SchemaContext _globalSchema = this.getGlobalSchema();
        boolean bl = _tripleEquals = _globalSchema == null;
        if (_tripleEquals) {
            ResponseException _responseException = new ResponseException(Response.Status.SERVICE_UNAVAILABLE, "Restconf is not initialized yet. Please try again later");
            throw _responseException;
        }
    }

    public void setSchemas(SchemaContext schemas) {
        this.onGlobalContextUpdated(schemas);
    }

    public InstanceIdWithSchemaNode toInstanceIdentifier(String restconfInstance) {
        boolean _tripleEquals_1;
        String _head_1;
        String startModule;
        boolean _tripleEquals;
        this.checkPreconditions();
        String[] pathArgs = restconfInstance.split("/");
        boolean _isEmpty = ((List)Conversions.doWrapArray(pathArgs)).isEmpty();
        if (_isEmpty) {
            return null;
        }
        String _head = (String)IterableExtensions.head((Iterable)Conversions.doWrapArray(pathArgs));
        boolean _isEmpty_1 = _head.isEmpty();
        if (_isEmpty_1) {
            ((List)Conversions.doWrapArray(pathArgs)).remove(0);
        }
        boolean bl = _tripleEquals = (startModule = ControllerContext.toModuleName(_head_1 = (String)IterableExtensions.head((Iterable)Conversions.doWrapArray(pathArgs)))) == null;
        if (_tripleEquals) {
            ResponseException _responseException = new ResponseException(Response.Status.BAD_REQUEST, "First node in URI has to be in format \"moduleName:nodeName\"");
            throw _responseException;
        }
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder();
        SchemaContext _globalSchema = this.getGlobalSchema();
        Module _latestModule = this.getLatestModule(_globalSchema, startModule);
        InstanceIdWithSchemaNode iiWithSchemaNode = this.collectPathArguments(_builder, (List)Conversions.doWrapArray(pathArgs), (DataNodeContainer)_latestModule, null);
        boolean bl2 = _tripleEquals_1 = iiWithSchemaNode == null;
        if (_tripleEquals_1) {
            ResponseException _responseException_1 = new ResponseException(Response.Status.BAD_REQUEST, "URI has bad format");
            throw _responseException_1;
        }
        return iiWithSchemaNode;
    }

    private Module getLatestModule(SchemaContext schema, final String moduleName) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals = schema != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals);
        boolean _and = false;
        boolean bl = _tripleNotEquals_1 = moduleName != null;
        if (!_tripleNotEquals_1) {
            _and = false;
        } else {
            boolean _isEmpty = moduleName.isEmpty();
            boolean _not = !_isEmpty;
            _and = _tripleNotEquals_1 && _not;
        }
        Preconditions.checkArgument((boolean)_and);
        Set _modules = schema.getModules();
        Functions.Function1<Module, Boolean> _function = new Functions.Function1<Module, Boolean>(){

            @Override
            public Boolean apply(Module m) {
                String _name = m.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)moduleName);
                return _equals;
            }
        };
        Iterable<Module> modules = IterableExtensions.filter(_modules, _function);
        return this.filterLatestModule(modules);
    }

    private Module filterLatestModule(Iterable<Module> modules) {
        Module latestModule = IterableExtensions.head(modules);
        for (Module module : modules) {
            Date _revision_1;
            Date _revision = module.getRevision();
            boolean _after = _revision.after(_revision_1 = latestModule.getRevision());
            if (!_after) continue;
            latestModule = module;
        }
        return latestModule;
    }

    public Module findModuleByName(String moduleName) {
        boolean _tripleNotEquals;
        this.checkPreconditions();
        boolean _and = false;
        boolean bl = _tripleNotEquals = moduleName != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _isEmpty = moduleName.isEmpty();
            boolean _not = !_isEmpty;
            _and = _tripleNotEquals && _not;
        }
        Preconditions.checkArgument((boolean)_and);
        SchemaContext _globalSchema = this.getGlobalSchema();
        return this.getLatestModule(_globalSchema, moduleName);
    }

    public Module findModuleByName(MountInstance mountPoint, String moduleName) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean bl = _tripleNotEquals = moduleName != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1 = mountPoint != null;
            _and = _tripleNotEquals && _tripleNotEquals_1;
        }
        Preconditions.checkArgument((boolean)_and);
        SchemaContext mountPointSchema = mountPoint.getSchemaContext();
        Module _latestModule = null;
        if (mountPointSchema != null) {
            _latestModule = this.getLatestModule(mountPointSchema, moduleName);
        }
        return _latestModule;
    }

    public Module findModuleByNamespace(URI namespace) {
        this.checkPreconditions();
        boolean _tripleNotEquals = namespace != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals);
        SchemaContext _globalSchema = this.getGlobalSchema();
        Set moduleSchemas = _globalSchema.findModuleByNamespace(namespace);
        Module _filterLatestModule = null;
        if (moduleSchemas != null) {
            _filterLatestModule = this.filterLatestModule(moduleSchemas);
        }
        return _filterLatestModule;
    }

    public Module findModuleByNamespace(MountInstance mountPoint, URI namespace) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean bl = _tripleNotEquals = namespace != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1 = mountPoint != null;
            _and = _tripleNotEquals && _tripleNotEquals_1;
        }
        Preconditions.checkArgument((boolean)_and);
        SchemaContext mountPointSchema = mountPoint.getSchemaContext();
        Set _findModuleByNamespace = null;
        if (mountPointSchema != null) {
            _findModuleByNamespace = mountPointSchema.findModuleByNamespace(namespace);
        }
        Set moduleSchemas = _findModuleByNamespace;
        Module _filterLatestModule = null;
        if (moduleSchemas != null) {
            _filterLatestModule = this.filterLatestModule(moduleSchemas);
        }
        return _filterLatestModule;
    }

    public String toFullRestconfIdentifier(InstanceIdentifier path) {
        StringBuilder _stringBuilder;
        this.checkPreconditions();
        List elements = path.getPath();
        StringBuilder ret = _stringBuilder = new StringBuilder();
        InstanceIdentifier.PathArgument _get = (InstanceIdentifier.PathArgument)elements.get(0);
        QName startQName = _get.getNodeType();
        SchemaContext _globalSchema = this.getGlobalSchema();
        URI _namespace = startQName.getNamespace();
        Date _revision = startQName.getRevision();
        Module initialModule = _globalSchema.findModuleByNamespaceAndRevision(_namespace, _revision);
        DataSchemaNode node = (DataSchemaNode)initialModule;
        for (InstanceIdentifier.PathArgument element : elements) {
            DataSchemaNode _childByQName;
            QName _nodeType = element.getNodeType();
            node = _childByQName = ControllerContext.childByQName(node, _nodeType);
            CharSequence _restconfIdentifier = this.toRestconfIdentifier(element, node);
            ret.append(_restconfIdentifier);
        }
        return ret.toString();
    }

    private CharSequence _toRestconfIdentifier(InstanceIdentifier.NodeIdentifier argument, DataSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/");
        QName _nodeType = argument.getNodeType();
        CharSequence _restconfIdentifier = this.toRestconfIdentifier(_nodeType);
        _builder.append((Object)_restconfIdentifier, "");
        return _builder;
    }

    private CharSequence _toRestconfIdentifier(InstanceIdentifier.NodeIdentifierWithPredicates argument, ListSchemaNode node) {
        QName _nodeType = argument.getNodeType();
        CharSequence nodeIdentifier = this.toRestconfIdentifier(_nodeType);
        Map keyValues = argument.getKeyValues();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/");
        _builder.append((Object)nodeIdentifier, "");
        _builder.append("/");
        List _keyDefinition = node.getKeyDefinition();
        boolean _hasElements = false;
        for (QName key : _keyDefinition) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate("/", "");
            }
            Object _get = keyValues.get(key);
            String _uriString = this.toUriString(_get);
            _builder.append((Object)_uriString, "");
        }
        return _builder;
    }

    private CharSequence _toRestconfIdentifier(InstanceIdentifier.PathArgument argument, DataSchemaNode node) {
        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Conversion of generic path argument is not supported");
        throw _illegalArgumentException;
    }

    public String findModuleNameByNamespace(URI namespace) {
        boolean _tripleEquals;
        this.checkPreconditions();
        String moduleName = (String)this.uriToModuleName.get((Object)namespace);
        boolean bl = _tripleEquals = moduleName == null;
        if (_tripleEquals) {
            String _name;
            boolean _tripleEquals_1;
            Module module = this.findModuleByNamespace(namespace);
            boolean bl2 = _tripleEquals_1 = module == null;
            if (_tripleEquals_1) {
                return null;
            }
            moduleName = _name = module.getName();
            this.uriToModuleName.put((Object)namespace, (Object)moduleName);
        }
        return moduleName;
    }

    public String findModuleNameByNamespace(MountInstance mountPoint, URI namespace) {
        Module module = this.findModuleByNamespace(mountPoint, namespace);
        String _name = null;
        if (module != null) {
            _name = module.getName();
        }
        return _name;
    }

    public URI findNamespaceByModuleName(String moduleName) {
        boolean _tripleEquals;
        URI namespace = this.moduleNameToUri.get(moduleName);
        boolean bl = _tripleEquals = namespace == null;
        if (_tripleEquals) {
            URI _namespace;
            boolean _tripleEquals_1;
            Module module = this.findModuleByName(moduleName);
            boolean bl2 = _tripleEquals_1 = module == null;
            if (_tripleEquals_1) {
                return null;
            }
            namespace = _namespace = module.getNamespace();
            this.uriToModuleName.put((Object)namespace, (Object)moduleName);
        }
        return namespace;
    }

    public URI findNamespaceByModuleName(MountInstance mountPoint, String moduleName) {
        Module module = this.findModuleByName(mountPoint, moduleName);
        URI _namespace = null;
        if (module != null) {
            _namespace = module.getNamespace();
        }
        return _namespace;
    }

    public CharSequence toRestconfIdentifier(QName qname) {
        boolean _tripleEquals;
        this.checkPreconditions();
        URI _namespace = qname.getNamespace();
        String module = (String)this.uriToModuleName.get((Object)_namespace);
        boolean bl = _tripleEquals = module == null;
        if (_tripleEquals) {
            String _name_1;
            boolean _tripleEquals_1;
            Date _revision;
            URI _namespace_1;
            SchemaContext _globalSchema = this.getGlobalSchema();
            Module moduleSchema = _globalSchema.findModuleByNamespaceAndRevision(_namespace_1 = qname.getNamespace(), _revision = qname.getRevision());
            boolean bl2 = _tripleEquals_1 = moduleSchema == null;
            if (_tripleEquals_1) {
                IllegalArgumentException _illegalArgumentException = new IllegalArgumentException();
                throw _illegalArgumentException;
            }
            URI _namespace_2 = qname.getNamespace();
            String _name = moduleSchema.getName();
            this.uriToModuleName.put((Object)_namespace_2, (Object)_name);
            module = _name_1 = moduleSchema.getName();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)module, "");
        _builder.append(":");
        String _localName = qname.getLocalName();
        _builder.append((Object)_localName, "");
        return _builder;
    }

    private static DataSchemaNode _childByQName(ChoiceNode container, QName name) {
        Set _cases = container.getCases();
        for (ChoiceCaseNode caze : _cases) {
            DataSchemaNode ret = ControllerContext.childByQName((DataSchemaNode)caze, name);
            boolean _tripleNotEquals = ret != null;
            if (!_tripleNotEquals) continue;
            return ret;
        }
        return null;
    }

    private static DataSchemaNode _childByQName(ChoiceCaseNode container, QName name) {
        DataSchemaNode ret = container.getDataChildByName(name);
        return ret;
    }

    private static DataSchemaNode _childByQName(ContainerSchemaNode container, QName name) {
        return ControllerContext.dataNodeChildByQName((DataNodeContainer)container, name);
    }

    private static DataSchemaNode _childByQName(ListSchemaNode container, QName name) {
        return ControllerContext.dataNodeChildByQName((DataNodeContainer)container, name);
    }

    private static DataSchemaNode _childByQName(DataSchemaNode container, QName name) {
        return null;
    }

    private static DataSchemaNode dataNodeChildByQName(DataNodeContainer container, QName name) {
        boolean _tripleEquals;
        DataSchemaNode ret = container.getDataChildByName(name);
        boolean bl = _tripleEquals = ret == null;
        if (_tripleEquals) {
            Set _childNodes = container.getChildNodes();
            for (DataSchemaNode node : _childNodes) {
                ChoiceCaseNode caseNode;
                DataSchemaNode _childByQName;
                boolean _tripleNotEquals;
                if (!(node instanceof ChoiceCaseNode) || !(_tripleNotEquals = (ret = (_childByQName = ControllerContext.childByQName((DataSchemaNode)(caseNode = (ChoiceCaseNode)node), name))) != null)) continue;
                return ret;
            }
        }
        return ret;
    }

    private String toUriString(Object object) {
        boolean _tripleEquals;
        boolean bl = _tripleEquals = object == null;
        if (_tripleEquals) {
            return "";
        }
        String _string = object.toString();
        return URLEncoder.encode(_string);
    }

    private InstanceIdWithSchemaNode collectPathArguments(InstanceIdentifier.InstanceIdentifierBuilder builder, List<String> strings, DataNodeContainer parentNode, MountInstance mountPoint) {
        boolean _not_1;
        boolean _not;
        boolean _tripleEquals;
        Preconditions.checkNotNull(strings);
        boolean bl = _tripleEquals = parentNode == null;
        if (_tripleEquals) {
            return null;
        }
        boolean _isEmpty = strings.isEmpty();
        if (_isEmpty) {
            InstanceIdentifier _instance = (InstanceIdentifier)builder.toInstance();
            InstanceIdWithSchemaNode _instanceIdWithSchemaNode = new InstanceIdWithSchemaNode(_instance, (DataSchemaNode)parentNode, mountPoint);
            return _instanceIdWithSchemaNode;
        }
        String _head = IterableExtensions.head(strings);
        String nodeName = this.toNodeName(_head);
        String _head_1 = IterableExtensions.head(strings);
        String moduleName = ControllerContext.toModuleName(_head_1);
        DataSchemaNode targetNode = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(moduleName);
        boolean bl2 = _not = !_isNullOrEmpty;
        if (_not) {
            URI _namespace;
            DataSchemaNode _findInstanceDataChildByNameAndNamespace;
            boolean _tripleEquals_9;
            boolean _tripleEquals_6;
            boolean _and = false;
            boolean _equals = Objects.equal((Object)moduleName, (Object)MOUNT_MODULE);
            if (!_equals) {
                _and = false;
            } else {
                boolean _equals_1 = Objects.equal((Object)nodeName, (Object)MOUNT_NODE);
                boolean bl3 = _and = _equals && _equals_1;
            }
            if (_and) {
                boolean _tripleEquals_5;
                boolean _tripleEquals_4;
                boolean _equals_2;
                boolean _tripleEquals_3;
                boolean _tripleEquals_2;
                boolean _tripleEquals_1;
                boolean _tripleNotEquals;
                boolean bl4 = _tripleNotEquals = mountPoint != null;
                if (_tripleNotEquals) {
                    ResponseException _responseException = new ResponseException(Response.Status.BAD_REQUEST, "Restconf supports just one mount point in URI.");
                    throw _responseException;
                }
                MountService _mountService = this.getMountService();
                boolean bl5 = _tripleEquals_1 = _mountService == null;
                if (_tripleEquals_1) {
                    String _plus = "MountService was not found. Finding behind mount points does not work.";
                    ResponseException _responseException_1 = new ResponseException(Response.Status.SERVICE_UNAVAILABLE, _plus);
                    throw _responseException_1;
                }
                InstanceIdentifier partialPath = (InstanceIdentifier)builder.toInstance();
                MountService _mountService_1 = this.getMountService();
                MountInstance mount = _mountService_1.getMountPoint(partialPath);
                boolean bl6 = _tripleEquals_2 = mount == null;
                if (_tripleEquals_2) {
                    LOG.debug("Instance identifier to missing mount point: {}", (Object)partialPath);
                    ResponseException _responseException_2 = new ResponseException(Response.Status.BAD_REQUEST, "Mount point does not exist.");
                    throw _responseException_2;
                }
                SchemaContext mountPointSchema = mount.getSchemaContext();
                boolean bl7 = _tripleEquals_3 = mountPointSchema == null;
                if (_tripleEquals_3) {
                    ResponseException _responseException_3 = new ResponseException(Response.Status.BAD_REQUEST, "Mount point does not contain any schema with modules.");
                    throw _responseException_3;
                }
                int _size = strings.size();
                boolean bl8 = _equals_2 = _size == 1;
                if (_equals_2) {
                    InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder();
                    InstanceIdentifier _instance_1 = (InstanceIdentifier)_builder.toInstance();
                    InstanceIdWithSchemaNode _instanceIdWithSchemaNode_1 = new InstanceIdWithSchemaNode(_instance_1, (DataSchemaNode)mountPointSchema, mount);
                    return _instanceIdWithSchemaNode_1;
                }
                String _get = strings.get(1);
                String moduleNameBehindMountPoint = ControllerContext.toModuleName(_get);
                boolean bl9 = _tripleEquals_4 = moduleNameBehindMountPoint == null;
                if (_tripleEquals_4) {
                    ResponseException _responseException_4 = new ResponseException(Response.Status.BAD_REQUEST, "First node after mount point in URI has to be in format \"moduleName:nodeName\"");
                    throw _responseException_4;
                }
                Module moduleBehindMountPoint = this.getLatestModule(mountPointSchema, moduleNameBehindMountPoint);
                boolean bl10 = _tripleEquals_5 = moduleBehindMountPoint == null;
                if (_tripleEquals_5) {
                    String _plus_1 = "URI has bad format. \"" + moduleName;
                    String _plus_2 = _plus_1 + "\" module does not exist in mount point.";
                    ResponseException _responseException_5 = new ResponseException(Response.Status.BAD_REQUEST, _plus_2);
                    throw _responseException_5;
                }
                InstanceIdentifier.InstanceIdentifierBuilder _builder_1 = InstanceIdentifier.builder();
                int _size_1 = strings.size();
                List<String> _subList = strings.subList(1, _size_1);
                return this.collectPathArguments(_builder_1, _subList, (DataNodeContainer)moduleBehindMountPoint, mount);
            }
            Module module = null;
            boolean bl11 = _tripleEquals_6 = mountPoint == null;
            if (_tripleEquals_6) {
                boolean _tripleEquals_7;
                SchemaContext _globalSchema = this.getGlobalSchema();
                Module _latestModule = this.getLatestModule(_globalSchema, moduleName);
                module = _latestModule;
                boolean bl12 = _tripleEquals_7 = module == null;
                if (_tripleEquals_7) {
                    String _plus_3 = "URI has bad format. \"" + moduleName;
                    String _plus_4 = _plus_3 + "\" module does not exist.";
                    ResponseException _responseException_6 = new ResponseException(Response.Status.BAD_REQUEST, _plus_4);
                    throw _responseException_6;
                }
            } else {
                boolean _tripleEquals_8;
                Module _latestModule_1 = null;
                SchemaContext _schemaContext = mountPoint.getSchemaContext();
                if (_schemaContext != null) {
                    _latestModule_1 = this.getLatestModule(_schemaContext, moduleName);
                }
                boolean bl13 = _tripleEquals_8 = (module = _latestModule_1) == null;
                if (_tripleEquals_8) {
                    String _plus_5 = "URI has bad format. \"" + moduleName;
                    String _plus_6 = _plus_5 + "\" module does not exist in mount point.";
                    ResponseException _responseException_7 = new ResponseException(Response.Status.BAD_REQUEST, _plus_6);
                    throw _responseException_7;
                }
            }
            boolean bl14 = _tripleEquals_9 = (targetNode = (_findInstanceDataChildByNameAndNamespace = this.findInstanceDataChildByNameAndNamespace(parentNode, nodeName, _namespace = module.getNamespace()))) == null;
            if (_tripleEquals_9) {
                String _plus_7 = "URI has bad format. Possible reasons:\n1. \"";
                String _head_2 = IterableExtensions.head(strings);
                String _plus_8 = _plus_7 + _head_2;
                String _plus_9 = _plus_8 + "\" was not found in parent data node.\n";
                String _plus_10 = _plus_9 + "2. \"";
                String _head_3 = IterableExtensions.head(strings);
                String _plus_11 = _plus_10 + _head_3;
                String _plus_12 = _plus_11 + "\" is behind mount point. Then it should be in format \"/";
                String _plus_13 = _plus_12 + MOUNT;
                String _plus_14 = _plus_13 + "/";
                String _head_4 = IterableExtensions.head(strings);
                String _plus_15 = _plus_14 + _head_4;
                String _plus_16 = _plus_15 + "\".";
                ResponseException _responseException_8 = new ResponseException(Response.Status.BAD_REQUEST, _plus_16);
                throw _responseException_8;
            }
        } else {
            boolean _tripleEquals_10;
            boolean _greaterThan;
            List<DataSchemaNode> potentialSchemaNodes = this.findInstanceDataChildrenByName(parentNode, nodeName);
            int _size_2 = potentialSchemaNodes.size();
            boolean bl15 = _greaterThan = _size_2 > 1;
            if (_greaterThan) {
                StringBuilder _stringBuilder;
                StringBuilder namespacesOfPotentialModules = _stringBuilder = new StringBuilder();
                for (DataSchemaNode potentialNodeSchema : potentialSchemaNodes) {
                    StringBuilder _append = namespacesOfPotentialModules.append("   ");
                    QName _qName = potentialNodeSchema.getQName();
                    URI _namespace_1 = _qName.getNamespace();
                    String _string = _namespace_1.toString();
                    StringBuilder _append_1 = _append.append(_string);
                    _append_1.append("\n");
                }
                String _plus_17 = "URI has bad format. Node \"" + nodeName;
                String _plus_18 = _plus_17 + "\" is added as augment from more than one module. ";
                String _plus_19 = _plus_18 + "Therefore the node must have module name and it has to be in format \"moduleName:nodeName\".";
                String _plus_20 = _plus_19 + "\nThe node is added as augment from modules with namespaces:\n";
                String _plus_21 = _plus_20 + namespacesOfPotentialModules;
                ResponseException _responseException_9 = new ResponseException(Response.Status.BAD_REQUEST, _plus_21);
                throw _responseException_9;
            }
            DataSchemaNode _head_5 = IterableExtensions.head(potentialSchemaNodes);
            targetNode = _head_5;
            boolean bl16 = _tripleEquals_10 = targetNode == null;
            if (_tripleEquals_10) {
                String _plus_22 = "URI has bad format. \"" + nodeName;
                String _plus_23 = _plus_22 + "\" was not found in parent data node.\n";
                ResponseException _responseException_10 = new ResponseException(Response.Status.BAD_REQUEST, _plus_23);
                throw _responseException_10;
            }
        }
        boolean _and_1 = false;
        boolean bl17 = _not_1 = !(targetNode instanceof ListSchemaNode);
        if (!_not_1) {
            _and_1 = false;
        } else {
            boolean _not_2 = !(targetNode instanceof ContainerSchemaNode);
            boolean bl18 = _and_1 = _not_1 && _not_2;
        }
        if (_and_1) {
            String _head_6 = IterableExtensions.head(strings);
            String _plus_24 = "URI has bad format. Node \"" + _head_6;
            String _plus_25 = _plus_24 + "\" must be Container or List yang type.";
            ResponseException _responseException_11 = new ResponseException(Response.Status.BAD_REQUEST, _plus_25);
            throw _responseException_11;
        }
        int consumed = 1;
        if (targetNode instanceof ListSchemaNode) {
            int _plus_29;
            HashMap<QName, Object> _hashMap;
            boolean _lessThan;
            ListSchemaNode listNode = (ListSchemaNode)targetNode;
            List _keyDefinition = listNode.getKeyDefinition();
            int keysSize = _keyDefinition.size();
            int _length = ((Object[])Conversions.unwrapArray(strings, Object.class)).length;
            int _minus = _length - consumed;
            boolean bl19 = _lessThan = _minus < keysSize;
            if (_lessThan) {
                QName _qName_1 = listNode.getQName();
                String _localName = _qName_1.getLocalName();
                String _plus_26 = "Missing key for list \"" + _localName;
                String _plus_27 = _plus_26 + "\".";
                ResponseException _responseException_12 = new ResponseException(Response.Status.BAD_REQUEST, _plus_27);
                throw _responseException_12;
            }
            int _plus_28 = consumed + keysSize;
            List<String> uriKeyValues = strings.subList(consumed, _plus_28);
            HashMap<QName, Object> keyValues = _hashMap = new HashMap<QName, Object>();
            int i = 0;
            List _keyDefinition_1 = listNode.getKeyDefinition();
            for (QName key : _keyDefinition_1) {
                int _plus_31;
                String uriKeyValue = uriKeyValues.get(i);
                boolean _equals_3 = uriKeyValue.equals(NULL_VALUE);
                if (_equals_3) {
                    QName _qName_2 = listNode.getQName();
                    String _localName_1 = _qName_2.getLocalName();
                    String _plus_292 = "URI has bad format. List \"" + _localName_1;
                    String _plus_30 = _plus_292 + "\" cannot contain \"null\" value as a key.";
                    ResponseException _responseException_13 = new ResponseException(Response.Status.BAD_REQUEST, _plus_30);
                    throw _responseException_13;
                }
                DataSchemaNode _dataChildByName = listNode.getDataChildByName(key);
                this.addKeyValue(keyValues, _dataChildByName, uriKeyValue);
                i = _plus_31 = i + 1;
            }
            consumed = _plus_29 = consumed + i;
            QName _qName_2 = targetNode.getQName();
            builder.nodeWithKey(_qName_2, keyValues);
        } else {
            QName _qName_3 = targetNode.getQName();
            builder.node(_qName_3);
        }
        if (targetNode instanceof DataNodeContainer) {
            int _length_1 = ((Object[])Conversions.unwrapArray(strings, Object.class)).length;
            List<String> remaining = strings.subList(consumed, _length_1);
            InstanceIdWithSchemaNode result = this.collectPathArguments(builder, remaining, (DataNodeContainer)targetNode, mountPoint);
            return result;
        }
        InstanceIdentifier _instance_2 = (InstanceIdentifier)builder.toInstance();
        InstanceIdWithSchemaNode _instanceIdWithSchemaNode_2 = new InstanceIdWithSchemaNode(_instance_2, targetNode, mountPoint);
        return _instanceIdWithSchemaNode_2;
    }

    public DataSchemaNode findInstanceDataChildByNameAndNamespace(DataNodeContainer container, String name, final URI namespace) {
        Preconditions.checkNotNull((Object)namespace);
        List<DataSchemaNode> potentialSchemaNodes = this.findInstanceDataChildrenByName(container, name);
        Functions.Function1<DataSchemaNode, Boolean> _function = new Functions.Function1<DataSchemaNode, Boolean>(){

            @Override
            public Boolean apply(DataSchemaNode n) {
                QName _qName = n.getQName();
                URI _namespace = _qName.getNamespace();
                boolean _equals = Objects.equal((Object)_namespace, (Object)namespace);
                return _equals;
            }
        };
        Iterable<DataSchemaNode> _filter = IterableExtensions.filter(potentialSchemaNodes, _function);
        return IterableExtensions.head(_filter);
    }

    public List<DataSchemaNode> findInstanceDataChildrenByName(DataNodeContainer container, String name) {
        ArrayList<DataSchemaNode> _arrayList;
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)name);
        ArrayList<DataSchemaNode> instantiatedDataNodeContainers = _arrayList = new ArrayList<DataSchemaNode>();
        this.collectInstanceDataNodeContainers(instantiatedDataNodeContainers, container, name);
        return instantiatedDataNodeContainers;
    }

    private void collectInstanceDataNodeContainers(List<DataSchemaNode> potentialSchemaNodes, DataNodeContainer container, final String name) {
        Set _childNodes = container.getChildNodes();
        Functions.Function1<DataSchemaNode, Boolean> _function = new Functions.Function1<DataSchemaNode, Boolean>(){

            @Override
            public Boolean apply(DataSchemaNode n) {
                QName _qName = n.getQName();
                String _localName = _qName.getLocalName();
                boolean _equals = Objects.equal((Object)_localName, (Object)name);
                return _equals;
            }
        };
        Iterable<DataSchemaNode> nodes = IterableExtensions.filter(_childNodes, _function);
        for (DataSchemaNode potentialNode : nodes) {
            boolean _isInstantiatedDataSchema = this.isInstantiatedDataSchema(potentialNode);
            if (!_isInstantiatedDataSchema) continue;
            potentialSchemaNodes.add(potentialNode);
        }
        Set _childNodes_1 = container.getChildNodes();
        Iterable _filter = Iterables.filter((Iterable)_childNodes_1, ChoiceNode.class);
        Functions.Function1<ChoiceNode, Set<ChoiceCaseNode>> _function_1 = new Functions.Function1<ChoiceNode, Set<ChoiceCaseNode>>(){

            @Override
            public Set<ChoiceCaseNode> apply(ChoiceNode it) {
                Set _cases = it.getCases();
                return _cases;
            }
        };
        Iterable<Set<ChoiceCaseNode>> _map = IterableExtensions.map(_filter, _function_1);
        Iterable allCases = Iterables.concat(_map);
        for (ChoiceCaseNode caze : allCases) {
            this.collectInstanceDataNodeContainers(potentialSchemaNodes, (DataNodeContainer)caze, name);
        }
    }

    public boolean isInstantiatedDataSchema(DataSchemaNode node) {
        boolean _matched = false;
        if (!_matched && node instanceof LeafSchemaNode) {
            LeafSchemaNode _leafSchemaNode = (LeafSchemaNode)node;
            _matched = true;
            return true;
        }
        if (!_matched && node instanceof LeafListSchemaNode) {
            LeafListSchemaNode _leafListSchemaNode = (LeafListSchemaNode)node;
            _matched = true;
            return true;
        }
        if (!_matched && node instanceof ContainerSchemaNode) {
            ContainerSchemaNode _containerSchemaNode = (ContainerSchemaNode)node;
            _matched = true;
            return true;
        }
        if (!_matched && node instanceof ListSchemaNode) {
            ListSchemaNode _listSchemaNode = (ListSchemaNode)node;
            _matched = true;
            return true;
        }
        return false;
    }

    private void addKeyValue(HashMap<QName, Object> map, DataSchemaNode node, String uriValue) {
        TypeDefinition<?> baseType;
        Object decoded;
        boolean _tripleEquals;
        Preconditions.checkNotNull((Object)uriValue);
        Preconditions.checkArgument((boolean)(node instanceof LeafSchemaNode));
        String urlDecoded = URLDecoder.decode(uriValue);
        TypeDefinition typedef = ((LeafSchemaNode)node).getType();
        TypeDefinitionAwareCodec _from = TypeDefinitionAwareCodec.from((TypeDefinition)typedef);
        Object _deserialize = null;
        if (_from != null) {
            _deserialize = _from.deserialize(urlDecoded);
        }
        boolean bl = _tripleEquals = (decoded = _deserialize) == null;
        if (_tripleEquals && (baseType = RestUtil.resolveBaseTypeFrom(typedef)) instanceof IdentityrefTypeDefinition) {
            QName _qName = this.toQName(urlDecoded);
            decoded = _qName;
        }
        QName _qName_1 = node.getQName();
        map.put(_qName_1, decoded);
    }

    private static String toModuleName(String str) {
        Preconditions.checkNotNull((Object)str);
        boolean _contains = str.contains(":");
        if (_contains) {
            boolean _tripleEquals;
            String[] args = str.split(":");
            int _size = ((List)Conversions.doWrapArray(args)).size();
            boolean bl = _tripleEquals = _size == 2;
            if (_tripleEquals) {
                return args[0];
            }
        }
        return null;
    }

    private String toNodeName(String str) {
        boolean _contains = str.contains(":");
        if (_contains) {
            boolean _tripleEquals;
            String[] args = str.split(":");
            int _size = ((List)Conversions.doWrapArray(args)).size();
            boolean bl = _tripleEquals = _size == 2;
            if (_tripleEquals) {
                return args[1];
            }
        }
        return str;
    }

    private QName toQName(String name) {
        final String module = ControllerContext.toModuleName(name);
        String node = this.toNodeName(name);
        SchemaContext _globalSchema = this.getGlobalSchema();
        Set _modules = _globalSchema.getModules();
        Comparator<Module> _function = new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                Date _revision = o1.getRevision();
                Date _revision_1 = o2.getRevision();
                int _compareTo = _revision.compareTo(_revision_1);
                return _compareTo;
            }
        };
        List<Module> _sort = IterableExtensions.sort(_modules, _function);
        FluentIterable _from = FluentIterable.from(_sort);
        Function<Module, QName> _function_1 = new Function<Module, QName>(){

            public QName apply(Module it) {
                URI _namespace = it.getNamespace();
                Date _revision = it.getRevision();
                String _name = it.getName();
                QName _create = QName.create((URI)_namespace, (Date)_revision, (String)_name);
                return _create;
            }
        };
        FluentIterable _transform = _from.transform((Function)_function_1);
        Functions.Function1<QName, Boolean> _function_2 = new Functions.Function1<QName, Boolean>(){

            @Override
            public Boolean apply(QName it) {
                String _localName = it.getLocalName();
                boolean _equals = Objects.equal((Object)module, (Object)_localName);
                return _equals;
            }
        };
        QName namespace = IterableExtensions.findFirst(_transform, _function_2);
        return QName.create((QName)namespace, (String)node);
    }

    public RpcDefinition getRpcDefinition(String name) {
        QName _qName = this.toQName(name);
        return this.qnameToRpc.get(_qName);
    }

    public void onGlobalContextUpdated(SchemaContext context) {
        this.setGlobalSchema(context);
        Set _operations = context.getOperations();
        for (RpcDefinition operation : _operations) {
            QName qname = operation.getQName();
            this.qnameToRpc.put(qname, operation);
        }
    }

    private CharSequence toRestconfIdentifier(InstanceIdentifier.PathArgument argument, DataSchemaNode node) {
        if (argument instanceof InstanceIdentifier.NodeIdentifierWithPredicates && node instanceof ListSchemaNode) {
            return this._toRestconfIdentifier((InstanceIdentifier.NodeIdentifierWithPredicates)argument, (ListSchemaNode)node);
        }
        if (argument instanceof InstanceIdentifier.NodeIdentifier && node != null) {
            return this._toRestconfIdentifier((InstanceIdentifier.NodeIdentifier)argument, node);
        }
        if (argument != null && node != null) {
            return this._toRestconfIdentifier(argument, node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(argument, node).toString());
    }

    private static DataSchemaNode childByQName(DataSchemaNode container, QName name) {
        if (container instanceof ChoiceCaseNode) {
            return ControllerContext._childByQName((ChoiceCaseNode)container, name);
        }
        if (container instanceof ChoiceNode) {
            return ControllerContext._childByQName((ChoiceNode)container, name);
        }
        if (container instanceof ContainerSchemaNode) {
            return ControllerContext._childByQName((ContainerSchemaNode)container, name);
        }
        if (container instanceof ListSchemaNode) {
            return ControllerContext._childByQName((ListSchemaNode)container, name);
        }
        if (container != null) {
            return ControllerContext._childByQName(container, name);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(container, name).toString());
    }
}

