/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.sal.restconf.impl.NodeWrapper;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.MutableCompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.NodeFactory;

public final class CompositeNodeWrapper
implements NodeWrapper<CompositeNode>,
CompositeNode {
    private MutableCompositeNode compositeNode;
    private String localName;
    private URI namespace;
    private QName name;
    private List<NodeWrapper<?>> values = new ArrayList();

    public CompositeNodeWrapper(String localName) {
        this.localName = (String)Preconditions.checkNotNull((Object)localName);
    }

    public CompositeNodeWrapper(URI namespace, String localName) {
        this(localName);
        this.namespace = namespace;
    }

    @Override
    public void setQname(QName name) {
        Preconditions.checkState((this.compositeNode == null ? 1 : 0) != 0, (Object)"Cannot change the object, due to data inconsistencies.");
        this.name = name;
    }

    @Override
    public QName getQname() {
        return this.name;
    }

    @Override
    public String getLocalName() {
        if (this.compositeNode != null) {
            return this.compositeNode.getNodeType().getLocalName();
        }
        return this.localName;
    }

    @Override
    public URI getNamespace() {
        if (this.compositeNode != null) {
            return this.compositeNode.getNodeType().getNamespace();
        }
        return this.namespace;
    }

    @Override
    public void setNamespace(URI namespace) {
        Preconditions.checkState((this.compositeNode == null ? 1 : 0) != 0, (Object)"Cannot change the object, due to data inconsistencies.");
        this.namespace = namespace;
    }

    public void addValue(NodeWrapper<?> value) {
        Preconditions.checkState((this.compositeNode == null ? 1 : 0) != 0, (Object)"Cannot change the object, due to data inconsistencies.");
        this.values.add(value);
    }

    public void removeValue(NodeWrapper<CompositeNode> value) {
        Preconditions.checkState((this.compositeNode == null ? 1 : 0) != 0, (Object)"Cannot change the object, due to data inconsistencies.");
        this.values.remove(value);
    }

    public List<NodeWrapper<?>> getValues() {
        Preconditions.checkState((this.compositeNode == null ? 1 : 0) != 0, (Object)"Data can be inconsistent.");
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public boolean isChangeAllowed() {
        return this.compositeNode == null;
    }

    @Override
    public CompositeNode unwrap() {
        if (this.compositeNode == null) {
            if (this.name == null) {
                Preconditions.checkNotNull((Object)this.namespace);
                this.name = new QName(this.namespace, this.localName);
            }
            ArrayList nodeValues = new ArrayList();
            for (NodeWrapper<?> nodeWrapper : this.values) {
                nodeValues.add(nodeWrapper.unwrap());
            }
            this.compositeNode = NodeFactory.createMutableCompositeNode((QName)this.name, null, nodeValues, null, null);
            this.values = null;
            this.namespace = null;
            this.localName = null;
            this.name = null;
        }
        return this.compositeNode;
    }

    public QName getNodeType() {
        return this.unwrap().getNodeType();
    }

    public CompositeNode getParent() {
        return this.unwrap().getParent();
    }

    public List<Node<?>> getValue() {
        return (List)this.unwrap().getValue();
    }

    public ModifyAction getModificationAction() {
        return this.unwrap().getModificationAction();
    }

    public List<Node<?>> getChildren() {
        return this.unwrap().getChildren();
    }

    public List<CompositeNode> getCompositesByName(QName children) {
        return this.unwrap().getCompositesByName(children);
    }

    public List<CompositeNode> getCompositesByName(String children) {
        return this.unwrap().getCompositesByName(children);
    }

    public List<SimpleNode<?>> getSimpleNodesByName(QName children) {
        return this.unwrap().getSimpleNodesByName(children);
    }

    public List<SimpleNode<?>> getSimpleNodesByName(String children) {
        return this.unwrap().getSimpleNodesByName(children);
    }

    public CompositeNode getFirstCompositeByName(QName container) {
        return this.unwrap().getFirstCompositeByName(container);
    }

    public SimpleNode<?> getFirstSimpleByName(QName leaf) {
        return this.unwrap().getFirstSimpleByName(leaf);
    }

    public MutableCompositeNode asMutable() {
        return this.unwrap().asMutable();
    }

    public QName getKey() {
        return (QName)this.unwrap().getKey();
    }

    public List<Node<?>> setValue(List<Node<?>> value) {
        return (List)this.unwrap().setValue(value);
    }

    public int size() {
        return this.unwrap().size();
    }

    public boolean isEmpty() {
        return this.unwrap().isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.unwrap().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.unwrap().containsValue(value);
    }

    public List<Node<?>> get(Object key) {
        return (List)this.unwrap().get(key);
    }

    public List<Node<?>> put(QName key, List<Node<?>> value) {
        return (List)this.unwrap().put((Object)key, value);
    }

    public List<Node<?>> remove(Object key) {
        return (List)this.unwrap().remove(key);
    }

    public void putAll(Map<? extends QName, ? extends List<Node<?>>> m) {
        this.unwrap().putAll(m);
    }

    public void clear() {
        this.unwrap().clear();
    }

    public Set<QName> keySet() {
        return this.unwrap().keySet();
    }

    public Collection<List<Node<?>>> values() {
        return this.unwrap().values();
    }

    public Set<Map.Entry<QName, List<Node<?>>>> entrySet() {
        return this.unwrap().entrySet();
    }
}

