/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.impl;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.data.DataBrokerService;
import org.opendaylight.controller.sal.core.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.core.api.mount.MountInstance;
import org.opendaylight.controller.sal.restconf.impl.ResponseException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerFacade
implements DataReader<InstanceIdentifier, CompositeNode> {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        @Override
        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(BrokerFacade.class);
            return _logger;
        }
    }.apply();
    private static final BrokerFacade INSTANCE = new Functions.Function0<BrokerFacade>(){

        @Override
        public BrokerFacade apply() {
            BrokerFacade _brokerFacade = new BrokerFacade();
            return _brokerFacade;
        }
    }.apply();
    private Broker.ConsumerSession _context;
    private DataBrokerService _dataService;

    public Broker.ConsumerSession getContext() {
        return this._context;
    }

    public void setContext(Broker.ConsumerSession context) {
        this._context = context;
    }

    public DataBrokerService getDataService() {
        return this._dataService;
    }

    public void setDataService(DataBrokerService dataService) {
        this._dataService = dataService;
    }

    private BrokerFacade() {
        boolean _tripleNotEquals;
        boolean bl = _tripleNotEquals = INSTANCE != null;
        if (_tripleNotEquals) {
            IllegalStateException _illegalStateException = new IllegalStateException("Already instantiated");
            throw _illegalStateException;
        }
    }

    public static BrokerFacade getInstance() {
        return INSTANCE;
    }

    private void checkPreconditions() {
        boolean _tripleEquals;
        boolean _or = false;
        Broker.ConsumerSession _context = this.getContext();
        boolean bl = _tripleEquals = _context == null;
        if (_tripleEquals) {
            _or = true;
        } else {
            DataBrokerService _dataService = this.getDataService();
            boolean _tripleEquals_1 = _dataService == null;
            boolean bl2 = _or = _tripleEquals || _tripleEquals_1;
        }
        if (_or) {
            ResponseException _responseException = new ResponseException(Response.Status.SERVICE_UNAVAILABLE, "Restconf is not initialized yet. Please try again later");
            throw _responseException;
        }
    }

    public CompositeNode readConfigurationData(InstanceIdentifier path) {
        this.checkPreconditions();
        LOG.trace("Read Configuration via Restconf: {}", (Object)path);
        DataBrokerService _dataService = this.getDataService();
        return _dataService.readConfigurationData(path);
    }

    public CompositeNode readConfigurationDataBehindMountPoint(MountInstance mountPoint, InstanceIdentifier path) {
        this.checkPreconditions();
        LOG.trace("Read Configuration via Restconf: {}", (Object)path);
        return mountPoint.readConfigurationData(path);
    }

    public CompositeNode readOperationalData(InstanceIdentifier path) {
        this.checkPreconditions();
        LOG.trace("Read Operational via Restconf: {}", (Object)path);
        DataBrokerService _dataService = this.getDataService();
        return _dataService.readOperationalData(path);
    }

    public CompositeNode readOperationalDataBehindMountPoint(MountInstance mountPoint, InstanceIdentifier path) {
        this.checkPreconditions();
        LOG.trace("Read Operational via Restconf: {}", (Object)path);
        return mountPoint.readOperationalData(path);
    }

    public RpcResult<CompositeNode> invokeRpc(QName type, CompositeNode payload) {
        this.checkPreconditions();
        Broker.ConsumerSession _context = this.getContext();
        Future future = _context.rpc(type, payload);
        try {
            return (RpcResult)future.get();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    public Future<RpcResult<TransactionStatus>> commitConfigurationDataPut(InstanceIdentifier path, CompositeNode payload) {
        this.checkPreconditions();
        DataBrokerService _dataService = this.getDataService();
        DataModificationTransaction transaction = _dataService.beginTransaction();
        LOG.trace("Put Configuration via Restconf: {}", (Object)path);
        transaction.putConfigurationData((Object)path, (Object)payload);
        return transaction.commit();
    }

    public Future<RpcResult<TransactionStatus>> commitConfigurationDataPutBehindMountPoint(MountInstance mountPoint, InstanceIdentifier path, CompositeNode payload) {
        this.checkPreconditions();
        DataModificationTransaction transaction = mountPoint.beginTransaction();
        LOG.trace("Put Configuration via Restconf: {}", (Object)path);
        transaction.putConfigurationData((Object)path, (Object)payload);
        return transaction.commit();
    }

    public Future<RpcResult<TransactionStatus>> commitConfigurationDataPost(InstanceIdentifier path, CompositeNode payload) {
        this.checkPreconditions();
        DataBrokerService _dataService = this.getDataService();
        DataModificationTransaction transaction = _dataService.beginTransaction();
        transaction.putConfigurationData((Object)path, (Object)payload);
        Map _createdConfigurationData = transaction.getCreatedConfigurationData();
        CompositeNode _get = (CompositeNode)_createdConfigurationData.get(path);
        boolean _equals = Objects.equal((Object)payload, (Object)_get);
        if (_equals) {
            LOG.trace("Post Configuration via Restconf: {}", (Object)path);
            return transaction.commit();
        }
        LOG.trace("Post Configuration via Restconf was not executed because data already exists: {}", (Object)path);
        return null;
    }

    public Future<RpcResult<TransactionStatus>> commitConfigurationDataPostBehindMountPoint(MountInstance mountPoint, InstanceIdentifier path, CompositeNode payload) {
        this.checkPreconditions();
        DataModificationTransaction transaction = mountPoint.beginTransaction();
        transaction.putConfigurationData((Object)path, (Object)payload);
        Map _createdConfigurationData = transaction.getCreatedConfigurationData();
        CompositeNode _get = (CompositeNode)_createdConfigurationData.get(path);
        boolean _equals = Objects.equal((Object)payload, (Object)_get);
        if (_equals) {
            LOG.trace("Post Configuration via Restconf: {}", (Object)path);
            return transaction.commit();
        }
        LOG.trace("Post Configuration via Restconf was not executed because data already exists: {}", (Object)path);
        return null;
    }

    public Future<RpcResult<TransactionStatus>> commitConfigurationDataDelete(InstanceIdentifier path) {
        this.checkPreconditions();
        DataBrokerService _dataService = this.getDataService();
        DataModificationTransaction transaction = _dataService.beginTransaction();
        LOG.info("Delete Configuration via Restconf: {}", (Object)path);
        transaction.removeConfigurationData((Object)path);
        return transaction.commit();
    }

    public Future<RpcResult<TransactionStatus>> commitConfigurationDataDeleteBehindMountPoint(MountInstance mountPoint, InstanceIdentifier path) {
        this.checkPreconditions();
        DataModificationTransaction transaction = mountPoint.beginTransaction();
        LOG.info("Delete Configuration via Restconf: {}", (Object)path);
        transaction.removeConfigurationData((Object)path);
        return transaction.commit();
    }
}

