/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamException;
import org.opendaylight.controller.sal.rest.impl.UnsupportedFormatException;
import org.opendaylight.controller.sal.rest.impl.XmlReader;
import org.opendaylight.controller.sal.restconf.impl.ResponseException;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;

@Provider
@Consumes(value={"application/vnd.yang.data+xml", "application/yang.data+xml", "application/xml", "text/xml"})
public enum XmlToCompositeNodeProvider implements MessageBodyReader<CompositeNode>
{
    INSTANCE;


    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public CompositeNode readFrom(Class<CompositeNode> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        XmlReader xmlReader = new XmlReader();
        try {
            return xmlReader.read(entityStream);
        }
        catch (XMLStreamException | UnsupportedFormatException e) {
            throw new ResponseException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }
}

