/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.impl;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URI;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.opendaylight.controller.sal.rest.impl.RestUtil;
import org.opendaylight.controller.sal.rest.impl.UnsupportedFormatException;
import org.opendaylight.controller.sal.restconf.impl.CompositeNodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.EmptyNodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.IdentityValuesDTO;
import org.opendaylight.controller.sal.restconf.impl.NodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.SimpleNodeWrapper;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;

public class XmlReader {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private XMLEventReader eventReader;

    public CompositeNodeWrapper read(InputStream entityStream) throws XMLStreamException, UnsupportedFormatException {
        XMLEvent element;
        this.eventReader = xmlInputFactory.createXMLEventReader(entityStream);
        if (this.eventReader.hasNext() && (element = this.eventReader.peek()).isStartDocument()) {
            this.eventReader.nextEvent();
        }
        if (this.eventReader.hasNext() && !this.isCompositeNodeEvent(this.eventReader.peek())) {
            throw new UnsupportedFormatException("Root element of XML has to be composite element.");
        }
        Stack<CompositeNodeWrapper> processingQueue = new Stack<CompositeNodeWrapper>();
        CompositeNodeWrapper root = null;
        NodeWrapper element2 = null;
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                CompositeNodeWrapper compParentNode = null;
                if (!processingQueue.isEmpty() && processingQueue.peek() instanceof CompositeNodeWrapper) {
                    compParentNode = (CompositeNodeWrapper)processingQueue.peek();
                }
                NodeWrapper<CompositeNode> newNode = null;
                if (this.isCompositeNodeEvent(event)) {
                    newNode = root == null ? (root = this.resolveCompositeNodeFromStartElement(startElement)) : this.resolveCompositeNodeFromStartElement(startElement);
                } else if (this.isSimpleNodeEvent(event)) {
                    if (root == null) {
                        throw new UnsupportedFormatException("Root element of XML has to be composite element.");
                    }
                    newNode = this.resolveSimpleNodeFromStartElement(startElement);
                }
                if (newNode == null) continue;
                processingQueue.push((CompositeNodeWrapper)newNode);
                if (compParentNode == null) continue;
                compParentNode.addValue(newNode);
                continue;
            }
            if (!event.isEndElement()) continue;
            element2 = (NodeWrapper)processingQueue.pop();
        }
        if (!root.getLocalName().equals(element2.getLocalName())) {
            throw new UnsupportedFormatException("XML should contain only one root element");
        }
        return root;
    }

    private boolean isSimpleNodeEvent(XMLEvent event) throws XMLStreamException {
        Characters chars;
        XMLEvent innerEvent;
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (Object)"XML Event cannot be NULL!");
        return event.isStartElement() && this.eventReader.hasNext() && ((innerEvent = this.eventReader.peek()).isCharacters() ? !(chars = innerEvent.asCharacters()).isWhiteSpace() : innerEvent.isEndElement());
    }

    private boolean isCompositeNodeEvent(XMLEvent event) throws XMLStreamException {
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (Object)"XML Event cannot be NULL!");
        if (event.isStartElement() && this.eventReader.hasNext()) {
            Characters chars;
            XMLEvent innerEvent = this.eventReader.peek();
            if (innerEvent.isCharacters() && (chars = innerEvent.asCharacters()).isWhiteSpace()) {
                this.eventReader.nextEvent();
                innerEvent = this.eventReader.peek();
            }
            if (innerEvent.isStartElement()) {
                return true;
            }
        }
        return false;
    }

    private CompositeNodeWrapper resolveCompositeNodeFromStartElement(StartElement startElement) {
        Preconditions.checkArgument((startElement != null ? 1 : 0) != 0, (Object)"Start Element cannot be NULL!");
        return new CompositeNodeWrapper(this.getNamespaceFor(startElement), this.getLocalNameFor(startElement));
    }

    private NodeWrapper<? extends Node<?>> resolveSimpleNodeFromStartElement(StartElement startElement) throws XMLStreamException {
        Preconditions.checkArgument((startElement != null ? 1 : 0) != 0, (Object)"Start Element cannot be NULL!");
        String data = this.getValueOf(startElement);
        if (data == null) {
            return new EmptyNodeWrapper(this.getNamespaceFor(startElement), this.getLocalNameFor(startElement));
        }
        return new SimpleNodeWrapper(this.getNamespaceFor(startElement), this.getLocalNameFor(startElement), this.resolveValueOfElement(data, startElement));
    }

    private String getValueOf(StartElement startElement) throws XMLStreamException {
        String data = null;
        if (this.eventReader.hasNext()) {
            XMLEvent innerEvent = this.eventReader.peek();
            if (innerEvent.isCharacters()) {
                Characters chars = innerEvent.asCharacters();
                if (!chars.isWhiteSpace()) {
                    data = innerEvent.asCharacters().getData();
                    data = data + this.getAdditionalData(this.eventReader.nextEvent());
                }
            } else if (innerEvent.isEndElement()) {
                data = startElement.getLocation().getCharacterOffset() == innerEvent.getLocation().getCharacterOffset() ? null : "";
            }
        }
        return data;
    }

    private String getAdditionalData(XMLEvent event) throws XMLStreamException {
        Characters chars;
        XMLEvent innerEvent;
        String data = "";
        if (this.eventReader.hasNext() && (innerEvent = this.eventReader.peek()).isCharacters() && !innerEvent.isEndElement() && !(chars = innerEvent.asCharacters()).isWhiteSpace()) {
            data = innerEvent.asCharacters().getData();
            data = data + this.getAdditionalData(this.eventReader.nextEvent());
        }
        return data;
    }

    private String getLocalNameFor(StartElement startElement) {
        return startElement.getName().getLocalPart();
    }

    private URI getNamespaceFor(StartElement startElement) {
        String namespaceURI = startElement.getName().getNamespaceURI();
        return namespaceURI.isEmpty() ? null : URI.create(namespaceURI);
    }

    private Object resolveValueOfElement(String value, StartElement startElement) {
        String namespace;
        IdentityValuesDTO iiValue;
        if (value.startsWith("/") && (iiValue = RestUtil.asInstanceIdentifier(value, new RestUtil.PrefixMapingFromXml(startElement))) != null) {
            return iiValue;
        }
        String[] namespaceAndValue = value.split(":");
        if (namespaceAndValue.length == 2 && (namespace = startElement.getNamespaceContext().getNamespaceURI(namespaceAndValue[0])) != null && !namespace.isEmpty()) {
            return new IdentityValuesDTO(namespace, namespaceAndValue[1], namespaceAndValue[0]);
        }
        return value;
    }
}

