/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opendaylight.controller.sal.rest.impl.XmlMapper;
import org.opendaylight.controller.sal.restconf.impl.ResponseException;
import org.opendaylight.controller.sal.restconf.impl.StructuredData;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Provider
@Produces(value={"application/vnd.yang.data+xml", "application/yang.data+xml", "application/xml", "text/xml"})
public enum StructuredDataToXmlProvider implements MessageBodyWriter<StructuredData>
{
    INSTANCE;

    private static final Logger logger;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(StructuredData t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(StructuredData t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        CompositeNode data = t.getData();
        if (data == null) {
            throw new ResponseException(Response.Status.NOT_FOUND, "No data exists.");
        }
        XmlMapper xmlMapper = new XmlMapper();
        Document domTree = xmlMapper.write(data, (DataNodeContainer)t.getSchema());
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(domTree), new StreamResult(entityStream));
        }
        catch (TransformerException e) {
            logger.error("Error during translation of Document to OutputStream", (Throwable)e);
            throw new ResponseException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    static {
        logger = LoggerFactory.getLogger(StructuredDataToXmlProvider.class);
    }
}

