/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.impl;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.opendaylight.controller.sal.rest.impl.JsonMapper;
import org.opendaylight.controller.sal.restconf.impl.ResponseException;
import org.opendaylight.controller.sal.restconf.impl.StructuredData;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;

@Provider
@Produces(value={"application/vnd.yang.data+json", "application/yang.data+json", "application/json"})
public enum StructuredDataToJsonProvider implements MessageBodyWriter<StructuredData>
{
    INSTANCE;


    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(StructuredData t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(StructuredData t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        CompositeNode data = t.getData();
        if (data == null) {
            throw new ResponseException(Response.Status.NOT_FOUND, "No data exists.");
        }
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(entityStream, "UTF-8"));
        writer.setIndent("    ");
        JsonMapper jsonMapper = new JsonMapper();
        jsonMapper.write(writer, data, (DataNodeContainer)t.getSchema(), t.getMountPoint());
        writer.flush();
    }
}

