/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.impl;

import java.util.Collection;
import java.util.Collections;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.controller.sal.core.api.data.DataBrokerService;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.core.api.mount.MountService;
import org.opendaylight.controller.sal.restconf.impl.BrokerFacade;
import org.opendaylight.controller.sal.restconf.impl.ControllerContext;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class RestconfProvider
implements BundleActivator,
Provider,
ServiceTrackerCustomizer<Broker, Broker> {
    public static final String NOT_INITALIZED_MSG = "Restconf is not initialized yet. Please try again later";
    private ListenerRegistration<SchemaServiceListener> listenerRegistration;
    private ServiceTracker<Broker, Broker> brokerServiceTrancker;
    private BundleContext bundleContext;
    private Broker.ProviderSession session;

    public void onSessionInitiated(Broker.ProviderSession session) {
        DataBrokerService dataService = (DataBrokerService)session.getService(DataBrokerService.class);
        BrokerFacade.getInstance().setContext((Broker.ConsumerSession)session);
        BrokerFacade.getInstance().setDataService(dataService);
        SchemaService schemaService = (SchemaService)session.getService(SchemaService.class);
        this.listenerRegistration = schemaService.registerSchemaServiceListener((SchemaServiceListener)ControllerContext.getInstance());
        ControllerContext.getInstance().setSchemas(schemaService.getGlobalContext());
        ControllerContext.getInstance().setMountService((MountService)session.getService(MountService.class));
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.brokerServiceTrancker = new ServiceTracker(context, Broker.class, (ServiceTrackerCustomizer)this);
        this.brokerServiceTrancker.open();
    }

    public void stop(BundleContext context) {
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.session.close();
        this.brokerServiceTrancker.close();
    }

    public Collection<Provider.ProviderFunctionality> getProviderFunctionality() {
        return Collections.emptySet();
    }

    public Broker addingService(ServiceReference<Broker> reference) {
        Broker broker = (Broker)this.bundleContext.getService(reference);
        broker.registerProvider((Provider)this, this.bundleContext);
        return broker;
    }

    public void modifiedService(ServiceReference<Broker> reference, Broker service) {
    }

    public void removedService(ServiceReference<Broker> reference, Broker service) {
        this.bundleContext.ungetService(reference);
        BrokerFacade.getInstance().setContext(null);
        BrokerFacade.getInstance().setDataService(null);
        ControllerContext.getInstance().setSchemas(null);
    }
}

