/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.events.StartElement;
import org.opendaylight.controller.sal.restconf.impl.IdentityValuesDTO;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

public final class RestUtil {
    public static final String SQUOTE = "'";
    public static final String DQUOTE = "\"";
    private static final Pattern PREDICATE_PATTERN = Pattern.compile("\\[(.*?)\\]");

    public static final TypeDefinition<?> resolveBaseTypeFrom(TypeDefinition<?> type) {
        TypeDefinition superType = type;
        while (superType.getBaseType() != null) {
            superType = superType.getBaseType();
        }
        return superType;
    }

    public static IdentityValuesDTO asInstanceIdentifier(String value, PrefixesMaping prefixMap) {
        String valueTrimmed = value.trim();
        if (!valueTrimmed.startsWith("/")) {
            return null;
        }
        String[] xPathParts = valueTrimmed.split("/");
        if (xPathParts.length < 2) {
            return null;
        }
        IdentityValuesDTO identityValuesDTO = new IdentityValuesDTO();
        for (int i = 1; i < xPathParts.length; ++i) {
            String xPathPartTrimmed = xPathParts[i].trim();
            String xPathPartStr = RestUtil.getIdAndPrefixAsStr(xPathPartTrimmed);
            IdentityValuesDTO.IdentityValue identityValue = RestUtil.toIdentity(xPathPartStr, prefixMap);
            if (identityValue == null) {
                return null;
            }
            List<IdentityValuesDTO.Predicate> predicates = RestUtil.toPredicates(xPathPartTrimmed, prefixMap);
            if (predicates == null) {
                return null;
            }
            identityValue.setPredicates(predicates);
            identityValuesDTO.add(identityValue);
        }
        return identityValuesDTO.getValuesWithNamespaces().isEmpty() ? null : identityValuesDTO;
    }

    private static String getIdAndPrefixAsStr(String pathPart) {
        int predicateStartIndex = pathPart.indexOf("[");
        return predicateStartIndex == -1 ? pathPart : pathPart.substring(0, predicateStartIndex);
    }

    private static IdentityValuesDTO.IdentityValue toIdentity(String xPathPart, PrefixesMaping prefixMap) {
        String namespace;
        String xPathPartTrimmed = xPathPart.trim();
        if (xPathPartTrimmed.isEmpty()) {
            return null;
        }
        String[] prefixAndIdentifier = xPathPartTrimmed.split(":");
        if (prefixAndIdentifier.length != 2) {
            return null;
        }
        String prefix = prefixAndIdentifier[0].trim();
        String identifier = prefixAndIdentifier[1].trim();
        if (prefix.isEmpty() || identifier.isEmpty()) {
            return null;
        }
        return new IdentityValuesDTO.IdentityValue(namespace, identifier, (namespace = prefixMap.getNamespace(prefix)).equals(prefix) ? null : prefix);
    }

    private static List<IdentityValuesDTO.Predicate> toPredicates(String predicatesStr, PrefixesMaping prefixMap) {
        ArrayList<IdentityValuesDTO.Predicate> result = new ArrayList<IdentityValuesDTO.Predicate>();
        ArrayList<String> predicates = new ArrayList<String>();
        Matcher matcher = PREDICATE_PATTERN.matcher(predicatesStr);
        while (matcher.find()) {
            predicates.add(matcher.group(1).trim());
        }
        for (String predicate : predicates) {
            int indexOfEqualityMark = predicate.indexOf("=");
            if (indexOfEqualityMark == -1) continue;
            String predicateValue = RestUtil.toPredicateValue(predicate.substring(indexOfEqualityMark + 1));
            if (predicate.startsWith(".")) {
                if (predicateValue == null) {
                    return null;
                }
                result.add(new IdentityValuesDTO.Predicate(null, predicateValue));
                continue;
            }
            IdentityValuesDTO.IdentityValue identityValue = RestUtil.toIdentity(predicate.substring(0, indexOfEqualityMark), prefixMap);
            if (identityValue == null || predicateValue == null) {
                return null;
            }
            result.add(new IdentityValuesDTO.Predicate(identityValue, predicateValue));
        }
        return result;
    }

    private static String toPredicateValue(String predicatedValue) {
        String predicatedValueTrimmed = predicatedValue.trim();
        if ((predicatedValueTrimmed.startsWith(DQUOTE) || predicatedValueTrimmed.startsWith(SQUOTE)) && (predicatedValueTrimmed.endsWith(DQUOTE) || predicatedValueTrimmed.endsWith(SQUOTE))) {
            return predicatedValueTrimmed.substring(1, predicatedValueTrimmed.length() - 1);
        }
        return null;
    }

    public static class PrefixMapingFromJson
    implements PrefixesMaping {
        @Override
        public String getNamespace(String prefix) {
            return prefix;
        }
    }

    public static class PrefixMapingFromXml
    implements PrefixesMaping {
        StartElement startElement = null;

        public PrefixMapingFromXml(StartElement startElement) {
            this.startElement = startElement;
        }

        @Override
        public String getNamespace(String prefix) {
            return this.startElement.getNamespaceContext().getNamespaceURI(prefix);
        }
    }

    public static interface PrefixesMaping {
        public String getNamespace(String var1);
    }
}

