/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.impl;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.sal.rest.impl.RestUtil;
import org.opendaylight.controller.sal.rest.impl.UnsupportedFormatException;
import org.opendaylight.controller.sal.restconf.impl.CompositeNodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.EmptyNodeWrapper;
import org.opendaylight.controller.sal.restconf.impl.IdentityValuesDTO;
import org.opendaylight.controller.sal.restconf.impl.SimpleNodeWrapper;

class JsonReader {
    JsonReader() {
    }

    public CompositeNodeWrapper read(InputStream entityStream) throws UnsupportedFormatException {
        JsonParser parser = new JsonParser();
        JsonElement rootElement = parser.parse((Reader)new InputStreamReader(entityStream));
        if (!rootElement.isJsonObject()) {
            throw new UnsupportedFormatException("Root element of Json has to be Object");
        }
        Set entrySetsOfRootJsonObject = rootElement.getAsJsonObject().entrySet();
        if (entrySetsOfRootJsonObject.size() != 1) {
            throw new UnsupportedFormatException("Json Object should contain one element");
        }
        Map.Entry childEntry = (Map.Entry)Lists.newArrayList((Iterable)entrySetsOfRootJsonObject).get(0);
        String firstElementName = (String)childEntry.getKey();
        JsonElement firstElementType = (JsonElement)childEntry.getValue();
        if (firstElementType.isJsonObject()) {
            return this.createStructureWithRoot(firstElementName, firstElementType.getAsJsonObject());
        }
        if (firstElementType.isJsonArray() && firstElementType.getAsJsonArray().size() == 1) {
            JsonElement firstElementInArray = firstElementType.getAsJsonArray().get(0);
            if (firstElementInArray.isJsonObject()) {
                return this.createStructureWithRoot(firstElementName, firstElementInArray.getAsJsonObject());
            }
            throw new UnsupportedFormatException("Array as the first element in Json Object can have only Object element");
        }
        throw new UnsupportedFormatException("First element in Json Object has to be \"Object\" or \"Array with one Object element\". Other scenarios are not supported yet.");
    }

    private CompositeNodeWrapper createStructureWithRoot(String rootObjectName, JsonObject rootObject) {
        CompositeNodeWrapper firstNode = new CompositeNodeWrapper(this.getNamespaceFor(rootObjectName), this.getLocalNameFor(rootObjectName));
        for (Map.Entry childOfFirstNode : rootObject.entrySet()) {
            this.addChildToParent((String)childOfFirstNode.getKey(), (JsonElement)childOfFirstNode.getValue(), firstNode);
        }
        return firstNode;
    }

    private void addChildToParent(String childName, JsonElement childType, CompositeNodeWrapper parent) {
        if (childType.isJsonObject()) {
            CompositeNodeWrapper child = new CompositeNodeWrapper(this.getNamespaceFor(childName), this.getLocalNameFor(childName));
            parent.addValue(child);
            for (Map.Entry childOfChild : childType.getAsJsonObject().entrySet()) {
                this.addChildToParent((String)childOfChild.getKey(), (JsonElement)childOfChild.getValue(), child);
            }
        } else if (childType.isJsonArray()) {
            if (childType.getAsJsonArray().size() == 1 && childType.getAsJsonArray().get(0).isJsonNull()) {
                parent.addValue(new EmptyNodeWrapper(this.getNamespaceFor(childName), this.getLocalNameFor(childName)));
            } else {
                for (JsonElement childOfChildType : childType.getAsJsonArray()) {
                    this.addChildToParent(childName, childOfChildType, parent);
                }
            }
        } else if (childType.isJsonPrimitive()) {
            JsonPrimitive childPrimitive = childType.getAsJsonPrimitive();
            String value = childPrimitive.getAsString();
            parent.addValue(new SimpleNodeWrapper(this.getNamespaceFor(childName), this.getLocalNameFor(childName), this.resolveValueOfElement(value)));
        }
    }

    private URI getNamespaceFor(String jsonElementName) {
        String[] moduleNameAndLocalName = jsonElementName.split(":");
        if (moduleNameAndLocalName.length != 2) {
            return null;
        }
        return URI.create(moduleNameAndLocalName[0]);
    }

    private String getLocalNameFor(String jsonElementName) {
        String[] moduleNameAndLocalName = jsonElementName.split(":");
        if (moduleNameAndLocalName.length != 2) {
            return jsonElementName;
        }
        return moduleNameAndLocalName[1];
    }

    private Object resolveValueOfElement(String value) {
        IdentityValuesDTO resolvedValue;
        if (value.startsWith("/") && (resolvedValue = RestUtil.asInstanceIdentifier(value, new RestUtil.PrefixMapingFromJson())) != null) {
            return resolvedValue;
        }
        URI namespace = this.getNamespaceFor(value);
        if (namespace != null) {
            return new IdentityValuesDTO(namespace.toString(), this.getLocalNameFor(value), null);
        }
        return value;
    }
}

