/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.impl;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import org.opendaylight.controller.sal.core.api.mount.MountInstance;
import org.opendaylight.controller.sal.rest.impl.RestUtil;
import org.opendaylight.controller.sal.restconf.impl.ControllerContext;
import org.opendaylight.controller.sal.restconf.impl.IdentityValuesDTO;
import org.opendaylight.controller.sal.restconf.impl.RestCodec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnsignedIntegerTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonMapper {
    private final Set<LeafListSchemaNode> foundLeafLists = new HashSet<LeafListSchemaNode>();
    private final Set<ListSchemaNode> foundLists = new HashSet<ListSchemaNode>();
    private MountInstance mountPoint;
    private final Logger logger = LoggerFactory.getLogger(JsonMapper.class);

    JsonMapper() {
    }

    public void write(JsonWriter writer, CompositeNode data, DataNodeContainer schema, MountInstance mountPoint) throws IOException {
        Preconditions.checkNotNull((Object)writer);
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)schema);
        this.mountPoint = mountPoint;
        writer.beginObject();
        if (schema instanceof ContainerSchemaNode) {
            this.writeContainer(writer, data, (ContainerSchemaNode)schema);
        } else if (schema instanceof ListSchemaNode) {
            this.writeList(writer, null, data, (ListSchemaNode)schema);
        } else {
            throw new UnsupportedDataTypeException("Schema can be ContainerSchemaNode or ListSchemaNode. Other types are not supported yet.");
        }
        writer.endObject();
        this.foundLeafLists.clear();
        this.foundLists.clear();
    }

    private void writeChildrenOfParent(JsonWriter writer, CompositeNode parent, DataNodeContainer parentSchema) throws IOException {
        DataSchemaNode childSchema;
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)parentSchema);
        for (Node child : parent.getChildren()) {
            childSchema = this.findFirstSchemaForNode(child, parentSchema.getChildNodes());
            if (childSchema == null) {
                throw new UnsupportedDataTypeException("Probably the data node \"" + child.getNodeType().getLocalName() + "\" is not conform to schema");
            }
            if (childSchema instanceof ContainerSchemaNode) {
                Preconditions.checkState((boolean)(child instanceof CompositeNode), (Object)("Data representation of Container should be CompositeNode - " + child.getNodeType()));
                this.writeContainer(writer, (CompositeNode)child, (ContainerSchemaNode)childSchema);
                continue;
            }
            if (childSchema instanceof ListSchemaNode) {
                if (this.foundLists.contains(childSchema)) continue;
                Preconditions.checkState((boolean)(child instanceof CompositeNode), (Object)("Data representation of List should be CompositeNode - " + child.getNodeType()));
                this.foundLists.add((ListSchemaNode)childSchema);
                this.writeList(writer, parent, (CompositeNode)child, (ListSchemaNode)childSchema);
                continue;
            }
            if (childSchema instanceof LeafListSchemaNode) {
                if (this.foundLeafLists.contains(childSchema)) continue;
                Preconditions.checkState((boolean)(child instanceof SimpleNode), (Object)("Data representation of LeafList should be SimpleNode - " + child.getNodeType()));
                this.foundLeafLists.add((LeafListSchemaNode)childSchema);
                this.writeLeafList(writer, parent, (SimpleNode)child, (LeafListSchemaNode)childSchema);
                continue;
            }
            if (childSchema instanceof LeafSchemaNode) {
                Preconditions.checkState((boolean)(child instanceof SimpleNode), (Object)("Data representation of LeafList should be SimpleNode - " + child.getNodeType()));
                this.writeLeaf(writer, (SimpleNode)child, (LeafSchemaNode)childSchema);
                continue;
            }
            throw new UnsupportedDataTypeException("Schema can be ContainerSchemaNode, ListSchemaNode, LeafListSchemaNode, or LeafSchemaNode. Other types are not supported yet.");
        }
        for (Node child : parent.getChildren()) {
            childSchema = this.findFirstSchemaForNode(child, parentSchema.getChildNodes());
            if (childSchema instanceof LeafListSchemaNode) {
                this.foundLeafLists.remove((LeafListSchemaNode)childSchema);
                continue;
            }
            if (!(childSchema instanceof ListSchemaNode)) continue;
            this.foundLists.remove((ListSchemaNode)childSchema);
        }
    }

    private DataSchemaNode findFirstSchemaForNode(Node<?> node, Set<DataSchemaNode> dataSchemaNode) {
        for (DataSchemaNode dsn : dataSchemaNode) {
            if (node.getNodeType().getLocalName().equals(dsn.getQName().getLocalName())) {
                return dsn;
            }
            if (!(dsn instanceof ChoiceNode)) continue;
            for (ChoiceCaseNode choiceCase : ((ChoiceNode)dsn).getCases()) {
                DataSchemaNode foundDsn = this.findFirstSchemaForNode(node, choiceCase.getChildNodes());
                if (foundDsn == null) continue;
                return foundDsn;
            }
        }
        return null;
    }

    private void writeContainer(JsonWriter writer, CompositeNode node, ContainerSchemaNode schema) throws IOException {
        this.writeName((Node<?>)node, (DataSchemaNode)schema, writer);
        writer.beginObject();
        this.writeChildrenOfParent(writer, node, (DataNodeContainer)schema);
        writer.endObject();
    }

    private void writeList(JsonWriter writer, CompositeNode nodeParent, CompositeNode node, ListSchemaNode schema) throws IOException {
        this.writeName((Node<?>)node, (DataSchemaNode)schema, writer);
        writer.beginArray();
        if (nodeParent != null) {
            List nodeLists = nodeParent.getCompositesByName(node.getNodeType());
            for (CompositeNode nodeList : nodeLists) {
                writer.beginObject();
                this.writeChildrenOfParent(writer, nodeList, (DataNodeContainer)schema);
                writer.endObject();
            }
        } else {
            writer.beginObject();
            this.writeChildrenOfParent(writer, node, (DataNodeContainer)schema);
            writer.endObject();
        }
        writer.endArray();
    }

    private void writeLeafList(JsonWriter writer, CompositeNode nodeParent, SimpleNode<?> node, LeafListSchemaNode schema) throws IOException {
        this.writeName((Node<?>)node, (DataSchemaNode)schema, writer);
        writer.beginArray();
        List nodeLeafLists = nodeParent.getSimpleNodesByName(node.getNodeType());
        for (SimpleNode nodeLeafList : nodeLeafLists) {
            this.writeValueOfNodeByType(writer, nodeLeafList, schema.getType(), (DataSchemaNode)schema);
        }
        writer.endArray();
    }

    private void writeLeaf(JsonWriter writer, SimpleNode<?> node, LeafSchemaNode schema) throws IOException {
        this.writeName((Node<?>)node, (DataSchemaNode)schema, writer);
        this.writeValueOfNodeByType(writer, node, schema.getType(), (DataSchemaNode)schema);
    }

    private void writeValueOfNodeByType(JsonWriter writer, SimpleNode<?> node, TypeDefinition<?> type, DataSchemaNode schema) throws IOException {
        TypeDefinition<?> baseType = RestUtil.resolveBaseTypeFrom(type);
        if (node.getValue() == null && !(baseType instanceof EmptyTypeDefinition)) {
            this.logger.debug("While generationg JSON output null value was found for type " + baseType.getClass().getSimpleName() + ".");
        }
        if (baseType instanceof IdentityrefTypeDefinition) {
            if (node.getValue() instanceof QName) {
                IdentityValuesDTO valueDTO = (IdentityValuesDTO)RestCodec.from(baseType, this.mountPoint).serialize(node.getValue());
                IdentityValuesDTO.IdentityValue valueFromDTO = valueDTO.getValuesWithNamespaces().get(0);
                String moduleName = this.mountPoint != null ? ControllerContext.getInstance().findModuleNameByNamespace(this.mountPoint, URI.create(valueFromDTO.getNamespace())) : ControllerContext.getInstance().findModuleNameByNamespace(URI.create(valueFromDTO.getNamespace()));
                writer.value(moduleName + ":" + valueFromDTO.getValue());
            } else {
                this.writeStringRepresentation(writer, node, baseType, QName.class);
            }
        } else if (baseType instanceof InstanceIdentifierTypeDefinition) {
            if (node.getValue() instanceof InstanceIdentifier) {
                IdentityValuesDTO valueDTO = (IdentityValuesDTO)RestCodec.from(baseType, this.mountPoint).serialize(node.getValue());
                this.writeIdentityValuesDTOToJson(writer, valueDTO);
            } else {
                this.writeStringRepresentation(writer, node, baseType, InstanceIdentifier.class);
            }
        } else if (baseType instanceof DecimalTypeDefinition || baseType instanceof IntegerTypeDefinition || baseType instanceof UnsignedIntegerTypeDefinition) {
            writer.value((Number)new NumberForJsonWriter((String)RestCodec.from(baseType, this.mountPoint).serialize(node.getValue())));
        } else if (baseType instanceof BooleanTypeDefinition) {
            writer.value(Boolean.parseBoolean((String)RestCodec.from(baseType, this.mountPoint).serialize(node.getValue())));
        } else if (baseType instanceof EmptyTypeDefinition) {
            this.writeEmptyDataTypeToJson(writer);
        } else {
            String value = String.valueOf(RestCodec.from(baseType, this.mountPoint).serialize(node.getValue()));
            if (value == null) {
                value = String.valueOf(node.getValue());
            }
            writer.value(value.equals("null") ? "" : value);
        }
    }

    private void writeIdentityValuesDTOToJson(JsonWriter writer, IdentityValuesDTO valueDTO) throws IOException {
        StringBuilder result = new StringBuilder();
        for (IdentityValuesDTO.IdentityValue identityValue : valueDTO.getValuesWithNamespaces()) {
            result.append("/");
            this.writeModuleNameAndIdentifier(result, identityValue);
            if (identityValue.getPredicates() == null) continue;
            for (IdentityValuesDTO.Predicate predicate : identityValue.getPredicates()) {
                IdentityValuesDTO.IdentityValue identityValuePredicate = predicate.getName();
                result.append("[");
                this.writeModuleNameAndIdentifier(result, identityValuePredicate);
                result.append("=\"");
                result.append(predicate.getValue());
                result.append("\"");
                result.append("]");
            }
        }
        writer.value(result.toString());
    }

    private void writeModuleNameAndIdentifier(StringBuilder result, IdentityValuesDTO.IdentityValue identityValue) {
        String moduleName = ControllerContext.getInstance().findModuleNameByNamespace(URI.create(identityValue.getNamespace()));
        if (moduleName != null && !moduleName.isEmpty()) {
            result.append(moduleName);
            result.append(":");
        }
        result.append(identityValue.getValue());
    }

    private void writeStringRepresentation(JsonWriter writer, SimpleNode<?> node, TypeDefinition<?> baseType, Class<?> requiredType) throws IOException {
        Object value = node.getValue();
        this.logger.debug("Value of " + baseType.getQName().getNamespace() + ":" + baseType.getQName().getLocalName() + " is not instance of " + requiredType.getClass() + " but is " + node.getValue().getClass());
        if (value == null) {
            writer.value("");
        } else {
            writer.value(String.valueOf(value));
        }
    }

    private void writeEmptyDataTypeToJson(JsonWriter writer) throws IOException {
        writer.beginArray();
        writer.nullValue();
        writer.endArray();
    }

    private void writeName(Node<?> node, DataSchemaNode schema, JsonWriter writer) throws IOException {
        ControllerContext contContext;
        CharSequence moduleName;
        String nameForOutput = node.getNodeType().getLocalName();
        if (schema.isAugmenting() && (moduleName = (contContext = ControllerContext.getInstance()).toRestconfIdentifier(schema.getQName())) != null) {
            nameForOutput = moduleName.toString();
        }
        writer.name(nameForOutput);
    }

    private static final class NumberForJsonWriter
    extends Number {
        private static final long serialVersionUID = -3147729419814417666L;
        private final String value;

        public NumberForJsonWriter(String value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            throw new IllegalStateException("Should not be invoked");
        }

        @Override
        public long longValue() {
            throw new IllegalStateException("Should not be invoked");
        }

        @Override
        public float floatValue() {
            throw new IllegalStateException("Should not be invoked");
        }

        @Override
        public double doubleValue() {
            throw new IllegalStateException("Should not be invoked");
        }

        public String toString() {
            return this.value;
        }
    }
}

