/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opendaylight.controller.sal.rest.api.RestconfServiceLegacy;
import org.opendaylight.controller.sal.restconf.impl.StructuredData;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;

@Path(value="/")
public interface RestconfService
extends RestconfServiceLegacy {
    public static final String XML = "+xml";
    public static final String JSON = "+json";

    @GET
    public Object getRoot();

    @GET
    @Path(value="/modules")
    @Produces(value={"application/vnd.yang.api+json", "application/vnd.yang.api+xml", "application/yang.api+json", "application/yang.api+xml"})
    public StructuredData getModules();

    @POST
    @Path(value="/operations/{identifier}")
    @Produces(value={"application/vnd.yang.data+json", "application/vnd.yang.data+xml", "application/yang.data+json", "application/yang.data+xml", "application/json", "application/xml", "text/xml"})
    @Consumes(value={"application/vnd.yang.data+json", "application/vnd.yang.data+xml", "application/yang.data+json", "application/yang.data+xml", "application/json", "application/xml", "text/xml"})
    public StructuredData invokeRpc(@PathParam(value="identifier") String var1, CompositeNode var2);

    @POST
    @Path(value="/operations/{identifier}")
    @Produces(value={"application/vnd.yang.data+json", "application/vnd.yang.data+xml", "application/yang.data+json", "application/yang.data+xml", "application/json", "application/xml", "text/xml"})
    public StructuredData invokeRpc(@PathParam(value="identifier") String var1);

    @GET
    @Path(value="/config/{identifier:.+}")
    @Produces(value={"application/yang.data+json", "application/yang.data+xml", "application/json", "application/xml", "text/xml"})
    public StructuredData readConfigurationData(@PathParam(value="identifier") String var1);

    @GET
    @Path(value="/operational/{identifier:.+}")
    @Produces(value={"application/yang.data+json", "application/yang.data+xml", "application/json", "application/xml", "text/xml"})
    public StructuredData readOperationalData(@PathParam(value="identifier") String var1);

    @PUT
    @Path(value="/config/{identifier:.+}")
    @Consumes(value={"application/yang.data+json", "application/yang.data+xml", "application/json", "application/xml", "text/xml"})
    public Response updateConfigurationData(@PathParam(value="identifier") String var1, CompositeNode var2);

    @POST
    @Path(value="/config/{identifier:.+}")
    @Consumes(value={"application/yang.data+json", "application/yang.data+xml", "application/json", "application/xml", "text/xml"})
    public Response createConfigurationData(@PathParam(value="identifier") String var1, CompositeNode var2);

    @POST
    @Path(value="/config")
    @Consumes(value={"application/yang.data+json", "application/yang.data+xml", "application/json", "application/xml", "text/xml"})
    public Response createConfigurationData(CompositeNode var1);

    @DELETE
    @Path(value="/config/{identifier:.+}")
    public Response deleteConfigurationData(@PathParam(value="identifier") String var1);
}

