/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.netty.hashed.wheel.timer.ThreadFactory;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NettyHashedWheelTimerBuilder {
    private ThreadFactory _threadFactory;
    private Long _tickDuration;
    private Integer _ticksPerWheel;
    private Map<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>> augmentation = new HashMap<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>>();

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public Long getTickDuration() {
        return this._tickDuration;
    }

    public Integer getTicksPerWheel() {
        return this._ticksPerWheel;
    }

    public <E extends Augmentation<NettyHashedWheelTimer>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NettyHashedWheelTimerBuilder setThreadFactory(ThreadFactory value) {
        this._threadFactory = value;
        return this;
    }

    public NettyHashedWheelTimerBuilder setTickDuration(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tickDuration = value;
        return this;
    }

    public NettyHashedWheelTimerBuilder setTicksPerWheel(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._ticksPerWheel = value;
        return this;
    }

    public NettyHashedWheelTimerBuilder addAugmentation(Class<? extends Augmentation<NettyHashedWheelTimer>> augmentationType, Augmentation<NettyHashedWheelTimer> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NettyHashedWheelTimer build() {
        return new NettyHashedWheelTimerImpl(this);
    }

    private static final class NettyHashedWheelTimerImpl
    implements NettyHashedWheelTimer {
        private final ThreadFactory _threadFactory;
        private final Long _tickDuration;
        private final Integer _ticksPerWheel;
        private Map<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>> augmentation = new HashMap<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>>();

        public Class<NettyHashedWheelTimer> getImplementedInterface() {
            return NettyHashedWheelTimer.class;
        }

        private NettyHashedWheelTimerImpl(NettyHashedWheelTimerBuilder builder) {
            this._threadFactory = builder.getThreadFactory();
            this._tickDuration = builder.getTickDuration();
            this._ticksPerWheel = builder.getTicksPerWheel();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this._threadFactory;
        }

        @Override
        public Long getTickDuration() {
            return this._tickDuration;
        }

        @Override
        public Integer getTicksPerWheel() {
            return this._ticksPerWheel;
        }

        public <E extends Augmentation<NettyHashedWheelTimer>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._threadFactory == null ? 0 : this._threadFactory.hashCode());
            result = 31 * result + (this._tickDuration == null ? 0 : this._tickDuration.hashCode());
            result = 31 * result + (this._ticksPerWheel == null ? 0 : this._ticksPerWheel.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NettyHashedWheelTimerImpl other = (NettyHashedWheelTimerImpl)obj;
            if (this._threadFactory == null ? other._threadFactory != null : !this._threadFactory.equals(other._threadFactory)) {
                return false;
            }
            if (this._tickDuration == null ? other._tickDuration != null : !this._tickDuration.equals(other._tickDuration)) {
                return false;
            }
            if (this._ticksPerWheel == null ? other._ticksPerWheel != null : !this._ticksPerWheel.equals(other._ticksPerWheel)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NettyHashedWheelTimer [_threadFactory=");
            builder.append(this._threadFactory);
            builder.append(", _tickDuration=");
            builder.append(this._tickDuration);
            builder.append(", _ticksPerWheel=");
            builder.append(this._ticksPerWheel);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

